//package com.bizvane.utils.huaweiutils;
//
//import com.alibaba.fastjson.JSON;
//import com.obs.services.ObsClient;
//import com.obs.services.exception.ObsException;
//import com.obs.services.model.AccessControlList;
//import com.obs.services.model.PutObjectResult;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.beans.factory.annotation.Value;
//import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
//import org.springframework.stereotype.Component;
//import java.io.IOException;
//import java.io.InputStream;
//import java.net.MalformedURLException;
//import java.net.URL;
//
///**
// * @author chen.li
// * @date on 2019/11/20 10:27
// * @description 华为云obs存储对象操作工具类
// * 操作方法与七牛云的方法保持一致，尽可能不动原有方法定义，减少改动
// */
//@ConditionalOnProperty(name = "huaweicloud.obs.domain")
//@Component
//@Slf4j
//public class ObsUtil {
//
//    @Value("${huaweicloud.obs.domain}")
//    private String domain;
//
//    @Value("${huaweicloud.obs.bucketName}")
//    private String bucketName;
//
//    @Value("${huaweicloud.obs.accessKey}")
//    private String accessKey;
//
//    @Value("${huaweicloud.obs.secretKey}")
//    private String secretKey;
//
//    public ObsClient getObsClient(){
//        // 创建ObsClient实例
//        return new ObsClient(accessKey, secretKey, domain);
//    }
//
//    /**
//     * 上传输入流
//     * @param inputStream
//     * @param objectName
//     * @return
//     */
//    public String upload(InputStream inputStream,String objectName){
//        ObsClient obsClient = null;
//        try {
//            //获取客户端
//            obsClient= getObsClient();
//            //上传输入流
//            PutObjectResult putObjectResult = obsClient.putObject(bucketName, objectName, inputStream);
//            log.info("ObsUtil#upload putObjectResult:{}", JSON.toJSONString(putObjectResult));
//            //设置公开只读权限
//            obsClient.setObjectAcl(bucketName, objectName, AccessControlList.REST_CANNED_PUBLIC_READ);
//            return domain+"/"+objectName;
//        } catch (ObsException e) {
//            log.error("ObsUtil#upload ObsException error:{}",e.getMessage());
//        }finally{
//            // 关闭ObsClient实例，如果是全局ObsClient实例，可以不在每个方法调用完成后关闭
//            // ObsClient在调用ObsClient.close方法关闭后不能再次使用
//            if(obsClient != null){
//                try {
//                    obsClient.close();
//                }
//                catch (IOException e) {
//                    log.error("ObsUtil#upload IOException error:{}",e.getMessage());
//                }
//            }
//        }
//        return null;
//    }
//
//    /**
//     * 通过url形式上传
//     * @param url
//     * @param objectName
//     * @return
//     */
//    public String uploadUrl(String url,String objectName){
//        ObsClient obsClient = null;
//        try {
//            //获取客户端
//            obsClient= getObsClient();
//            //上传输入流
//            PutObjectResult putObjectResult = obsClient.putObject(bucketName, objectName, new URL(url).openStream());
//            log.info("ObsUtil#upload putObjectResult:{}", JSON.toJSONString(putObjectResult));
//            //设置公开只读权限
//            obsClient.setObjectAcl(bucketName, objectName, AccessControlList.REST_CANNED_PUBLIC_READ);
//            return domain+"/"+objectName;
//        } catch (ObsException e) {
//            log.error("ObsUtil#upload ObsException error:{}",e.getMessage());
//        } catch (MalformedURLException e) {
//            log.error("ObsUtil#upload MalformedURLException error:{}",e.getMessage());
//        } catch (IOException e) {
//            log.error("ObsUtil#upload IOException error:{}",e.getMessage());
//        } finally{
//            // 关闭ObsClient实例，如果是全局ObsClient实例，可以不在每个方法调用完成后关闭
//            // ObsClient在调用ObsClient.close方法关闭后不能再次使用
//            if(obsClient != null){
//                try {
//                    obsClient.close();
//                }
//                catch (IOException e) {
//                    log.error("ObsUtil#upload IOException error:{}",e.getMessage());
//                }
//            }
//        }
//        return null;
//    }
//
//    /**
//     * 上传输入流，返回不带前缀的url
//     * @param url
//     * @param objectName
//     * @return
//     */
//    public String uploadRelativeUrl(String url,String objectName){
//        ObsClient obsClient = null;
//        try {
//            //获取客户端
//            obsClient= getObsClient();
//            //上传输入流
//            PutObjectResult putObjectResult = obsClient.putObject(bucketName, objectName, new URL(url).openStream());
//            log.info("ObsUtil#upload putObjectResult:{}", JSON.toJSONString(putObjectResult));
//            //设置公开只读权限
//            obsClient.setObjectAcl(bucketName, objectName, AccessControlList.REST_CANNED_PUBLIC_READ);
//            return objectName;
//        } catch (ObsException e) {
//            log.error("ObsUtil#upload ObsException error:{}",e.getMessage());
//        } catch (MalformedURLException e) {
//            log.error("ObsUtil#upload MalformedURLException error:{}",e.getMessage());
//        } catch (IOException e) {
//            log.error("ObsUtil#upload IOException error:{}",e.getMessage());
//        } finally{
//            // 关闭ObsClient实例，如果是全局ObsClient实例，可以不在每个方法调用完成后关闭
//            // ObsClient在调用ObsClient.close方法关闭后不能再次使用
//            if(obsClient != null){
//                try {
//                    obsClient.close();
//                }
//                catch (IOException e) {
//                    log.error("ObsUtil#upload IOException error:{}",e.getMessage());
//                }
//            }
//        }
//        return null;
//    }
//
//}
