/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane;

import com.bizvane.utils.commonutils.AsyncHttpUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JedisTest {
    private static final int COUNT_RUNNER = 20;
    protected static AtomicInteger success = new AtomicInteger(0);
    protected static AtomicInteger fail = new AtomicInteger(0);
    static JedisPool jedisPool;

    public static Jedis getJedis() {
        return jedisPool.getResource();
    }

    public static void main(String[] args) throws Exception {
        Jedis jedis = JedisTest.getJedis();
        jedis.set("key", "10");
        jedis.lpush("key2", new String[]{"a", "a", "a", "a", "a", "a", "a", "a", "a", "a"});
        jedis.close();
        CountDownLatch countDownLatch = new CountDownLatch(20);
        CountDownLatch countDownLatchDone = new CountDownLatch(20);
        ExecutorService executorService = Executors.newFixedThreadPool(20);
        for (int i = 0; i < 19; ++i) {
            executorService.submit(new Runner(countDownLatch, countDownLatchDone));
        }
        try {
            countDownLatchDone.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println(JedisTest.getJedis().get("key"));
        System.out.println(success);
        System.out.println(fail);
    }

    public static boolean releaseLock(String key) {
        String luaScript = "local sum = tonumber(redis.call('get', KEYS[1])) if sum > 0 then redis.call('set', KEYS[1], tostring(sum - 1)) return 1 else return 0 end";
        if (key == null) {
            return false;
        }
        try {
            Jedis jedis = JedisTest.getJedis();
            Object res = jedis.eval(luaScript, Collections.singletonList(key), new ArrayList());
            jedis.close();
            return res != null && res.equals(1L);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(20);
        poolConfig.setMaxIdle(32);
        poolConfig.setMaxWaitMillis(100000L);
        poolConfig.setTestOnBorrow(true);
        jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, "192.168.1.50", 6379, 30000, "bizvane");
    }

    protected static class Runner
    implements Runnable {
        private CountDownLatch countDownLatch;
        private CountDownLatch countDownLatchDone;

        public Runner(CountDownLatch countDownLatch, CountDownLatch countDownLatchDone) {
            this.countDownLatch = countDownLatch;
            this.countDownLatchDone = countDownLatchDone;
        }

        @Override
        public void run() {
            this.countDownLatch.countDown();
            try {
                this.countDownLatch.await();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            for (int i = 0; i < 50000; ++i) {
                AsyncHttpUtil.doPost("localhost:4200/base-services.api/serialNumber/generateIncrId?brand=abc&type=aa", "");
            }
            this.countDownLatchDone.countDown();
        }
    }
}

