/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.autuconfig.traceController;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import com.bizvane.autuconfig.traceController.TraceControllerEntity;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import com.google.common.base.Stopwatch;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;

@Aspect
public class TraceControllerAspect
implements Ordered {
    public static final int TWO_M = 0x200B20;
    public static final String PUBLIC_BIZVANE_SYS_OPERATION_LOG = "public_bizvane_sys_operation_log";
    public static final String TAG_A = "TagA";
    Logger logger = LoggerFactory.getLogger(TraceControllerAspect.class);
    protected final ApplicationContext context;
    protected final Environment env;
    protected final Pattern skipPattern;
    public final String ASPECT = "@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController)";
    @Autowired
    HttpServletRequest request;

    @Around(value="@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController)")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        Object object;
        TraceControllerEntity entity = new TraceControllerEntity();
        String methodName = pjp.getSignature().getName();
        if (this.skipPattern.matcher(methodName).matches()) {
            return pjp.proceed();
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        String applicationName = this.env.getProperty("spring.application.name");
        this.logger.info("\u5e94\u7528\u540d:{}", (Object)applicationName);
        this.logger.info("\u65b9\u6cd5\u540d:{}", (Object)methodName);
        this.logger.info("\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)this.request.getParameterMap()));
        SysAccountPO sysAccountPO = TokenUtils.getStageUser(this.request);
        if (sysAccountPO != null) {
            this.logger.info("\u767b\u9646\u4eba\u4fe1\u606f name:{},code:{}", (Object)(sysAccountPO.getName() != null ? sysAccountPO.getName() : null), (Object)(sysAccountPO.getAccountCode() != null ? sysAccountPO.getAccountCode() : null));
            entity.setLoginName(sysAccountPO.getName());
            entity.setLoginCode(sysAccountPO.getAccountCode());
        }
        Object result = null;
        try {
            object = result = pjp.proceed();
        }
        catch (Exception e) {
            try {
                this.logger.info("\u5f02\u5e38:{}", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                stopwatch.stop();
                this.logger.info("\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)result));
                this.logger.info("\u8017\u65f6:{}", (Object)stopwatch);
                if (StringUtils.startsWithAny((CharSequence)InetAddress.getLocalHost().getHostName(), (CharSequence[])new CharSequence[]{"app", "new"})) {
                    // empty if block
                }
                throw throwable;
            }
        }
        stopwatch.stop();
        this.logger.info("\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)result));
        this.logger.info("\u8017\u65f6:{}", (Object)stopwatch);
        if (StringUtils.startsWithAny((CharSequence)InetAddress.getLocalHost().getHostName(), (CharSequence[])new CharSequence[]{"app", "new"})) {
            // empty if block
        }
        return object;
    }

    public String getRemoteHost(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }

    private void sendLog(TraceControllerEntity entity, String methodName, String applicationName, Object result) {
        Producer producer;
        try {
            producer = (Producer)this.context.getBean("producer");
        }
        catch (Exception e) {
            this.logger.error("\u5ba1\u8ba1\u65e5\u5fd7MQ\u7684\u53d1\u9001\u5bf9\u8c61\u51fa\u73b0\u5f02\u5e38\uff0c\u5219\u4e0d\u505a\u4efb\u4f55\u5904\u7406!");
            return;
        }
        if (producer == null) {
            this.logger.error("\u5ba1\u8ba1\u65e5\u5fd7MQ\u7684\u53d1\u9001\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u5219\u4e0d\u505a\u4efb\u4f55\u5904\u7406!");
            return;
        }
        entity.setApplicationName(applicationName);
        entity.setMethodName(methodName);
        entity.setMethodRequestParam(JSON.toJSONString((Object)this.request.getParameterMap()));
        entity.setMethodResponseParam(JSON.toJSONString((Object)result));
        entity.setClientIP(this.getRemoteHost(this.request));
        try {
            InetAddress address = InetAddress.getLocalHost();
            entity.setServiceIP(address.getHostAddress());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        Long millisecond = Instant.now().toEpochMilli();
        entity.setUpdateTime(millisecond);
        entity.setCreateTime(millisecond);
        Message message = new Message();
        message.setTag(TAG_A);
        message.setTopic(PUBLIC_BIZVANE_SYS_OPERATION_LOG);
        byte[] byteNumber = JacksonUtil.bean2Json(entity).getBytes();
        if (byteNumber.length <= 0x200B20) {
            message.setBody(byteNumber);
        } else {
            message.setBody(TraceControllerAspect.subBytes(byteNumber, 0, 0x200B20));
        }
        SendResult sendResult = producer.send(message);
        this.logger.info("\u53d1\u9001\u6d88\u606f\u8bb0\u5f55\u65e5\u5fd7:{}", (Object)sendResult.toString());
    }

    public static byte[] subBytes(byte[] src, int begin, int count) {
        byte[] bs = new byte[count];
        System.arraycopy(src, begin, bs, 0, count);
        return bs;
    }

    public TraceControllerAspect(ApplicationContext context, Environment env, Pattern skipPattern) {
        this.context = context;
        this.env = env;
        this.skipPattern = skipPattern;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

