/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.tenant;

import com.bizvane.utils.tenant.QuarantineContextHolder;
import com.bizvane.utils.tenant.QuarantineEntity;
import com.bizvane.utils.tokens.JWTUtil;
import com.bizvane.utils.tokens.SysAccountPO;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class QuarantineIntercepts
implements Interceptor {
    public static final String ENABLE_INTERCEPTS = "enableIntercepts";
    public static final String IGNORE_TABLE = "ignoreTable";
    public static final String DISABLE = "disable";
    public static final String ENABLE = "enable";
    public static final Logger log = LoggerFactory.getLogger(QuarantineIntercepts.class);
    public static final String COMPANY_ID = "sys_company_id";
    public static final String SELECT = "select";

    public HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public Object intercept(Invocation invocation) throws Throwable {
        if (this.validatorIntercepts()) {
            return invocation.proceed();
        }
        RoutingStatementHandler handler = (RoutingStatementHandler)invocation.getTarget();
        StatementHandler delegate = (StatementHandler)ReflectUtil.getFieldValue(handler, "delegate");
        BoundSql boundSql = delegate.getBoundSql();
        String obj = boundSql.getSql().replaceAll("[\\s]+", " ").toLowerCase();
        SysAccountPO sysAccountPO = QuarantineIntercepts.getStageUser(this.getRequest());
        if (null != sysAccountPO && null != sysAccountPO.getBrandId() && StringUtils.startsWithIgnoreCase((CharSequence)obj, (CharSequence)SELECT)) {
            String sql = QuarantineIntercepts.buildQuery(obj, sysAccountPO.getBrandId().toString());
            ReflectUtil.setFieldValue(boundSql, "sql", sql);
        }
        return invocation.proceed();
    }

    public static SysAccountPO getStageUser(HttpServletRequest request) {
        String sysAccountPoString = request.getHeader("stageToken");
        return JWTUtil.unsign(sysAccountPoString, SysAccountPO.class);
    }

    public static String addCompanyIdCondition(String coreQuery, String companyId) {
        Select select = QuarantineIntercepts.createSelect(coreQuery);
        Map<String, String> map = QuarantineIntercepts.getTableOnAlias(select);
        if (CollectionUtils.isNotEmpty(QuarantineIntercepts.getAllIgnoreTable())) {
            List<String> list = QuarantineIntercepts.getAllIgnoreTable();
            for (String string : list) {
                if (map.isEmpty() || !map.containsKey(string)) continue;
                return select.toString();
            }
        }
        String alias = "";
        EqualsTo equalsTo = new EqualsTo();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)entry.getValue())) continue;
            alias = entry.getValue();
            break;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (StringUtils.isNotBlank((CharSequence)alias) && !"${}".equals(alias)) {
            stringBuffer.append(alias).append(".").append(COMPANY_ID);
        } else {
            stringBuffer.append(COMPANY_ID);
        }
        equalsTo.setLeftExpression((Expression)new Column(stringBuffer.toString()));
        equalsTo.setRightExpression((Expression)new LongValue(companyId));
        QuarantineIntercepts.addWhereCondition(select, (Expression)equalsTo);
        return select.toString();
    }

    private static Map<String, String> getTableOnAlias(Select select) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        PlainSelect plainSelect = QuarantineIntercepts.getPlainSelect(select);
        Table table = (Table)plainSelect.getFromItem();
        if (null != table.getAlias() && StringUtils.isNotBlank((CharSequence)table.getAlias().getName())) {
            map.put(table.getName(), table.getAlias().getName());
        } else {
            map.put(table.getName(), "${}");
        }
        if (null != plainSelect.getJoins()) {
            for (Join join : plainSelect.getJoins()) {
                Table rightItem = (Table)join.getRightItem();
                if (rightItem.getAlias() == null || StringUtils.isBlank((CharSequence)rightItem.getAlias().getName())) {
                    map.put(rightItem.getName(), "${}");
                    continue;
                }
                map.put(rightItem.getName(), rightItem.getAlias().getName());
            }
        }
        return map;
    }

    public static String buildQuery(String sql, String condition) {
        return QuarantineIntercepts.addCompanyIdCondition(sql, condition);
    }

    public static Select createSelect(String sql) {
        try {
            return (Select)CCJSqlParserUtil.parse((String)sql);
        }
        catch (JSQLParserException e) {
            throw new IllegalStateException("SQL parsing problem!", e);
        }
    }

    public static void addWhereCondition(Select select, Expression condition) {
        QuarantineIntercepts.addWhereCondition(QuarantineIntercepts.getPlainSelect(select), condition);
    }

    private static void addWhereCondition(PlainSelect plainSelect, Expression condition) {
        if (plainSelect.getWhere() == null) {
            plainSelect.setWhere(condition);
            return;
        }
        AndExpression andExpression = new AndExpression(plainSelect.getWhere(), condition);
        plainSelect.setWhere((Expression)andExpression);
    }

    private static PlainSelect getPlainSelect(Select select) {
        if (select.getSelectBody() instanceof PlainSelect) {
            return (PlainSelect)select.getSelectBody();
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public static List<String> getAllIgnoreTable() {
        if (QuarantineIntercepts.isaBoolean()) {
            return null;
        }
        return Arrays.asList(StringUtils.split((String)QuarantineContextHolder.getQuarantine.getIgnoreTable().toLowerCase(), (String)","));
    }

    private boolean validatorIntercepts() {
        if (null == QuarantineContextHolder.getQuarantine || StringUtils.isBlank((CharSequence)QuarantineContextHolder.getQuarantine.getEnableIntercepts()) || DISABLE.equals(QuarantineContextHolder.getQuarantine.getEnableIntercepts())) {
            return true;
        }
        return !ENABLE.equals(QuarantineContextHolder.getQuarantine.getEnableIntercepts());
    }

    private static boolean isaBoolean() {
        return null == QuarantineContextHolder.getQuarantine || null == QuarantineContextHolder.getQuarantine.getIgnoreTable();
    }

    public void setProperties(Properties properties) {
        QuarantineEntity quarantineEntity = new QuarantineEntity();
        quarantineEntity.setEnableIntercepts((String)properties.get(ENABLE_INTERCEPTS));
        quarantineEntity.setIgnoreTable((String)properties.get(IGNORE_TABLE));
        QuarantineContextHolder.setQuarantineEntity(quarantineEntity);
    }

    private static class ReflectUtil {
        private ReflectUtil() {
        }

        public static Object getFieldValue(Object obj, String fieldName) {
            Object result = null;
            Field field = ReflectUtil.getField(obj, fieldName);
            if (field != null) {
                field.setAccessible(true);
                try {
                    result = field.get(obj);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return result;
        }

        private static Field getField(Object obj, String fieldName) {
            Field field = null;
            for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    field = clazz.getDeclaredField(fieldName);
                    break;
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            return field;
        }

        public static void setFieldValue(Object obj, String fieldName, String fieldValue) {
            Field field = ReflectUtil.getField(obj, fieldName);
            if (field != null) {
                try {
                    field.setAccessible(true);
                    field.set(obj, fieldValue);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

