/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.tenant;

import com.bizvane.utils.tenant.TenantNotInterceptor;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.yaml.snakeyaml.Yaml;

@Component
@Intercepts(value={@Signature(method="prepare", type=StatementHandler.class, args={Connection.class, Integer.class})})
public class TenantInterceptor
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(TenantInterceptor.class);
    private static final String START_KEY = " start ";
    private static final String TOKEN_KEY = " token ";
    private static final String END_KEY = " end ";
    private static final String LOG_FORMAT_KEY = "{}:{}";
    private static final String WHERE_KEY = " WHERE ";
    private static final String LIMIT_KEY = " LIMIT ";
    private String TENANT_KEY = " sys_company_id =  ";
    private String COMMAND_TYPE = "SELECT";
    private String TENANT_KEY_TEMP = " sys_company_id =  ";
    private static final String MAPPED_STATEMENT = "delegate.mappedStatement";
    private static final String IS_ENABLED_TENANT_INTERCEPTOR = "tenant.isEnabledTenantInterceptor";
    private static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    private static final String REGEX_PATTERN = "\\bfrom\\b(\\s)*\\b(\\s)*.+?(\\r|\\n)*\\s*.*?\\b(inner|where|left|limit)\\b";
    private static final String REGEX_EXISTS_PATTERN = "\\b(\\.)sys_company_id\\s*=\\s*";
    private static final Pattern PATTERN = Pattern.compile("\\bfrom\\b(\\s)*\\b(\\s)*.+?(\\r|\\n)*\\s*.*?\\b(inner|where|left|limit)\\b", 2);
    private static final Pattern EXISTS_PATTERN = Pattern.compile("\\b(\\.)sys_company_id\\s*=\\s*", 2);
    private static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    private static final ReflectorFactory DEFAULT_REFLECTOR_FACTORY = new DefaultReflectorFactory();
    private ServletRequestAttributes SERVLET_REQUEST_ATTRIBUTES = null;
    private long SYS_COMPANY_ID = 0L;
    private String BOUND_SQL = "";
    private String MATCHER_SQL = "";
    private Matcher MATCHER = null;
    private SysAccountPO SYS_ACCOUNT_PO = null;
    private Yaml yaml = new Yaml();
    private static final ArrayList<String> FIXED_PREFIX = new ArrayList<String>(){
        {
            this.add("goods_");
            this.add("order_");
            this.add("t_");
            this.add("zzz_");
        }
    };

    public Object intercept(Invocation invocation) throws Throwable {
        block8: {
            try {
                Object object;
                if (!(invocation.getTarget() instanceof StatementHandler)) break block8;
                StatementHandler handler = (StatementHandler)invocation.getTarget();
                MetaObject metaStatementHandler = MetaObject.forObject((Object)handler, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
                while (metaStatementHandler.hasGetter("h")) {
                    object = metaStatementHandler.getValue("h");
                    metaStatementHandler = MetaObject.forObject((Object)object, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
                }
                while (metaStatementHandler.hasGetter("target")) {
                    object = metaStatementHandler.getValue("target");
                    metaStatementHandler = MetaObject.forObject((Object)object, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
                }
                this.BOUND_SQL = handler.getBoundSql().getSql();
                MappedStatement mappedStatement = (MappedStatement)metaStatementHandler.getValue(MAPPED_STATEMENT);
                if (!mappedStatement.getSqlCommandType().name().equals(this.COMMAND_TYPE) || this.checkExistsTenant() || !Objects.equals(this.getAnnotation(mappedStatement.getId()), null) || !this.checkEnabled()) break block8;
                this.SERVLET_REQUEST_ATTRIBUTES = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                try {
                    this.SYS_ACCOUNT_PO = TokenUtils.getStageUser(this.SERVLET_REQUEST_ATTRIBUTES.getRequest());
                }
                catch (Exception ex) {
                    this.SYS_ACCOUNT_PO = new SysAccountPO();
                    ex.printStackTrace();
                }
                logger.info(LOG_FORMAT_KEY, (Object)TOKEN_KEY, (Object)new ObjectMapper().writeValueAsString((Object)this.SYS_ACCOUNT_PO));
                if (null != this.SYS_ACCOUNT_PO && null != this.SYS_ACCOUNT_PO.getSysCompanyId() && 0L < this.SYS_ACCOUNT_PO.getSysCompanyId()) {
                    this.SYS_COMPANY_ID = this.SYS_ACCOUNT_PO.getSysCompanyId();
                    logger.info(LOG_FORMAT_KEY, (Object)START_KEY, (Object)this.BOUND_SQL);
                    this.MATCHER = PATTERN.matcher(this.BOUND_SQL);
                    if (this.MATCHER.find()) {
                        this.MATCHER_SQL = this.MATCHER.group();
                    }
                    this.BOUND_SQL = this.parseSql(this.parseMatcherSql(this.MATCHER_SQL));
                    FieldUtils.writeField((Object)handler.getBoundSql(), (String)"sql", (Object)this.BOUND_SQL, (boolean)true);
                    logger.info(LOG_FORMAT_KEY, (Object)END_KEY, (Object)this.BOUND_SQL);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return invocation.proceed();
    }

    private Annotation getAnnotation(String namespace) {
        try {
            TenantNotInterceptor annotation = null;
            if (!StringUtils.isEmpty((CharSequence)namespace)) {
                Method[] methods;
                String className = namespace.substring(0, namespace.lastIndexOf(46));
                String methodName = namespace.substring(namespace.lastIndexOf(46) + 1, namespace.length());
                for (Method method : methods = Class.forName(className).getMethods()) {
                    if (!method.getName().equals(methodName)) continue;
                    annotation = method.getAnnotation(TenantNotInterceptor.class);
                    break;
                }
            }
            return annotation;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String parseMatcherSql(String matcherSql) {
        String aliasName = "";
        if (StringUtils.isEmpty((CharSequence)matcherSql)) {
            String[] strings = this.BOUND_SQL.substring(StringUtils.indexOfIgnoreCase((CharSequence)this.BOUND_SQL, (CharSequence)"FROM") + 4).trim().split("\\s+");
            if (1 == strings.length) {
                return strings[0].trim();
            }
            return strings[strings.length - 1];
        }
        String[] strings = matcherSql.split("\\s+");
        if (1 == strings.length) {
            return strings[0];
        }
        if (2 == strings.length || 3 == strings.length) {
            aliasName = strings[1].trim();
        } else if (4 == strings.length && !FIXED_PREFIX.contains(strings[2].substring(0, strings[2].indexOf("_") + 1))) {
            aliasName = strings[2].trim();
        } else if (5 == strings.length && !FIXED_PREFIX.contains(strings[3].substring(0, strings[3].indexOf("_") + 1))) {
            aliasName = strings[3].trim();
        }
        return aliasName;
    }

    private boolean checkEnabled() {
        if (System.getProperties().containsKey(IS_ENABLED_TENANT_INTERCEPTOR)) {
            return Boolean.valueOf(System.getProperty(IS_ENABLED_TENANT_INTERCEPTOR));
        }
        Map map = (Map)this.yaml.load(TenantInterceptor.class.getClassLoader().getResourceAsStream("application.yml"));
        if (map.containsKey("tenant")) {
            return Boolean.valueOf(((Map)map.get("tenant")).get("isEnabledTenantInterceptor").toString());
        }
        return true;
    }

    private boolean checkExistsTenant() {
        return EXISTS_PATTERN.matcher(this.BOUND_SQL).find();
    }

    private String parseSql(String matcherSql) {
        if (this.BOUND_SQL.lastIndexOf(matcherSql.concat(".").concat(this.TENANT_KEY.trim()).concat(String.valueOf(this.SYS_COMPANY_ID))) > 0) {
            return this.BOUND_SQL;
        }
        this.TENANT_KEY = StringUtils.isNotBlank((CharSequence)matcherSql) && this.BOUND_SQL.lastIndexOf(matcherSql.concat(".").concat(this.TENANT_KEY.trim()).concat(String.valueOf(this.SYS_COMPANY_ID)).concat(" AND ")) < 0 && StringUtils.indexOfIgnoreCase((CharSequence)this.BOUND_SQL, (CharSequence)WHERE_KEY) > 0 ? matcherSql.concat(".").concat(this.TENANT_KEY.trim()).concat(String.valueOf(this.SYS_COMPANY_ID)).concat(" AND ") : (StringUtils.isNotBlank((CharSequence)matcherSql) ? matcherSql.concat(".").concat(this.TENANT_KEY.trim()).concat(String.valueOf(this.SYS_COMPANY_ID)) : (StringUtils.indexOfIgnoreCase((CharSequence)this.BOUND_SQL, (CharSequence)WHERE_KEY) > 0 ? this.TENANT_KEY.trim().concat(String.valueOf(this.SYS_COMPANY_ID)).concat(" AND ") : this.TENANT_KEY.trim().concat(String.valueOf(this.SYS_COMPANY_ID))));
        if (StringUtils.indexOfIgnoreCase((CharSequence)this.BOUND_SQL, (CharSequence)WHERE_KEY) > 0 && StringUtils.indexOfIgnoreCase((CharSequence)this.BOUND_SQL, (CharSequence)this.TENANT_KEY.trim()) < 0) {
            this.BOUND_SQL = StringUtils.replaceIgnoreCase((String)this.BOUND_SQL, (String)WHERE_KEY, (String)WHERE_KEY.concat(this.TENANT_KEY));
        } else if (StringUtils.indexOfIgnoreCase((CharSequence)this.BOUND_SQL, (CharSequence)WHERE_KEY) < 0 && StringUtils.indexOfIgnoreCase((CharSequence)this.BOUND_SQL, (CharSequence)LIMIT_KEY) > 0) {
            this.BOUND_SQL = StringUtils.replaceIgnoreCase((String)this.BOUND_SQL, (String)LIMIT_KEY, (String)WHERE_KEY.concat(this.TENANT_KEY.concat(LIMIT_KEY)));
        } else if (StringUtils.indexOfIgnoreCase((CharSequence)this.BOUND_SQL, (CharSequence)this.TENANT_KEY.trim()) < 0) {
            this.BOUND_SQL = this.BOUND_SQL.concat(WHERE_KEY.concat(this.TENANT_KEY));
        }
        this.TENANT_KEY = this.TENANT_KEY_TEMP;
        return this.BOUND_SQL;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

