/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.jobutils;

import com.bizvane.utils.enumutils.JobEnum;
import com.bizvane.utils.jobutils.JobClient;
import com.bizvane.utils.jobutils.XxlJobInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class XxlJobUtil {
    @Autowired
    private JobClient jobClient;

    public void addJob(Date execuDate, String desc, String param, String author, String jobHandler, int businessType, String bizCode, String appName) {
        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        xxlJobInfo.setAppName(appName);
        xxlJobInfo.setExecutorRouteStrategy(JobEnum.EXECUTOR_ROUTE_STRATEGY_FIRST.getValue());
        xxlJobInfo.setJobCron(XxlJobUtil.getCronExpression(execuDate));
        xxlJobInfo.setGlueType(JobEnum.GLUE_TYPE_BEAN.getValue());
        xxlJobInfo.setExecutorHandler(jobHandler);
        xxlJobInfo.setJobDesc(desc);
        xxlJobInfo.setExecutorParam(param);
        xxlJobInfo.setExecutorBlockStrategy(JobEnum.EXECUTOR_BLOCK_SERIAL_EXECUTION.getValue());
        xxlJobInfo.setExecutorFailStrategy(JobEnum.EXECUTOR_FAIL_STRATEGY_NULL.getValue());
        xxlJobInfo.setAuthor(author);
        xxlJobInfo.setBizType(businessType);
        xxlJobInfo.setBizCode(bizCode);
        this.jobClient.addJob(xxlJobInfo);
    }

    public void addJob(String execuDateCron, String desc, String param, String author, String jobHandler, int businessType, String bizCode, String appName) {
        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        xxlJobInfo.setAppName(appName);
        xxlJobInfo.setExecutorRouteStrategy(JobEnum.EXECUTOR_ROUTE_STRATEGY_FIRST.getValue());
        xxlJobInfo.setJobCron(execuDateCron);
        xxlJobInfo.setGlueType(JobEnum.GLUE_TYPE_BEAN.getValue());
        xxlJobInfo.setExecutorHandler(jobHandler);
        xxlJobInfo.setJobDesc(desc);
        xxlJobInfo.setExecutorParam(param);
        xxlJobInfo.setExecutorBlockStrategy(JobEnum.EXECUTOR_BLOCK_SERIAL_EXECUTION.getValue());
        xxlJobInfo.setExecutorFailStrategy(JobEnum.EXECUTOR_FAIL_STRATEGY_NULL.getValue());
        xxlJobInfo.setAuthor(author);
        xxlJobInfo.setBizType(businessType);
        xxlJobInfo.setBizCode(bizCode);
        this.jobClient.addJob(xxlJobInfo);
    }

    public void removeByBiz(int businessType, String bizCode) {
        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        xxlJobInfo.setBizType(businessType);
        xxlJobInfo.setBizCode(bizCode);
        this.jobClient.removeByBiz(xxlJobInfo);
    }

    public static String getCronExpression(Date date) {
        String dateFormat = "ss mm HH dd MM ? yyyy";
        return XxlJobUtil.formatDateByPattern(date, dateFormat);
    }

    public static String formatDateByPattern(Date date, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String formatTimeStr = null;
        if (date != null) {
            formatTimeStr = sdf.format(date);
        }
        return formatTimeStr;
    }
}

