/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.tokens;

import com.alibaba.fastjson.JSON;
import com.bizvane.utils.tokens.CtrlAccountPO;
import com.bizvane.utils.tokens.JWTUtil;
import com.bizvane.utils.tokens.SysAccountPO;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import io.jsonwebtoken.Claims;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtils {
    public static final Logger logger = LoggerFactory.getLogger(TokenUtils.class);
    public static final String CONTROL_TOKEN = "controlToken";
    public static final String STAGE_TOKEN = "stageToken";

    public static SysAccountPO getStageUser(HttpServletRequest request) {
        String json = "";
        try {
            json = URLDecoder.decode(request.getHeader("sysAccountPo"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        SysAccountPO sysAccountPo = (SysAccountPO)JSON.parseObject((String)json, SysAccountPO.class);
        return sysAccountPo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CtrlAccountPO getControlUser(HttpServletRequest request) {
        String token = TokenUtils.getToken(request, CONTROL_TOKEN);
        CtrlAccountPO ctrlAccountPO = null;
        try {
            System.out.println("token--------------------------" + token);
            Claims claims = JWTUtil.parseJWT(token);
            String subject = claims.getSubject();
            System.out.println("subject-----" + subject);
            Gson gson = new Gson();
            ctrlAccountPO = (CtrlAccountPO)gson.fromJson(subject, CtrlAccountPO.class);
            return ctrlAccountPO;
        }
        catch (JsonSyntaxException e) {
            logger.info("\u83b7\u53d6\u4e2d\u63a7token\u5bf9\u8c61\u5f02\u5e38!");
            e.printStackTrace();
        }
        finally {
            return ctrlAccountPO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getToken(HttpServletRequest request, String tokenName) {
        String token = "";
        try {
            token = Arrays.asList(request.getCookies()).stream().filter(obj -> tokenName.equals(obj.getName())).findFirst().get().getValue();
            logger.info(Arrays.toString(request.getCookies()));
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6Cookie\u4e2d\u7684token\u5f02\u5e38");
            e.printStackTrace();
        }
        finally {
            return token;
        }
    }

    public static Cookie getTokenCookie(HttpServletRequest request, String tokenName) {
        Cookie cookie = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(tokenName)) continue;
                return cookies[i];
            }
        }
        return cookie;
    }
}

