/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.jobutils;

import com.bizvane.utils.jobutils.MapUtil;
import com.bizvane.utils.jobutils.XxlJobInfo;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class JobClient {
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${xxl.job.admin.addresses}")
    private String[] jobAdminUrl;
    private static String add = "/jobinfo/add";
    private static String update = "/jobinfo/update";
    private static String remove = "/jobinfo/remove";
    private static String pause = "/jobinfo/pause";
    private static String resume = "/jobinfo/resume";
    private static String getJobInfoByBiz = "/jobinfo/getJobInfoByBiz";

    public ResponseEntity<String> addJob(XxlJobInfo xxlJobInfo) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap<String, String> xxlJobInfoMap = MapUtil.obj2Map(xxlJobInfo);
        HttpEntity request = new HttpEntity(xxlJobInfoMap, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.getLoadUrl(add), (Object)request, String.class, new Object[0]);
        return response;
    }

    public ResponseEntity<String> updateJob(XxlJobInfo xxlJobInfo) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap<String, String> xxlJobInfoMap = MapUtil.obj2Map(xxlJobInfo);
        HttpEntity request = new HttpEntity(xxlJobInfoMap, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.getLoadUrl(update), (Object)request, String.class, new Object[0]);
        return response;
    }

    public ResponseEntity<String> removeJob(Integer xxlJobInfoId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)xxlJobInfoId, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.getLoadUrl(remove), (Object)request, String.class, new Object[0]);
        return response;
    }

    public ResponseEntity<String> pauseJob(int xxlJobInfoId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)xxlJobInfoId, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.getLoadUrl(pause), (Object)request, String.class, new Object[0]);
        return response;
    }

    public ResponseEntity<String> resumeJob(int xxlJobInfoId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)xxlJobInfoId, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.getLoadUrl(resume), (Object)request, String.class, new Object[0]);
        return response;
    }

    public ResponseEntity<String> getJobInfoByBizJob(XxlJobInfo xxlJobInfo) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap<String, String> xxlJobInfoMap = MapUtil.obj2Map(xxlJobInfo);
        HttpEntity request = new HttpEntity(xxlJobInfoMap, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.getLoadUrl(getJobInfoByBiz), (Object)request, String.class, new Object[0]);
        return response;
    }

    public String getLoadUrl(String method) {
        int length = this.jobAdminUrl.length;
        Random random = new Random();
        int i = random.nextInt(length);
        String url = this.jobAdminUrl[i] + method;
        return url;
    }
}

