/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.mongoutils;

import com.bizvane.utils.mongoutils.MongoTemplateServiceImpl;
import com.bizvane.utils.mongoutils.TimestampConverter;
import java.util.ArrayList;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@EnableMongoRepositories(basePackages={"com.bizvane.**.mongo"}, repositoryBaseClass=MongoTemplateServiceImpl.class)
public class MongoConfig {
    @Bean
    public MappingMongoConverter mappingMongoConverter(MongoDbFactory factory, MongoMappingContext context) {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(factory);
        MappingMongoConverter mappingConverter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)context);
        mappingConverter.setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        mappingConverter.setCustomConversions(this.customConversions());
        return mappingConverter;
    }

    @Bean
    public CustomConversions customConversions() {
        ArrayList<TimestampConverter> list = new ArrayList<TimestampConverter>();
        list.add(new TimestampConverter());
        CustomConversions.StoreConversions storeConversions = CustomConversions.StoreConversions.NONE;
        return new CustomConversions(storeConversions, list);
    }
}

