/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.mongoutils;

import com.bizvane.utils.mongoutils.MongoTemplateServiceImpl;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@EnableMongoRepositories(basePackages={"com.bizvane"}, mongoTemplateRef="diseaseMongoTemplate", repositoryBaseClass=MongoTemplateServiceImpl.class)
public class MongoConfig {
    @Value(value="${spring.data.mongodb.uri}")
    private String mongoUri;
    @Value(value="${spring.data.mongodb.database}")
    private String dbName;

    @Bean(name={"diseaseMongoTemplate"})
    public MongoTemplate diseaseMongoTemplate() throws Exception {
        MappingMongoConverter converter = new MappingMongoConverter((DbRefResolver)new DefaultDbRefResolver(this.mongodbFactory()), (MappingContext)new MongoMappingContext());
        converter.setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        return new MongoTemplate(this.mongodbFactory(), (MongoConverter)converter);
    }

    @Bean
    public MongoDbFactory mongodbFactory() throws Exception {
        MongoClientURI mongoClientUri = new MongoClientURI(this.mongoUri);
        return new SimpleMongoDbFactory(new MongoClient(mongoClientUri), this.dbName);
    }
}

