/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.mongoutils;

import com.bizvane.utils.mongoutils.MongoTemplateService;
import com.bizvane.utils.responseinfo.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;
import org.springframework.stereotype.Service;

@Service
public class MongoTemplateServiceImpl<T, ID extends Serializable>
extends SimpleMongoRepository<T, ID>
implements MongoTemplateService<T, ID> {
    private static final Logger logger = LoggerFactory.getLogger(MongoTemplateServiceImpl.class);
    protected final MongoOperations mongoTemplate;
    protected final MongoEntityInformation<T, ID> entityInformation;
    private Class<T> clazz;

    public MongoTemplateServiceImpl(MongoEntityInformation<T, ID> metadata, MongoOperations mongoOperations) {
        super(metadata, mongoOperations);
        this.mongoTemplate = mongoOperations;
        this.entityInformation = metadata;
        this.clazz = this.entityInformation.getJavaType();
    }

    @Override
    public boolean batchSave(List<T> list) {
        if (CollectionUtils.isNotEmpty(list) && (list = list.stream().filter(o -> Objects.nonNull(o)).collect(Collectors.toList())).size() > 0) {
            try {
                this.saveAll(list);
                this.saveAll(list);
                boolean bl = true;
                return bl;
            }
            finally {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean batchDelete(List<ID> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").in(list));
            try {
                this.mongoTemplate.findAllAndRemove(query, this.clazz);
                boolean bl = true;
                return bl;
            }
            finally {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(ID id, Map<String, Object> updateMap) {
        if (updateMap != null || !updateMap.isEmpty()) {
            Criteria criteria = new Criteria("_id").is(id);
            Update update = new Update();
            updateMap.entrySet().forEach(entry -> update.set((String)entry.getKey(), entry.getValue()));
            try {
                this.mongoTemplate.findAndModify(new Query((CriteriaDefinition)criteria), update, this.clazz);
                boolean bl = true;
                return bl;
            }
            finally {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(Map<String, Object> queryParam, Map<String, Object> updateField) {
        if (queryParam != null || !queryParam.isEmpty()) {
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            for (Map.Entry<String, Object> entry2 : queryParam.entrySet()) {
                criteriaList.add(Criteria.where((String)entry2.getKey()).is(entry2.getValue()));
            }
            int size = criteriaList.size();
            Criteria[] criterias = new Criteria[size];
            for (int i = 0; i < size; ++i) {
                criterias[i] = (Criteria)criteriaList.get(i);
            }
            Criteria criteria = new Criteria().andOperator(criterias);
            if (updateField != null || !updateField.isEmpty()) {
                Update update = new Update();
                updateField.entrySet().forEach(entry -> update.set((String)entry.getKey(), entry.getValue()));
                try {
                    this.mongoTemplate.findAndModify(new Query((CriteriaDefinition)criteria), update, this.clazz);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public PageInfo<T> findPage(int pageIndex, int pageSize, Map<String, Integer> sort) {
        ArrayList orders = new ArrayList();
        PageRequest pageable = null;
        if (sort != null && !sort.isEmpty()) {
            sort.entrySet().forEach(entry -> orders.add(new Sort.Order((Integer)entry.getValue() == 0 ? Sort.Direction.ASC : Sort.Direction.DESC, (String)entry.getKey())));
            pageable = PageRequest.of((int)pageIndex, (int)pageSize, (Sort)new Sort(orders));
        } else {
            pageable = PageRequest.of((int)pageIndex, (int)pageSize);
        }
        Page page = this.findAll((Pageable)pageable);
        PageInfo pageInfo = new PageInfo(pageIndex, pageSize);
        pageInfo.setList(page.getContent());
        pageInfo.setTotal((int)page.getTotalElements());
        return pageInfo;
    }

    @Override
    public T findByIdAndType(ID id, Class<?> type) {
        Criteria criatira = new Criteria();
        criatira.andOperator(new Criteria[]{Criteria.where((String)"_id").is((Object)"id"), Criteria.where((String)"type").is(type)});
        Object t = this.mongoTemplate.findOne(new Query((CriteriaDefinition)criatira), this.clazz);
        return (T)t;
    }

    @Override
    public PageInfo<T> findPageWithParam(Map<String, Object> queryParam, Integer pageIndex, Integer pageSize, Map<String, Integer> sortParam) {
        if (queryParam == null || queryParam.isEmpty()) {
            return this.findPage(pageIndex, pageSize, sortParam);
        }
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        for (Map.Entry<String, Object> entry2 : queryParam.entrySet()) {
            criteriaList.add(Criteria.where((String)entry2.getKey()).is(entry2.getValue()));
        }
        Criteria[] criterias = new Criteria[criteriaList.size()];
        criterias = criteriaList.toArray(criterias);
        Criteria criteria = new Criteria().andOperator(criterias);
        Query query = new Query((CriteriaDefinition)criteria);
        if (sortParam != null && !sortParam.isEmpty()) {
            ArrayList orders = new ArrayList();
            sortParam.entrySet().forEach(entry -> orders.add(new Sort.Order((Integer)entry.getValue() == 0 ? Sort.Direction.ASC : Sort.Direction.DESC, (String)entry.getKey())));
            Sort sort = Sort.by(orders);
            query.with(sort);
        }
        long total = this.mongoTemplate.count(query, this.clazz);
        query.skip((long)(pageIndex * pageSize));
        query.limit(pageSize.intValue());
        List data = this.mongoTemplate.find(query, this.clazz);
        PageInfo pageInfo = new PageInfo(pageIndex, pageSize);
        pageInfo.setTotal((int)total);
        pageInfo.setList(data);
        return pageInfo;
    }
}

