/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.redisutils;

import com.bizvane.utils.redisutils.RedisTemplateService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="redisTemplateService")
public class RedisTemplateServiceImpl
implements RedisTemplateService {
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public void deleteFromRedis(String key) {
        this.redisTemplate.delete((Object)key);
    }

    @Override
    public Boolean hashCheckHxists(String mapName, String field) {
        return this.redisTemplate.opsForHash().hasKey((Object)mapName, (Object)field);
    }

    @Override
    public <T> T hashGet(String tableName, String hashKey) {
        return (T)this.redisTemplate.opsForHash().get((Object)tableName, (Object)hashKey);
    }

    @Override
    public <K, V> Map<K, V> hashGetAll(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    @Override
    public Long hashIncrementLongOfHashMap(String hKey, String hashKey, Long delta) {
        return this.redisTemplate.opsForHash().increment((Object)hKey, (Object)hashKey, delta.longValue());
    }

    @Override
    public Double hashIncrementDoubleOfHashMap(String hKey, String hashKey, Double delta) {
        return this.redisTemplate.opsForHash().increment((Object)hKey, (Object)hashKey, delta.doubleValue());
    }

    @Override
    public <K, V> void hashPushHashMap(String key, K hashKey, V value) {
        this.redisTemplate.opsForHash().put((Object)key, hashKey, value);
    }

    @Override
    public <T> Set<T> hashGetAllHashKey(String key) {
        return this.redisTemplate.opsForHash().keys((Object)key);
    }

    @Override
    public Long hashGetHashMapSize(String key) {
        return this.redisTemplate.opsForHash().size((Object)key);
    }

    @Override
    public <T> List<T> hashGetHashAllValues(String key) {
        return this.redisTemplate.opsForHash().values((Object)key);
    }

    @Override
    public <K> Long hashDeleteHashKey(String key, K ... hashKeys) {
        return this.redisTemplate.opsForHash().delete((Object)key, (Object[])hashKeys);
    }

    @Override
    public void listLeftPushList(String key, String value) {
        this.redisTemplate.opsForList().leftPush((Object)key, (Object)value);
    }

    @Override
    public String listLeftPopList(String key) {
        return (String)this.redisTemplate.opsForList().leftPop((Object)key);
    }

    @Override
    public Long listSize(String key) {
        return this.redisTemplate.opsForList().size((Object)key);
    }

    @Override
    public List<String> listRangeList(String key, Long start, Long end) {
        return this.redisTemplate.opsForList().range((Object)key, start.longValue(), end.longValue());
    }

    public <T> Long listRemoveFromList(String key, long i, T value) {
        return this.redisTemplate.opsForList().remove((Object)key, i, value);
    }

    @Override
    public String listIndexFromList(String key, long index) {
        return (String)this.redisTemplate.opsForList().index((Object)key, index);
    }

    @Override
    public void listSetValueToList(String key, long index, String value) {
        this.redisTemplate.opsForList().set((Object)key, index, (Object)value);
    }

    @Override
    public void listTrimByRange(String key, Long start, Long end) {
        this.redisTemplate.opsForList().trim((Object)key, start.longValue(), end.longValue());
    }

    @Override
    public void listRightPushList(String key, String value) {
        this.redisTemplate.opsForList().rightPush((Object)key, (Object)value);
    }

    @Override
    public String listRightPopList(String key) {
        return (String)this.redisTemplate.opsForList().rightPop((Object)key);
    }

    @Override
    public Long setAddSetMap(String key, String ... values) {
        return this.redisTemplate.opsForSet().add((Object)key, (Object[])values);
    }

    @Override
    public Long setGetSizeForSetMap(String key) {
        return this.redisTemplate.opsForSet().size((Object)key);
    }

    @Override
    public Set<String> setGetMemberOfSetMap(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    @Override
    public <T> Boolean setCheckIsMemberOfSet(String key, T o) {
        return this.redisTemplate.opsForSet().isMember((Object)key, o);
    }

    @Override
    public Integer stringAppendString(String key, String value) {
        return this.redisTemplate.opsForValue().append((Object)key, value);
    }

    @Override
    public String stringGetStringByKey(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public String stringGetSubStringFromString(String key, long start, long end) {
        return this.redisTemplate.opsForValue().get((Object)key, start, end);
    }

    @Override
    public Long stringIncrementLongString(String key, Long delta) {
        return this.redisTemplate.opsForValue().increment((Object)key, delta.longValue());
    }

    @Override
    public Double stringIncrementDoubleString(String key, Double delta) {
        return this.redisTemplate.opsForValue().increment((Object)key, delta.doubleValue());
    }

    @Override
    public void stringSetString(String key, String value) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    @Override
    public String stringGetAndSet(String key, String value) {
        return (String)this.redisTemplate.opsForValue().getAndSet((Object)key, (Object)value);
    }

    @Override
    public void stringSetValueAndExpireTime(String key, String value, long timeout) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value, timeout, TimeUnit.MILLISECONDS);
    }
}

