/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.utils.tokens;

import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.JWTSigner;
import com.auth0.jwt.JWTVerifier;
import com.bizvane.utils.tokens.SysAccountPO;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"jwt.signature"})
@Component
public class JWTUtil {
    @Value(value="${jwt.signature:bizvane}")
    private String signature;
    private static final String SIGN = "ZpXxYtAqic2AqXBDVNtsMy6w5GCaWdaRUahLbJDjH9b4a9q6Vcvzsd6";
    private static final String EXP = "exp";
    private static final String PAYLOAD = "payload";
    public static final String ISSUER = "https://cn.bing.com/";
    public static final String SUBJECT = "loginToken";
    public static final Integer TTLMILLIS = 18000000;

    public <T> String sign2(T object, long maxAge) {
        try {
            JWTSigner signer = new JWTSigner(this.signature);
            HashMap<String, Object> claims = new HashMap<String, Object>();
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = mapper.writeValueAsString(object);
            claims.put(PAYLOAD, jsonString);
            claims.put(EXP, System.currentTimeMillis() + maxAge);
            return signer.sign(claims);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T unsign2(String jwt, Class<T> classT) {
        JWTVerifier verifier = new JWTVerifier(this.signature);
        try {
            long currentTimeMillis;
            long exp;
            Map claims = verifier.verify(jwt);
            if (claims.containsKey(EXP) && claims.containsKey(PAYLOAD) && (exp = ((Long)claims.get(EXP)).longValue()) > (currentTimeMillis = System.currentTimeMillis())) {
                String json = (String)claims.get(PAYLOAD);
                return (T)JSONObject.parseObject((String)json, classT);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> String sign(T object, long maxAge) {
        try {
            JWTSigner signer = new JWTSigner(SIGN);
            HashMap<String, Object> claims = new HashMap<String, Object>();
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = mapper.writeValueAsString(object);
            claims.put(PAYLOAD, jsonString);
            claims.put(EXP, System.currentTimeMillis() + maxAge);
            return signer.sign(claims);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T unsign(String jwt, Class<T> classT) {
        JWTVerifier verifier = new JWTVerifier(SIGN);
        try {
            long currentTimeMillis;
            long exp;
            Map claims = verifier.verify(jwt);
            if (claims.containsKey(EXP) && claims.containsKey(PAYLOAD) && (exp = ((Long)claims.get(EXP)).longValue()) > (currentTimeMillis = System.currentTimeMillis())) {
                String json = (String)claims.get(PAYLOAD);
                return (T)JSONObject.parseObject((String)json, classT);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        String s = JWTUtil.sign(new SysAccountPO(), TTLMILLIS.intValue());
        String aString = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJleHAiOjE2MTAwMzc4ODE5MjksInBheWxvYWQiOiJ7XCJjdHJsQWNjb3VudElkXCI6NCxcImFjY291bnRDb2RlXCI6XCIxNzYyMTg4NTM3N1wiLFwiY291bnRyeUNvZGVcIjpcIis4NlwiLFwicGhvbmVOdW1iZXJcIjpcIjE3NjIxODg1Mzc3XCIsXCJwYXNzd29yZFwiOlwiNTY5MGRkZGZhMjhhZTA4NWQyMzUxOGEwMzU3MDcyODJcIixcIm5hbWVcIjpcImNoZW5cIixcInBvc2l0aW9uXCI6XCJjcm0t5byA5Y-RXCIsXCJzdGF0dXNcIjp0cnVlLFwicmVzZXRQYXNzd29yZFwiOmZhbHNlLFwibGFzdExvZ2luRGF0ZVwiOjE1NDU5MDMxOTQwMDAsXCJyZW1hcmtcIjpudWxsLFwiY3JlYXRlVXNlcklkXCI6NCxcImNyZWF0ZVVzZXJOYW1lXCI6XCJjaGVuXCIsXCJjcmVhdGVEYXRlXCI6MTYwOTE2MDk4MDAwMCxcIm1vZGlmaWVkVXNlcklkXCI6NCxcIm1vZGlmaWVkVXNlck5hbWVcIjpcImNoZW5cIixcIm1vZGlmaWVkRGF0ZVwiOjE2MDkxNjA5ODAwMDAsXCJ2YWxpZFwiOnRydWUsXCJpc0FkbWluXCI6dHJ1ZX0ifQ._TKvImJb41VX1Ad5F3jIm_Zc1lQx4WFpni52ILwdvD4";
        JWTUtil.unsign(aString, Object.class);
    }

    public static String createJWT(String playload) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary((String)SIGN);
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
        JwtBuilder builder = Jwts.builder().setPayload(playload).signWith(signatureAlgorithm, (Key)signingKey);
        return builder.compact();
    }

    public static String createJWT(String id, String issuer, String subject, long ttlMillis) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary((String)SIGN);
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
        JwtBuilder builder = Jwts.builder().setId(id).setIssuedAt(now).setSubject(subject).setIssuer(issuer).signWith(signatureAlgorithm, (Key)signingKey);
        if (ttlMillis >= 0L) {
            long expMillis = nowMillis + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public static Claims parseJWT(String jwt) {
        JwsHeader claims1 = (JwsHeader)Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)SIGN)).parseClaimsJws(jwt).getHeader();
        Claims claims = (Claims)Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)SIGN)).parseClaimsJws(jwt).getBody();
        System.out.println("ID: " + claims.getId());
        System.out.println("Subject: " + claims.getSubject());
        System.out.println("Issuer: " + claims.getIssuer());
        System.out.println("Expiration: " + claims.getExpiration());
        return claims;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JWTUtil)) {
            return false;
        }
        JWTUtil other = (JWTUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JWTUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        return result;
    }

    public String toString() {
        return "JWTUtil(signature=" + this.getSignature() + ")";
    }
}

