package com.bizvane.utils.tokens;

import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.JWTSigner;
import com.auth0.jwt.JWTVerifier;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import lombok.Data;

/**
 * @Author: lijunwei
 * @Time: 2018/7/12 8:58
 */
@ConditionalOnProperty(name = "jwt.signature")
@Component
@Data
public class JWTUtil {

    @Value("${jwt.signature:bizvane}")
    private String signature;

    private static final String SIGN ="ZpXxYtAqic2AqXBDVNtsMy6w5GCaWdaRUahLbJDjH9b4a9q6Vcvzsd6";

    private static final String EXP = "exp";

    private static final String PAYLOAD = "payload";

    public static final String ISSUER = "https://cn.bing.com/";

    public static final String SUBJECT = "loginToken";

    public static final Integer TTLMILLIS = 18000000;
    /**
     * get jwt String of object
     *
     * @param object the POJO object
     * @param maxAge the milliseconds of life time
     * @return the jwt token
     */
    public <T> String sign2(T object, long maxAge) {
        try {
            final JWTSigner signer = new JWTSigner(signature);
            final Map<String, Object> claims = new HashMap<String, Object>();
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = mapper.writeValueAsString(object);
            claims.put(PAYLOAD, jsonString);
            claims.put(EXP, System.currentTimeMillis() + maxAge);
            return signer.sign(claims);
        } catch (Exception e) {
            return null;
        }
    }

    public <T> T unsign2(String jwt, Class<T> classT) {
        final JWTVerifier verifier = new JWTVerifier(signature);
        try {
            final Map<String, Object> claims = verifier.verify(jwt);
            if (claims.containsKey(EXP) && claims.containsKey(PAYLOAD)) {
                long exp = (Long) claims.get(EXP);
                long currentTimeMillis = System.currentTimeMillis();
                if (exp > currentTimeMillis) {
                    String json = (String) claims.get(PAYLOAD);
                    return JSONObject.parseObject(json, classT);
                }
            }
            return null;
        } catch (Exception e) {
            return null;
        }
    }

    public static <T> String sign(T object, long maxAge) {
        try {
            final JWTSigner signer = new JWTSigner(SIGN);
            final Map<String, Object> claims = new HashMap<String, Object>();
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = mapper.writeValueAsString(object);
            claims.put(PAYLOAD, jsonString);
            claims.put(EXP, System.currentTimeMillis() + maxAge);
            return signer.sign(claims);
        } catch (Exception e) {
            return null;
        }
    }


    /**
     * get the object of jwt if not expired
     *
     * @param jwt
     * @return POJO object
     */
    public static <T> T unsign(String jwt, Class<T> classT) {
        final JWTVerifier verifier = new JWTVerifier(SIGN);
        try {
            final Map<String, Object> claims = verifier.verify(jwt);
            if (claims.containsKey(EXP) && claims.containsKey(PAYLOAD)) {
                long exp = (Long) claims.get(EXP);
                long currentTimeMillis = System.currentTimeMillis();
                if (exp > currentTimeMillis) {
                    String json = (String) claims.get(PAYLOAD);
                    return JSONObject.parseObject(json, classT);
                }
            }
            return null;
        } catch (Exception e) {
            return null;
        }
    }
    
    public static void main(String[] args) {
      String s = JWTUtil.sign(new SysAccountPO(), JWTUtil.TTLMILLIS);
      String aString = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJleHAiOjE2MTAwMzc4ODE5MjksInBheWxvYWQiOiJ7XCJjdHJsQWNjb3VudElkXCI6NCxcImFjY291bnRDb2RlXCI6XCIxNzYyMTg4NTM3N1wiLFwiY291bnRyeUNvZGVcIjpcIis4NlwiLFwicGhvbmVOdW1iZXJcIjpcIjE3NjIxODg1Mzc3XCIsXCJwYXNzd29yZFwiOlwiNTY5MGRkZGZhMjhhZTA4NWQyMzUxOGEwMzU3MDcyODJcIixcIm5hbWVcIjpcImNoZW5cIixcInBvc2l0aW9uXCI6XCJjcm0t5byA5Y-RXCIsXCJzdGF0dXNcIjp0cnVlLFwicmVzZXRQYXNzd29yZFwiOmZhbHNlLFwibGFzdExvZ2luRGF0ZVwiOjE1NDU5MDMxOTQwMDAsXCJyZW1hcmtcIjpudWxsLFwiY3JlYXRlVXNlcklkXCI6NCxcImNyZWF0ZVVzZXJOYW1lXCI6XCJjaGVuXCIsXCJjcmVhdGVEYXRlXCI6MTYwOTE2MDk4MDAwMCxcIm1vZGlmaWVkVXNlcklkXCI6NCxcIm1vZGlmaWVkVXNlck5hbWVcIjpcImNoZW5cIixcIm1vZGlmaWVkRGF0ZVwiOjE2MDkxNjA5ODAwMDAsXCJ2YWxpZFwiOnRydWUsXCJpc0FkbWluXCI6dHJ1ZX0ifQ._TKvImJb41VX1Ad5F3jIm_Zc1lQx4WFpni52ILwdvD4";
      unsign(aString, Object.class);
    }

    //Sample method to construct a JWT
    public static String createJWT(String playload) {

        //The JWT signature algorithm we will be using to sign the token
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;

        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);

        //We will sign our JWT with our ApiKey secret
        byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary(SIGN);
        Key signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());

        //Let's set the JWT Claims
        JwtBuilder builder = Jwts.builder()
                .setPayload(playload)
                .signWith(signatureAlgorithm, signingKey);

        //Builds the JWT and serializes it to a compact, URL-safe string
        return builder.compact();
    }

    //Sample method to construct a JWT
    public static String createJWT(String id, String issuer, String subject, long ttlMillis) {

        //The JWT signature algorithm we will be using to sign the token
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;

        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);

        //We will sign our JWT with our ApiKey secret
        byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary(SIGN);
        Key signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());

        //Let's set the JWT Claims
        JwtBuilder builder = Jwts.builder().setId(id)
                .setIssuedAt(now)
                .setSubject(subject)
                .setIssuer(issuer)
                .signWith(signatureAlgorithm, signingKey);

        //if it has been specified, let's add the expiration
       if (ttlMillis >= 0) {
            long expMillis = nowMillis + ttlMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }

        //Builds the JWT and serializes it to a compact, URL-safe string
        return builder.compact();
    }

    public static Claims parseJWT(String jwt) {

        //This line will throw an exception if it is not a signed JWS (as expected)

        JwsHeader claims1 = Jwts.parser()
                .setSigningKey(DatatypeConverter.parseBase64Binary(SIGN))
                .parseClaimsJws(jwt).getHeader();

        Claims claims = Jwts.parser()
                .setSigningKey(DatatypeConverter.parseBase64Binary(SIGN))
                .parseClaimsJws(jwt).getBody();

//        createJWT()
        System.out.println("ID: " + claims.getId());
        System.out.println("Subject: " + claims.getSubject());
        System.out.println("Issuer: " + claims.getIssuer());
        System.out.println("Expiration: " + claims.getExpiration());
        return claims;
    }
}