package com.bizvane.centercontrolservice.rpc;

import com.bizvane.centercontrolservice.models.vo.SysCompanyProductResultVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "${feign.client.centercontrol.name}", path = "${feign.client.centercontrol.path}/sysCompanyProduct")
public interface SysCompanyProductServiceRpc {

    /**
     * 查询配置了具体产品的企业列表
     */
    @GetMapping(value = "/listSysCompanyProduct")
    ResponseData<List<SysCompanyProductResultVO>> listSysCompanyProduct(
            @RequestParam(value = "sysCompanyIdList", required = false) List<Long> sysCompanyIdList,
            @RequestParam(value = "productCodeList", required = true) List<String> productCodeList);


}
