package com.bizvane.centercontrolservice.rpc;

import com.bizvane.centercontrolservice.models.po.DefMenuPo;
import com.bizvane.centercontrolservice.models.po.DefRolePo;
import com.bizvane.centercontrolservice.models.vo.DefRoleVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author yunjie.tian
 * @date on 2018/7/2 10:28
 * @description
 * @Copyright (c) 2018 上海商帆信息科技有限公司-版权所有
 */
@FeignClient(value = "${feign.client.centercontrol.name}",path = "${feign.client.centercontrol.path}/defMenuRpc")
public interface DefMenuServiceRpc {


    /**
     * 根据id查询账号菜单集合
     * @param menuIdList
     * {@link com.bizvane.centercontrolservice.rpc.DefMenuServiceRpc#getDefMenuByMenuIdList}
     * @return
     */
    @Deprecated()
    @RequestMapping("/getDefMenuByIdList")
    List<DefMenuPo> getDefMenuByIdList(@RequestParam("menuIdList") List<Long> menuIdList);

    /**
     * 根据id查询账号菜单集合 改为post请求方式
     * @param menuIdList
     * @return
     */
    @RequestMapping(value = "/getDefMenuByMenuIdList",method = RequestMethod.POST)
    List<DefMenuPo> getDefMenuByMenuIdList(@RequestBody List<Long> menuIdList);

    /**
     * 根据产品id查询账号菜单id集合
     * @param productIdList
     * @return
     */
    @RequestMapping("/getProductIdDefMenuIdList")
    List<Long> getProductIdDefMenuIdList(@RequestParam("productIdList") List<Long> productIdList);
    /**
     * 根据id查询账号菜单集合 改为post请求方式
     * @param productIdList
     * @return
     */
    @RequestMapping(value = "/getDefMenuIdByProductIdList",method = RequestMethod.POST)
    List<Long> getDefMenuIdByProductIdList(@RequestBody List<Long> productIdList);

    /**
     * 查询所有的上级菜单id
     *
     * @return
     * */
    @RequestMapping("/getPreMenuIdList")
    List<Long> getPreMenuIdList(@RequestParam(value = "applicationType", required = false) Integer applicationType);

    /**
     * 根据菜单id查询url
     *
     * */
    @RequestMapping("/getMenuUrl")
    ResponseData<String> getMenuUrl(@RequestParam("defMenuId") Long defMenuId);

    /**
     * 根据角色模板id查询角色菜单
     * @param defRoleId
     * @return
     *
     * */
    @RequestMapping("/getDefRoleMenuIdList")
    List<Long> getDefRoleMenuIdList(@RequestParam("defRoleId") Long defRoleId);
}
