package com.bizvane.centercontrolservice.rpc;

import com.bizvane.centercontrolservice.models.po.DefMenuBtnRelPo;
import com.bizvane.centercontrolservice.models.vo.DefBtnVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "${feign.client.centercontrol.name}",path = "${feign.client.centercontrol.path}/defMenuBtnRelRpc")
public interface DefMenuBtnRelServiceRpc {
    /**
     * 根据角色菜单id集合查询菜单信息集合
     *
     * */
    @RequestMapping("/getRoleDefBtnList")
    List<DefBtnVo> getRoleDefBtnList(@RequestParam("roleMenuIdList") List<Long> roleMenuIdList);

    /**
     * 查询所有的菜单按钮权限集合
     *
     * */
    @RequestMapping("/getDefRoleBtnList")
    List<DefMenuBtnRelPo> getDefRoleBtnList();

    /**
     * 查询所有的菜单按钮权限集合
     *
     * */
    @RequestMapping("/getIdDefRoleBtnList")
    List<DefMenuBtnRelPo> getIdDefRoleBtnList(@RequestParam("startId") String startId, @RequestParam("endId") String endId);
}
