package com.bizvane.centercontrolservice.models.enums;

public enum FusionPayChannelEnum {

    MERCHANTS("merchants","普通商户"),
    PROVIDERS("providers","服务商"),
    UNIONPAY("unionpay","银联支付")
    ;

    private String code;

    private String msg;

    FusionPayChannelEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public static String getCode(String code) {
        for (FusionPayChannelEnum value : FusionPayChannelEnum.values()) {
            if (value.code.equals(code)) {
                return value.getCode();
            }
        }
        return null;
    }
}
