package com.bizvane.centercontrolservice.interfaces;


import com.bizvane.centercontrolservice.models.po.SysCompanyFusionPayConfigPo;
import com.bizvane.centercontrolservice.models.vo.CompanyFusionPayConfigModifyVo;
import com.bizvane.centercontrolservice.models.vo.SysCompanyFusionPayConfigVo;
import com.bizvane.utils.tokens.CtrlAccountPO;

import java.util.List;

public interface SysCompanyFusionPayConfigService {

    /**
     * 初始化企业支付配置
     * 1.默认将【微信支付-普通商户】及【支付宝-服务商】支付通道【启用】，平台费率默认【0.6】，返佣费率默认【0】；
     */
    void initDataByCompanyId(Long sysCompanyId, CtrlAccountPO ctrlAccountPo);

    /**
     * 查询企业支付配置
     */
    List<SysCompanyFusionPayConfigVo> getCompanyFusionPayConfigByCompanyId(Long sysCompanyId,Integer status);

    /**
     * 更新企业支付配置
     * 1.已启用的通道选择了停用，平台费率、返佣费率保留不允许删除；
     */
    Integer modifyCompanyFusionPayConfig(CompanyFusionPayConfigModifyVo companyFusionPayConfigModifyVo, CtrlAccountPO ctrlAccountPo);

    /**
     * 获取某个企业支付配置
     */
    SysCompanyFusionPayConfigPo findPayConfigById(Integer companyFusionPayConfigId);
}
