package com.bizvane.centercontrolservice.rpc;

import com.bizvane.centercontrolservice.models.vo.DefRoleVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * Created by Gavin on 2018/6/29.
 */
@FeignClient(value = "${feign.client.centercontrol.name}",path = "${feign.client.centercontrol.path}/defRoleRpc")
public interface DefRoleServiceRPC {
    /**
     * 中台调用中控
     * 得到角色模板列表
     *
     * @return
     */
    @RequestMapping("/getDefRoleList")
    List<DefRoleVo> getDefRoleList();

    /**
     * 根据模板角色id查询角色模板详情
     *
     * */
    @RequestMapping("/getByIdDefRole")
    DefRoleVo getByIdDefRole(@RequestParam("defRoleId") Long defRoleId);
}

