package com.bizvane.centercontrolservice.interfaces;

import com.bizvane.centercontrolservice.models.po.VirtualCardPo;
import com.bizvane.centercontrolservice.models.rpc.VirtualCardExcel;
import com.bizvane.centercontrolservice.models.rpc.VirtualCardPriceExcel;
import com.bizvane.centercontrolservice.models.vo.VirtualCardVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.List;

/**
 * @author xugy
 * @date on 2021-02-08
 * @description 虚拟卡券商品
 * @Copyright (c) 2021 上海商帆信息科技有限公司-版权所有
 */

public interface VirtualCardService {

    /**
     * 获取虚拟卡券商品列表
     *
     * @param vo
     * @return
     */
    ResponseData<PageInfo<VirtualCardPo>> getVirtualCardList(VirtualCardVo vo);

    /**
     * 导出虚拟卡券商品列表
     * @param vo
     * @return
     */
    List<VirtualCardExcel> exportExcelVirtualCard(VirtualCardVo vo);

    /**
     * 导出配置价格
     * @param vo
     * @return
     */
    List<VirtualCardPriceExcel> exportExcelVirtualCardPrice(VirtualCardVo vo);
    /**
     * 新增虚拟卡券商品
     *
     * @param po
     * @return
     */
    ResponseData<Long> addVirtualCard(VirtualCardPo po);

    /**
     * 更新虚拟卡券商品
     *
     * @param po
     * @return
     */
    ResponseData<Long> updateVirtualCard(VirtualCardPo po);

    /**
     * 更新虚拟卡券状态
     * @param po
     * @return
     */
    ResponseData<Long> updateVirtualCardStatus(VirtualCardPo po);

    /**
     * 更新虚拟卡券图片
     * @param po
     * @return
     */
    ResponseData<Long> updateVirtualCardImg(VirtualCardPo po);

    /**
     * 同步虚拟卡券商品
     * @param po
     * @return
     */
    ResponseData<Long> syncVirtualCard(List<VirtualCardPo> po);

    /**
     * 配置卡券价格
     * @param list
     * @return
     */
    ResponseData<Long> updateVirtualCardPrice(List<VirtualCardPo> list);
}
