package com.bizvane.centercontrolservice.models.enums;

import org.springframework.util.StringUtils;

public enum FusionPayTypeChannelRelEnum {

    WXPAY_MERCHANTS("wxpay","merchants","WEIXIN_TYPE","微信商户"),
    WXPAY_UNIONPAY("wxpay","unionpay","UNION_TYPE","微信银联"),
    ALIPAY_MERCHANTS("alipay","merchants","ALI_TYPE","支付宝商户"),
    ALIPAY_PROVIDERS("alipay","providers","ALI_ISV_TYPE","支付宝服务商"),
    ALIPAY_SQB("alipay","shouqianba","ALI_SQA_TYPE","收钱吧支付宝")
    ;

    private String payTypeCode;

    private String payChannelCode;

    private String platformPayTypeCode;

    private String msg;

    FusionPayTypeChannelRelEnum(String payTypeCode, String payChannelCode, String platformPayTypeCode, String msg) {
        this.payTypeCode = payTypeCode;
        this.payChannelCode = payChannelCode;
        this.platformPayTypeCode = platformPayTypeCode;
        this.msg = msg;
    }

    public static FusionPayTypeChannelRelEnum getInstance(String typeCode, String channelCode) {
        if(StringUtils.isEmpty(typeCode) || StringUtils.isEmpty(channelCode)){
            return null;
        }
        for (FusionPayTypeChannelRelEnum value : FusionPayTypeChannelRelEnum.values()) {
            if(value.getPayTypeCode().equalsIgnoreCase(typeCode)
                    && value.getPayChannelCode().equalsIgnoreCase(channelCode)){
                return value;
            }
        }
        return null;
    }

    public String getPayTypeCode() {
        return payTypeCode;
    }

    public String getPayChannelCode() {
        return payChannelCode;
    }

    public String getMsg() {
        return msg;
    }

    public String getPlatformPayTypeCode() {
        return platformPayTypeCode;
    }
}
