package com.bizvane.centercontrolservice.interfaces;

import com.bizvane.centercontrolservice.models.po.SysCompanyFusionPayRecordPo;
import com.bizvane.centercontrolservice.models.po.SysFusionPayBusinessPlatformHistoryPo;
import com.bizvane.centercontrolservice.models.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.CtrlAccountPO;
import com.github.pagehelper.PageInfo;

public interface SysCompanyFusionPayRecordService {

    /**
     * 获取所有聚合支付记录
     */
    PageInfo<SysCompanyFusionPayRecordVo> getFusionPayRecordByCtrlAccount(SysCompanyFusionPayRecordSearchVo sysCompanyFusionPayRecordSearchVo, CtrlAccountPO ctrlAccountPO);

    /**
     * 获取企业下所有聚合支付记录
     */
    PageInfo<SysCompanyFusionPayRecordVo> getFusionPayRecordByCompanyId(SysCompanyFusionPayRecordSearchVo sysCompanyFusionPayRecordSearchVo);


    /**
     * 审核支付宝服务商-初审
     */
    ResponseData firstAuditFusionPayRecordAlipayProviders(AlipayProvidersBizvaneAuditVo alipayProvidersAuditVo, CtrlAccountPO ctrlAccountPO);

    /**
     * 审核支付宝服务商-复审
     */
    ResponseData secondAuditFusionPayRecordAlipayProviders(AlipayProvidersPlatformAuditVo alipayProvidersPlatformAuditVo, CtrlAccountPO ctrlAccountPO);

    /**
     * 更新聚合支付记录-备注名
     */
    ResponseData modifyFusionPayRecordRemarkName(SysCompanyFusionPayRecordPo sysCompanyFusionPayRecordPo);

    /**
     * 新增支付宝商户
     */
    ResponseData addAlipayMerchant(FusionPayAlipayMerchantVo fusionPayAlipayMerchantVo);

    /**
     * 更新支付宝商户
     */
    ResponseData modifyAlipayMerchant(FusionPayAlipayMerchantVo fusionPayAlipayMerchantVo);

    /**
     * 新增支付宝服务商
     */
    ResponseData addAlipayProviders(FusionPayAlipayProvidersVo fusionPayAlipayProvidersVo);

    /**
     * 更新支付宝服务商
     */
    ResponseData modifyAlipayProviders(FusionPayAlipayProvidersVo fusionPayAlipayProvidersVo);

    /**
     * 新增支付宝收钱吧
     */
    ResponseData addAlipayShouqianba(FusionPayAlipayShouqianbaVO fusionPayAlipayShouqianbaVO);

    /**
     * 更新支付宝收钱吧
     */
    ResponseData modifyAlipayShouqianba(FusionPayAlipayShouqianbaVO fusionPayAlipayShouqianbaVO);

    /**
     * 新增微信商户
     */
    ResponseData addWxPayMerchant(FusionPayWxPayMerchantVo fusionPayWxPayMerchantVo);

    /**
     * 修改微信商户
     */
    ResponseData modifyWxPayMerchant(FusionPayWxPayMerchantVo fusionPayWxPayMerchantVo);


    /**
     * 新增微信银联
     */
    ResponseData addWxPayUnion(FusionPayWxPayUnionVo fusionPayWxPayUnionVo);

    /**
     * 修改微信银联w
     */
    ResponseData modifyWxPayUnion(FusionPayWxPayUnionVo fusionPayWxPayUnionVo);

    /**
     * 查询聚合支付信息
     */
    ResponseData<FusionPayRecordWrapperVo> getFusionPayInfoByRecordId(FusionPayRecordRequestWrapperVo fusionPayRecordRequestWrapperVo);

    /**
     * 查询聚合支付信息
     */
    ResponseData<FusionPayRecordWrapperVo> getFusionPayInfoByHistoryId(Integer fusionPayBusinessPlatformHistoryId);

    /**
     * 支付宝服务商授权回调成功更新数据
     */
    Integer modifyAlipayProvidersAppIdByPid(String pid,String appId,Integer companyFusionPayRecordId);

    /**
     * 查询支付网关配置
     */
    SysFusionPayBusinessPlatformHistoryPo getFusionPayHistoryByMerchantIdAndPayType(String bizvaneMerchantId, String payType);

    /**
     * 通过bizMid+brandId+businessCode查询企业聚合支付
     * @param bizvaneMerchantId
     * @param sysBrandId
     * @param businessChannelCode
     * @return
     */
    SysCompanyFusionPayRecordPo getFusionPayRecordPoByParams(String bizvaneMerchantId,Long sysBrandId,String businessChannelCode);
}
