package com.bizvane.centercontrolservice.feign;

import com.bizvane.centercontrolservice.models.enums.AccountEnum;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 *
 * @author ljc
 * @date 2020/03/24
 */
@FeignClient(value = "${feign.client.centercontrol.name}",path = "${feign.client.centercontrol.path}/ctrlAccountRpcFeign")
public interface CtrlAccountServiceRpcFeign {

    /**
     * 根据当前账号判断是否为中控账号(码商调用)
     *
     * @return
     */
    @ResponseBody
    @RequestMapping("/isCtrlAccount")
    AccountEnum isCtrlAccount(@RequestParam(value = "accountCode", required = false) String accountCode, @RequestParam(value = "pwd",required = false) String pwd);
}
