package com.bizvane.centercontrolservice.interfaces;

import com.bizvane.centercontrolservice.models.po.SysSmsConfigPo;
import com.bizvane.centercontrolservice.models.vo.SmsConfigVo;
import com.bizvane.centercontrolservice.models.vo.SysSmsConfigVo;
import com.bizvane.centercontrolservice.utils.PageFormUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * @author liufq
 */
public interface SysSmsConfigService {

    /**
     * 分页查询企业通道配置信息
     *
     * @param pageFormUtil
     * @param vo
     * @return
     */
    ResponseData<PageInfo<SysSmsConfigVo>> getSysSmsConfigList(SysSmsConfigVo vo, PageFormUtil pageFormUtil);

    /**
     * 根据id查询企业短信通道详情
     *
     * @param sysBrandId
     * @return
     */
    ResponseData<List<SysSmsConfigVo>> selectSmsConfigById(Long sysBrandId);

    /**
     * 更新短信通道配置
     *
     * @param po
     * @return
     */
    ResponseData<Integer> updateSysSmsConfig(SysSmsConfigPo po);

    /**
     * 新增短信通道配置
     *
     * @param po
     * @return
     */
    ResponseData<Long> addSysSmsConfig(SysSmsConfigPo po);

    /**
     * 根据企业id查询短信通道名列表
     *
     * @param sysCompanyId
     * @return
     */
    ResponseData<List<SysSmsConfigPo>> getSmsNameList(Long sysCompanyId);

    /**
     * 中控平台查询短信平台通道
     */
    SysSmsConfigPo  getCenterControlChannel();

    /**
     * 其他模块查询短信通道的接口
     * @param vo
     * @return
     */
    public SysSmsConfigPo getCenterControlChannel(SmsConfigVo vo);

    /**
     * 根据品牌id查询短信通道信息
     *
     * @param sysBrandId
     * @return
     * */
    List<SysSmsConfigPo> getByBrandIdSmsConfigList(Long sysBrandId);
}
