package com.bizvane.centercontrolservice.rpc;

import com.bizvane.centercontrolservice.models.vo.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

@FeignClient(value = "${feign.client.centercontrol.name}", path = "${feign.client.centercontrol.path}/brandBusinessFusionPayRpc")
public interface BrandBusinessFusionPayRpcService {

    @GetMapping("getBrandBusinessFusionPayByBrandId")
    ResponseData<List<BrandBusinessFusionPayMethodVo>> getBrandBusinessFusionPayByBrandId(@RequestParam(value = "sysBrandId") Long sysBrandId, @RequestParam(value = "businessChannelCode") String businessChannelCode);


    /**
     * 使用saveBusinessFusionPay()方法
     * @param brandBusinessFusionPayMethodSaveVo
     * @return
     */
    @Deprecated
    @PostMapping("saveBrandBusinessFusionPay")
    ResponseData saveBrandBusinessFusionPay(@Valid @RequestBody BrandBusinessFusionPayMethodSaveVo brandBusinessFusionPayMethodSaveVo);

    /**
     * 保存业务支付配置
     */
    @PostMapping("saveBusinessFusionPay")
    public ResponseData<String> saveBusinessFusionPay(@RequestBody BrandBusinessFusionPayCurrentVo brandBusinessFusionPayCurrentVo);

    /**
     * 修改业务支付配置
     */
    @PostMapping("updateBusinessFusionPay")
    public ResponseData<String> updateBusinessFusionPay(@RequestBody BrandBusinessFusionPayCurrentVo brandBusinessFusionPayCurrentVo);

    /**
     * 分页查询支付配置
     */
    @PostMapping("pageBrandBusinessFusionPayVo")
    public ResponseData<PageInfo<BrandBusinessFusionPayVo>> pageBrandBusinessFusionPayVo(@RequestBody BrandBusinessFusionPayRequestVo brandBusinessFusionPayRequestVo);

    /**
     * 查询支付配置详情
     */
    @PostMapping("getBrandBusinessFusionPayVoByVo")
    public ResponseData<BrandBusinessFusionPayVo> getBrandBusinessFusionPayVoByVo(@RequestBody BrandBusinessFusionPayRequestVo brandBusinessFusionPayRequestVo);

    /**
     * 逻辑删除业务支付配置
     */
    @PostMapping("deleteBusinessFusionPay")
    public ResponseData<String> deleteBusinessFusionPay(@RequestBody BrandBusinessFusionPayCurrentVo brandBusinessFusionPayCurrentVo);
}
