package com.bizvane.centercontrolservice.rpc;

import com.bizvane.centercontrolservice.models.bo.AppletFunctionBO;
import com.bizvane.centercontrolservice.models.po.AppletFunctionPO;
import com.bizvane.centercontrolservice.models.po.AppletRoutePO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * Created by Geng on 2018/9/8.
 */


@FeignClient(value = "${feign.client.centercontrol.name}",path = "${feign.client.centercontrol.path}/appletRouteRpc")
public interface AppletRouteServiceRpc {

    @RequestMapping("/getAllAppletRoute")
    ResponseData<List<AppletRoutePO>> getAllAppletRoute();

    @RequestMapping("/getAllAppletFunction")
    ResponseData<List<AppletFunctionPO>> getAllAppletFunction(@RequestParam("brandId") Long brandId);

    @RequestMapping("/getAllAppletFunctionByUrl")
    ResponseData<AppletFunctionBO> getAllAppletFunctionByUrl(@RequestParam("url")String url);


}
