package com.bizvane.centercontrolservice.rpc;

import com.bizvane.centercontrolservice.models.po.SysCompanyFusionPayRecordPo;
import com.bizvane.centercontrolservice.models.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "${feign.client.centercontrol.name}",path = "${feign.client.centercontrol.path}/sysCompanyFusionPayRecordRpc")
public interface SysCompanyFusionPayRecordServiceRpc {

    /**
     * 中台-支付管理 列表查询
     */
    @PostMapping("getFusionPayRecordBCompanyId")
    ResponseData<PageInfo<SysCompanyFusionPayRecordVo>> getFusionPayRecordBCompanyId(@RequestBody SysCompanyFusionPayRecordSearchVo sysCompanyFusionPayRecordSearchVo);

        /**
         * 中台-支付管理 修改备注名
         */
    @PostMapping("modifyFusionPayRecordRemarkName")
    ResponseData modifyFusionPayRecordRemarkName(@RequestBody SysCompanyFusionPayRecordPo sysCompanyFusionPayRecordPo);


    /**
     * 中台-支付管理 新增支付宝服务商
     */
    @PostMapping("addAlipayProviders")
    ResponseData addAlipayProviders(@RequestBody FusionPayAlipayProvidersVo fusionPayAlipayProvidersVo);

    /**
     * 中台-支付管理 审核失败-修改支付宝服务商资料
     */
    @PostMapping("modifyAlipayProviders")
    ResponseData modifyAlipayProviders(@RequestBody FusionPayAlipayProvidersVo fusionPayAlipayProvidersVo);

    /**
     * 中台-支付管理 新增支付宝商户
     */
    @PostMapping("addAlipayMerchant")
    ResponseData addAlipayMerchant(@RequestBody FusionPayAlipayMerchantVo fusionPayAlipayMerchantVo);


    /**
     * 中台-支付管理 审核成功-修改支付宝商户资料
     */
    @PostMapping("modifyAlipayMerchant")
    ResponseData modifyAlipayMerchant(@RequestBody FusionPayAlipayMerchantVo fusionPayAlipayMerchantVo);


    /**
     * 中台-支付管理 新增微信商户
     */
    @PostMapping("addWxPayMerchant")
    ResponseData addWxPayMerchant(@RequestBody FusionPayWxPayMerchantVo fusionPayWxPayMerchantVo);

    /**
     * 中台-支付管理 审核成功-修改微信商户
     */
    @PostMapping("modifyWxPayMerchant")
    ResponseData modifyWxPayMerchant(@RequestBody FusionPayWxPayMerchantVo fusionPayWxPayMerchantVo);

    /**
     * 中台-支付管理 新增微信银联
     */
    @PostMapping("addWxPayUnion")
    ResponseData addWxPayUnion(@RequestBody FusionPayWxPayUnionVo fusionPayWxPayUnionVo) ;

    /**
     * 中台-支付管理 审核成功-修改微信银联
     */
    @PostMapping("modifyWxPayUnion")
    ResponseData modifyWxPayUnion(@RequestBody FusionPayWxPayUnionVo fusionPayWxPayUnionVo) ;

    /**
     * 通过id查询渠道信息
     */
    @GetMapping("getFusionPayInfoByRecordId")
    ResponseData<FusionPayRecordWrapperVo> getFusionPayInfoByRecordId(FusionPayRecordRequestWrapperVo fusionPayRecordRequestWrapperVo);

}
