package com.bizvane.centercontrolservice.interfaces;

import com.bizvane.centercontrolservice.models.po.DefProductPo;
import com.bizvane.centercontrolservice.models.vo.ProductVo;
import com.bizvane.centercontrolservice.utils.PageFormUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

/**
 * @author chen.li
 * @date on 2018/6/26 9:40
 * @description 产品功能
 * @Copyright (c) 2018 上海商帆信息科技有限公司-版权所有
 */

public interface ProductService {

    /**
     * 获取系统产品列表
     *
     * @param vo
     * @param pageFormUtil
     * @return
     */
    ResponseData<PageInfo<DefProductPo>> getProductList(ProductVo vo, PageFormUtil pageFormUtil);

    /**
     * 新增系统产品
     *
     * @param po
     * @return
     */
    ResponseData<Long> addProduct(DefProductPo po);

    /**
     * 更新系统产品
     *
     * @param po
     * @return
     */
    ResponseData<Long> updateProduct(DefProductPo po);
}
