package com.bizvane.centercontrolservice.rpc;

import com.bizvane.centercontrolservice.models.po.DefCompanyWxRelPo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * Created by yunjie.tian on 2018/12/11.
 */
@FeignClient(value = "${feign.client.centercontrol.name}", path = "${feign.client.centercontrol.path}/companyWx")
public interface CompanyWxServiceRpc {

    /**
     * 根据企业id查询企业微信id
     *
     * @return
     */
    @RequestMapping(value = "/getCompanyWx", method = RequestMethod.POST)
    public ResponseData<DefCompanyWxRelPo> getCompanyWx(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("sysBrandId") Long sysBrandId);


    /**
     * 根据企业微信id查询企业id
     *
     * @return
     */
    @RequestMapping(value = "/getCompanyWxByWxid", method = RequestMethod.POST)
    public ResponseData<DefCompanyWxRelPo> getCompanyWxByWxid(@RequestParam("wxId") String wxId);


}
