package com.bizvane.centercontrolservice.rpc;

import com.bizvane.centercontrolservice.models.po.CtrlAccountPo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 *
 * @author liufq
 * @date 2018/7/7
 */
@FeignClient(value = "${feign.client.centercontrol.name}",path = "${feign.client.centercontrol.path}/ctrlAccountRpc")
public interface CtrlAccountServiceRpc {
    /**
     * 得到登陆账号下的企业id列表(中台调用)
     *
     * @param ctrlAccountId
     * @return
     * */
    @ResponseBody
    @RequestMapping("/getCompanyIdList")
    List<Long> getCompanyIdList(@RequestParam("ctrlAccountId") Long ctrlAccountId);

    /**
     * 得到当前登陆账号信息(中台调用)
     *
     * @return
     */
    @ResponseBody
    @RequestMapping("/getCtrlAccount")
    ResponseData<CtrlAccountPo> getCtrlAccount(@RequestParam(value = "ctrlAccountId",required = false) Long ctrlAccountId);



}
