package com.bizvane.centercontrolservice.interfaces;

import com.bizvane.centercontrolservice.models.po.SysLabelLimitPo;
import com.bizvane.centercontrolservice.models.vo.SysLabelLimitVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;

/**
 * Created by xz on 2019/10/29.
 */
public interface SysMemberLabelLimitService {


    /**
     * 获取所有当前账号权限下的全部企业全部品牌的标签限制记录
     * @param sysLabelLimitVo
     * @return
     */
    ResponseData<PageInfo<SysLabelLimitPo>> getLabelLimitByCompanyId(SysLabelLimitVo sysLabelLimitVo);

    /**
     *
     * @param sysCompanyId
     * @param brandId
     * @param labelCount
     * @return
     */
    ResponseData<Integer> updateLabelLimitByCompanyAndBrand(Long sysCompanyId,Long brandId,Integer labelCount);

    /**
     * 添加一条标签limit的记录
     * @param sysLabelLimitPo
     * @return
     */
    ResponseData<Integer> addLabelLimit(SysLabelLimitPo sysLabelLimitPo);

    /**
     * 添加会员标签的时候获得该企业下面的品牌的label的数量限制,
     * @param sysLabelLimitPo
     * @return
     */
    ResponseData<Integer> getLabelLimitCount(SysLabelLimitPo sysLabelLimitPo);
}
