package com.bizvane.centercontrolservice.rpc;

import com.bizvane.centercontrolservice.models.po.SysSmsConfigPo;
import com.bizvane.centercontrolservice.models.vo.SmsConfigVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * Created by liufq on 2018/6/28.
 */
@FeignClient(value = "${feign.client.centercontrol.name}",path = "${feign.client.centercontrol.path}/smsConfigRpc")
public interface SysSmsConfigServiceRpc {
    /**
     * 根据品牌id查询短信通道信息
     *
     * @param sysBrandId
     * @return
     * */
    @ResponseBody
    @PostMapping(value = "/getByBrandIdSmsConfigList")
    List<SysSmsConfigPo> getByBrandIdSmsConfigList(@RequestParam ("sysBrandId") Long sysBrandId);

    /**
     * 根据企业id，品牌id，通道类型，通道类型，通道渠道，是否作为企业级短信通道，是否为国际短信通道  查询短信通道信息
     *
     * @param sysSmsConfigPo
     * @return
     * */
    @ResponseBody
    @RequestMapping("/getSmsConfigByCondition")
    SysSmsConfigPo getSmsConfigByCondition(@RequestBody SysSmsConfigPo sysSmsConfigPo);

    @ResponseBody
    @RequestMapping("/getCenterControlChannel")
    SysSmsConfigPo getCenterControlChannel(@RequestBody SmsConfigVo vo);
}
