package com.bizvane.centercontrolservice.interfaces;


import com.bizvane.centercontrolservice.models.po.CheckErrMsgPo;
import com.bizvane.centercontrolservice.models.po.SysConfigCheckPo;
import com.bizvane.utils.responseinfo.ResponseData;

import java.util.Map;

import com.bizvane.centercontrolservice.models.po.SysConfigCheckPo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.CtrlAccountPO;

import java.util.List;

/**
 * Created by wx
 */
public interface SysConfigCheckService {
    /**
     * 检测短信通道是否可用
     *
     * @return
     */
    ResponseData<String> checkSmsConfig(Long sysCompanyId,Long sysBrandId,String phone,SysConfigCheckPo sysConfigCheckPo,CheckErrMsgPo checkErrMsgPo);

    /**
     * 检测微信授权是否可用
     *
     * @return
     */
    ResponseData<Map<String, String>> checkWxConfig(Long sysCompanyId,Long sysBrandId,SysConfigCheckPo sysConfigCheckPo,CheckErrMsgPo checkErrMsgPo);

    /**
     * 检测微信模版是否可用
     *
     * @return
     */
    ResponseData<Map<String, String>> checkWxTemplate(Long sysCompanyId,Long sysBrandId,SysConfigCheckPo sysConfigCheckPo,CheckErrMsgPo checkErrMsgPo);
    ResponseData<List<SysConfigCheckPo>> getAllCheckStatusByCompanyIdAndBrandId(Long companyId, Long brandId);

    ResponseData<SysConfigCheckPo> manualCheckFetchCounter(Long companyId,String companyCode,CtrlAccountPO ctrlAccountPo);

    ResponseData<SysConfigCheckPo> manualCheckConnector(Long companyId, Long brandId,String companyCode, String brandCode,CtrlAccountPO ctrlAccountPo);

    ResponseData checkAddress(String offlineAddress);

}
