package com.bizvane.centercontrolservice.rpc;

import com.bizvane.centercontrolservice.models.vo.BrandBusinessFusionPayMethodSaveVo;
import com.bizvane.centercontrolservice.models.vo.BrandBusinessFusionPayMethodVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

@FeignClient(value = "${feign.client.centercontrol.name}", path = "${feign.client.centercontrol.path}/brandBusinessFusionPayRpc")
public interface BrandBusinessFusionPayRpcService {

    @GetMapping("getBrandBusinessFusionPayByBrandId")
    ResponseData<List<BrandBusinessFusionPayMethodVo>> getBrandBusinessFusionPayByBrandId(@RequestParam(value = "sysBrandId") Long sysBrandId, @RequestParam(value = "businessChannelCode") String businessChannelCode);


    @PostMapping("saveBrandBusinessFusionPay")
    ResponseData saveBrandBusinessFusionPay(@Valid @RequestBody BrandBusinessFusionPayMethodSaveVo brandBusinessFusionPayMethodSaveVo);

}
