package com.bizvane.centercontrolservice.interfaces;

import com.bizvane.centercontrolservice.models.bo.AppletFunctionBO;
import com.bizvane.centercontrolservice.models.po.AppletFunctionPO;
import com.bizvane.centercontrolservice.models.vo.AppletFunctionVO;
import com.bizvane.centercontrolservice.utils.PageFormUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.CtrlAccountPO;

/**
 * Created by Geng on 2018/8/24.
 */
public interface AppletRouteConfigService {
    /**
     * 新增菜单配置
     * @param appletFunctionPO
     * @param ctrlAccountPO
     * @return
     */
    ResponseData saveAppletFunction(AppletFunctionBO appletFunctionPO, CtrlAccountPO ctrlAccountPO);

    /**
     * 展示功能菜单
     * @param pageFormUtil
     * @param appletRouteVO
     * @return
     */
    public ResponseData showAppletFunction(PageFormUtil pageFormUtil, AppletFunctionVO appletRouteVO);

    /**
     * 更新小程序路由配置
     * @param appletFunctionPO
     * @return
     */
    public ResponseData updateAppletFunction(AppletFunctionBO appletFunctionPO,CtrlAccountPO ctrlAccountPO);

    /**
     * id  删除小程序路由配置
     * @param appletFunctionPO
     * @return
     */
    public ResponseData deleteAppletFunction(AppletFunctionPO appletFunctionPO,CtrlAccountPO ctrlAccountPO);

    /**
     * 查看某路由配置详情
     * @param appletFunctionId
     * @return
     */
    public ResponseData getAppletFunctionById(Long appletFunctionId);

    /**
     * 启用或禁用功能菜单
     * @param appletFunctionPO
     * @param ctrlAccountPO
     * @return
     */
    public ResponseData stopOrStartAppletFunctionById(AppletFunctionPO appletFunctionPO,CtrlAccountPO ctrlAccountPO);



//    /**
//     * 保存小程序路由配置
//     * @param appletRoutePO
//     * @return
//     */
//    public ResponseData saveAppletRoute(AppletRoutePO appletRoutePO, CtrlAccountPO ctrlAccountPO);
//
//    /**
//     * 展示所有路由
//     * @return
//     */
//    public ResponseData showAppletRoute(PageFormUtil pageFormUtil,AppletRouteVO appletRouteVO);
//
//    /**
//     * 更新小程序路由
//     * @param appletRoutePO
//     * @return
//     */
//    public ResponseData updateAppletRoute(AppletRoutePO appletRoutePO);
//
//    /**
//     * 删除路由配置
//     * @return
//     */
//    public ResponseData deleteAppletRoute(AppletRoutePO appletRoutePO,CtrlAccountPO ctrlAccountPO);
//
//    /**
//     * 展示详情
//     * @param appletRouteId
//     * @return
//     */
//    public ResponseData getAppletRouteById(Long appletRouteId);
//
//
//    /**
//     * 启用/禁用小程序路由
//     * @param appletRoutePO
//     * @return
//     */
//    public ResponseData stopOrStartAppletRouteById(AppletRoutePO appletRoutePO,CtrlAccountPO ctrlAccountPO);

}
