package com.bizvane.centercontrolservice.rpc;

import com.bizvane.centercontrolservice.models.po.DefProductPo;
import com.bizvane.centercontrolservice.models.vo.ProductVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * @author liufq
 */
@FeignClient(value = "${feign.client.centercontrol.name}",path = "${feign.client.centercontrol.path}/defProductRpc")
public interface DefProductServiceRpc {
    /**
     * 查询所有的产品列表
     *
     * @return
     * */
    @RequestMapping("/getDefProductList")
    List<ProductVo> getDefProductList();

    /**
     * 根据id更新产品信息
     * @param productPo
     */
    @RequestMapping("/updateById.do")
    void updateById(@RequestBody DefProductPo productPo);
}
