package com.bizvane.centercontrolservice.rpc;

import com.bizvane.centercontrolservice.models.vo.CompanyFusionPayMethodVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "${feign.client.centercontrol.name}",path = "${feign.client.centercontrol.path}/sysCompanyFusionPayConfigRpc")
public interface SysCompanyFusionPayConfigServiceRpc {

    /**
     * 查询企业目前启用支付渠道
     */
    @GetMapping(value = "/getCompanyFusionPayConfigMapByCompanyId")
    ResponseData<List<CompanyFusionPayMethodVo>> getCompanyFusionPayConfigMapByCompanyId(@RequestParam("sysCompanyId") Long sysCompanyId);

}
