package com.bizvane.centercontrolservice.models.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * @author pc4
 */
@Data
public class SysBrandConfigVo {
    /**
     * 品牌成长值开关
     */
    private Boolean growthSwitch;

    /**
     * 成长值功能启用开关
     */
    private Boolean enableGrowthSwitch;

    /**
     * 品牌组织短信开关
     */
    private Boolean organizationSms;

    /**
     * 品牌组织短信功能启用开关
     */
    private Boolean enableOrganizationSms;


    /**
     * 微信解绑功能开关 0关 1开
     * @return
     */
    private Boolean wxUnbindSwitch;

    /**
     * 会员注销功能开关 0关 1开
     */
    private Boolean mbrLogoutSwitch;


    /**
     * 品牌总部代运营组织运营开关 0关 1开
     */
    private Boolean brandProxyOrgSwitch;

    /**
     * 运营组织独立收款账户开关 0关 1开
     */
    private Boolean organizationWithdrawSwitch;

    /**
     * 运营组织收款账户类型 1品牌总部账户, 2会员所属运营组织账户
     */
    private Integer organizationWithdrawType;

    private Boolean wxElectMembershipCardSwitch;

    private Boolean wxElectCardHkPhoneSwitch;

    private Boolean alipayElectMembershipCardSwitch;

    /**
     * 会员中心装修：0=关闭；1=开启
     */
    private Boolean memberCenterRenovationSwitch;

    /**
     * 会员中心装修到期时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    private Date memberCenterRenovationExpirationDate;

    /**
     * 会员中心部署渠道字符串，英文逗号拼接,1-微信小程序,2-支付宝小程序
     */
    private String memberCenterChannels;

    /**
     * 手动执行自动标签数,默认 5
     * @return
     */
    private Integer manualAutuLabelCount;
    /**
     * 每天执行自动标签数,默认 5
     * @return
     */
    private Integer dailyAutuLabelCount;

    /**
     * 导购助手启用最大店铺数状态 0-不限制 1-限制
     * @return
     */
    private Integer maxStoreType;
    /**
     * 导购助手可启用的最大店铺数 数量0不限制
     * @return
     */
    private Integer maxStoreNum;


    /**
     * 区域通是否开启账号数量限制 0-不开启 1-开启
     */
    private Integer maxAreaType;

    /**
     * 区域通限制账号数量限
     */
    private Integer maxAreaNum;
    /**
     * QuickBI功能
     */
    private Boolean quickBiFlag;

    /**
     * QuickAudience功能
     */
    private Boolean quickAudienceFlag;

    /**
     * QA人群包同步开关 0关 1开
     */
    private Boolean qaAudienceSyncSwitch;

    /**
     * QA人群包同步开启最大数量
     */
    private Integer qaAudienceSyncNum;


    /**
     * 会员冻结功能开关 0关 1开
     */
    private Boolean mbrFrozenSwitch;

    /**
     * 会员卡码有效期开关：0-关闭，1-开启
     */
    private Boolean mbrCardCodeValiditySwitch;
    /**
     * 会员卡码有效期加密key，mbr_card_code_validity_switch字段为true时该字段有效
     */
    private String mbrCardCodeValidityKey;
    /**
     * 会员卡码有效期时间，单位分钟，mbr_card_code_validity_switch字段为true时该字段有效
     */
    private Double mbrCardCodeValidityTime;

    /**
     * 品牌QBIH5数据门户地址
     */
    private String qbiH5DataPortalUrl;

    public Boolean getMbrFrozenSwitch() {
        return mbrFrozenSwitch;
    }

    public void setMbrFrozenSwitch(Boolean mbrFrozenSwitch) {
        this.mbrFrozenSwitch = mbrFrozenSwitch;
    }

    /**
     * 官方标签同步企微开关0关1开
     */
    private Integer wxqyLabelSyncSwitch;

    public Integer getWxqyLabelSyncSwitch() {
        return wxqyLabelSyncSwitch;
    }

    public void setWxqyLabelSyncSwitch(Integer wxqyLabelSyncSwitch) {
        this.wxqyLabelSyncSwitch = wxqyLabelSyncSwitch;
    }

    public Boolean getGrowthSwitch() {
        return growthSwitch;
    }

    public void setGrowthSwitch(Boolean growthSwitch) {
        this.growthSwitch = growthSwitch;
    }

    public Boolean getEnableGrowthSwitch() {
        return enableGrowthSwitch;
    }

    public void setEnableGrowthSwitch(Boolean enableGrowthSwitch) {
        this.enableGrowthSwitch = enableGrowthSwitch;
    }

    public Boolean getOrganizationSms() {
        return organizationSms;
    }

    public void setOrganizationSms(Boolean organizationSms) {
        this.organizationSms = organizationSms;
    }

    public Boolean getEnableOrganizationSms() {
        return enableOrganizationSms;
    }

    public void setEnableOrganizationSms(Boolean enableOrganizationSms) {
        this.enableOrganizationSms = enableOrganizationSms;
    }

    public Boolean getWxUnbindSwitch() {
        return wxUnbindSwitch;
    }

    public void setWxUnbindSwitch(Boolean wxUnbindSwitch) {
        this.wxUnbindSwitch = wxUnbindSwitch;
    }

    public Boolean getWxElectMembershipCardSwitch() {
        return wxElectMembershipCardSwitch;
    }

    public void setWxElectMembershipCardSwitch(Boolean wxElectMembershipCardSwitch) {
        this.wxElectMembershipCardSwitch = wxElectMembershipCardSwitch;
    }

    public Boolean getAlipayElectMembershipCardSwitch() {
        return alipayElectMembershipCardSwitch;
    }

    public void setAlipayElectMembershipCardSwitch(Boolean alipayElectMembershipCardSwitch) {
        this.alipayElectMembershipCardSwitch = alipayElectMembershipCardSwitch;
    }

    public Boolean getMemberCenterRenovationSwitch() {
        return memberCenterRenovationSwitch;
    }

    public void setMemberCenterRenovationSwitch(Boolean memberCenterRenovationSwitch) {
        this.memberCenterRenovationSwitch = memberCenterRenovationSwitch;
    }

    public Date getMemberCenterRenovationExpirationDate() {
        return memberCenterRenovationExpirationDate;
    }

    public void setMemberCenterRenovationExpirationDate(Date memberCenterRenovationExpirationDate) {
        this.memberCenterRenovationExpirationDate = memberCenterRenovationExpirationDate;
    }

    public String getMemberCenterChannels() {
        return memberCenterChannels;
    }

    public void setMemberCenterChannels(String memberCenterChannels) {
        this.memberCenterChannels = memberCenterChannels;
    }

    public Integer getManualAutuLabelCount() {
        return manualAutuLabelCount;
    }

    public void setManualAutuLabelCount(Integer manualAutuLabelCount) {
        this.manualAutuLabelCount = manualAutuLabelCount;
    }

    public Integer getDailyAutuLabelCount() {
        return dailyAutuLabelCount;
    }

    public void setDailyAutuLabelCount(Integer dailyAutuLabelCount) {
        this.dailyAutuLabelCount = dailyAutuLabelCount;
    }

    public Integer getMaxStoreType() {
        return maxStoreType;
    }

    public void setMaxStoreType(Integer maxStoreType) {
        this.maxStoreType = maxStoreType;
    }

    public Integer getMaxStoreNum() {
        return maxStoreNum;
    }

    public void setMaxStoreNum(Integer maxStoreNum) {
        this.maxStoreNum = maxStoreNum;
    }

    public Boolean getMbrLogoutSwitch() {
        return mbrLogoutSwitch;
    }

    public void setMbrLogoutSwitch(Boolean mbrLogoutSwitch) {
        this.mbrLogoutSwitch = mbrLogoutSwitch;
    }

    public Integer getMaxAreaType() {
        return maxAreaType;
    }

    public void setMaxAreaType(Integer maxAreaType) {
        this.maxAreaType = maxAreaType;
    }

    public Integer getMaxAreaNum() {
        return maxAreaNum;
    }

    public void setMaxAreaNum(Integer maxAreaNum) {
        this.maxAreaNum = maxAreaNum;
    }

    public Boolean getMbrCardCodeValiditySwitch() {
      return mbrCardCodeValiditySwitch;
    }

    public void setMbrCardCodeValiditySwitch(Boolean mbrCardCodeValiditySwitch) {
      this.mbrCardCodeValiditySwitch = mbrCardCodeValiditySwitch;
    }

    public String getMbrCardCodeValidityKey() {
      return mbrCardCodeValidityKey;
    }

    public void setMbrCardCodeValidityKey(String mbrCardCodeValidityKey) {
      this.mbrCardCodeValidityKey = mbrCardCodeValidityKey;
    }

    public Double getMbrCardCodeValidityTime() {
      return mbrCardCodeValidityTime;
    }

    public void setMbrCardCodeValidityTime(Double mbrCardCodeValidityTime) {
      this.mbrCardCodeValidityTime = mbrCardCodeValidityTime;
    }



    public Boolean getQuickBiFlag() {
        return quickBiFlag;
    }

    public void setQuickBiFlag(Boolean quickBiFlag) {
        this.quickBiFlag = quickBiFlag;
    }

    public Boolean getQuickAudienceFlag() {
        return quickAudienceFlag;
    }

    public void setQuickAudienceFlag(Boolean quickAudienceFlag) {
        this.quickAudienceFlag = quickAudienceFlag;
    }

    public Boolean getQaAudienceSyncSwitch() {
        return qaAudienceSyncSwitch;
    }

    public void setQaAudienceSyncSwitch(Boolean qaAudienceSyncSwitch) {
        this.qaAudienceSyncSwitch = qaAudienceSyncSwitch;
    }

    public Integer getQaAudienceSyncNum() {
        return qaAudienceSyncNum;
    }

    public void setQaAudienceSyncNum(Integer qaAudienceSyncNum) {
        this.qaAudienceSyncNum = qaAudienceSyncNum;
    }

    public Boolean getBrandProxyOrgSwitch() {
        return brandProxyOrgSwitch;
    }

    public void setBrandProxyOrgSwitch(Boolean brandProxyOrgSwitch) {
        this.brandProxyOrgSwitch = brandProxyOrgSwitch;
    }

    public Boolean getOrganizationWithdrawSwitch() {
        return organizationWithdrawSwitch;
    }

    public void setOrganizationWithdrawSwitch(Boolean organizationWithdrawSwitch) {
        this.organizationWithdrawSwitch = organizationWithdrawSwitch;
    }

    public Integer getOrganizationWithdrawType() {
        return organizationWithdrawType;
    }

    public void setOrganizationWithdrawType(Integer organizationWithdrawType) {
        this.organizationWithdrawType = organizationWithdrawType;
    }

    public String getQbiH5DataPortalUrl() {
        return qbiH5DataPortalUrl;
    }

    public void setQbiH5DataPortalUrl(String qbiH5DataPortalUrl) {
        this.qbiH5DataPortalUrl = qbiH5DataPortalUrl;
    }
}
