/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.cdp.idmapping.service.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TableNameHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.DynamicTableNameInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.bizvane.cdp.idmapping.service.config.IdMappingThreadLocal;
import java.util.Arrays;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MyBatisPlusConfig {
    private final List<String> dynamicTableList = Arrays.asList("t_cdp_members_merge_record", "t_cdp_members");
    private final TableNameHandler getDynamicTableNameHandler = (sql, tableName) -> {
        if (!this.dynamicTableList.contains(tableName)) {
            return tableName;
        }
        Long tableSuffix = IdMappingThreadLocal.getTableSuffix();
        return tableName + "_" + tableSuffix;
    };

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        DynamicTableNameInnerInterceptor dynamicTableNameInnerInterceptor = new DynamicTableNameInnerInterceptor();
        dynamicTableNameInnerInterceptor.setTableNameHandler(this.getDynamicTableNameHandler);
        interceptor.addInnerInterceptor((InnerInterceptor)dynamicTableNameInnerInterceptor);
        interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor(DbType.MYSQL));
        return interceptor;
    }
}

