/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.cdp.commom.utils.qiniu;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.cdp.commom.utils.HttpUtil;
import com.bizvane.cdp.commom.utils.SpringContextUtil;
import com.bizvane.cdp.commom.utils.qiniu.QiNiuConfig;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.google.gson.Gson;
import com.qiniu.common.Zone;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.util.Auth;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class QiNiuUtil {
    private static final Logger log = LoggerFactory.getLogger(QiNiuUtil.class);
    private static Configuration cfg = new Configuration(QiNiuUtil.regionHD());
    private static UploadManager uploadManager = new UploadManager(cfg);

    private static Zone getZ0() {
        return new Zone.Builder().upHttp("http://upload.qiniup.com").upHttps("https://upload.qiniup.com").upBackupHttp("http://upload-z0.qiniup.com").upBackupHttps("https://upload-z0.qiniup.com").iovipHttp("http://iovip.qbox.me").iovipHttps("https://iovip.qbox.me").rsHttp("http://rs.qiniu.com").rsHttps("https://rs.qbox.me").rsfHttp("http://rsf.qiniu.com").rsfHttps("https://rsf.qbox.me").apiHttp("http://api.qiniu.com").apiHttps("https://api.qiniu.com").build();
    }

    public static Region regionHD() {
        return new Region.Builder().srcUpHost(new String[]{"upload.qiniup.com"}).accUpHost(new String[]{"upload.qiniup.com"}).iovipHost("iovip-z0.qbox.me").rsHost("rs-z0.qbox.me").rsfHost("rsf-z0.qbox.me").apiHost("api-z0.qiniu.com").build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String uploadUrl(String url, String key) {
        try (InputStream in = new URL(url).openStream();){
            String qiniuUrl;
            UploadManager uploadManager = QiNiuUtil.getUploadManager();
            String token = QiNiuUtil.getToken();
            Response response = uploadManager.put(in, key, token, null, null);
            DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
            String domain = SpringContextUtil.getBean(QiNiuConfig.class).getDomain();
            String string = qiniuUrl = domain + "/" + putRet.key;
            return string;
        }
        catch (Exception e) {
            log.error("uploadUrl error:{}", (Throwable)e);
            return null;
        }
    }

    public static String upload(InputStream in, String key) {
        try {
            UploadManager uploadManager = QiNiuUtil.getUploadManager();
            String token = QiNiuUtil.getToken();
            Response response = uploadManager.put(in, key, token, null, null);
            log.info("qiniuUtil upload response key: {}, get: {}", (Object)key, (Object)JacksonUtil.bean2Json((Object)response));
            DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
            String domain = SpringContextUtil.getBean(QiNiuConfig.class).getDomain();
            String url = domain + "/" + putRet.key;
            return url;
        }
        catch (Exception e) {
            log.error("upload error: {}", (Throwable)e);
            return null;
        }
    }

    public static String uploadFile(MultipartFile file, String key) {
        try {
            UploadManager uploadManager = QiNiuUtil.getUploadManager();
            String token = QiNiuUtil.getToken();
            Response response = uploadManager.put(file.getInputStream(), key, token, null, null);
            log.info("QiNiuUtil upload response key: {}, get: {}", (Object)key, (Object)JacksonUtil.bean2Json((Object)response));
            DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
            String domain = SpringContextUtil.getBean(QiNiuConfig.class).getDomain();
            String url = domain + "/" + putRet.key;
            return url;
        }
        catch (Exception e) {
            log.error("upload error: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static String upload(String bucketNm, File file) {
        try {
            UploadManager uploadManager = QiNiuUtil.getUploadManager();
            String token = QiNiuUtil.getToken();
            Response response = uploadManager.put(file.getAbsolutePath(), QiNiuUtil.newName(file.getName()), token);
            DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
            String domain = SpringContextUtil.getBean(QiNiuConfig.class).getDomain();
            String url = domain + "/" + putRet.key;
            return url;
        }
        catch (Exception e) {
            log.error("upload error:", (Throwable)e);
            return null;
        }
    }

    public static String newName(String oldName) {
        String[] datas = oldName.split("\\.");
        String type = datas[datas.length - 1];
        String newName = UUID.randomUUID().toString() + "." + type;
        return newName;
    }

    public static UploadManager getUploadManager() {
        return uploadManager;
    }

    private static String getToken() {
        QiNiuConfig qiNiuConfig = SpringContextUtil.getBean(QiNiuConfig.class);
        Auth auth = Auth.create((String)qiNiuConfig.getAccessKey(), (String)qiNiuConfig.getSecretKey());
        String upToken = auth.uploadToken(qiNiuConfig.getBucketNm());
        return upToken;
    }

    public static JSONObject getFileInfo(String qiniuUrl) throws Exception {
        JSONObject result = JSON.parseObject((String)HttpUtil.get(qiniuUrl + "?avinfo"));
        String resultStr = JSONObject.toJSONString((Object)result.get((Object)"format"));
        JSONObject jsonObject = JSONObject.parseObject((String)resultStr);
        return jsonObject;
    }

    public static String fileDir(Long sysCompanyId, Long sysBrandId) {
        return sysCompanyId + String.valueOf(File.separatorChar) + sysBrandId + String.valueOf(File.separatorChar);
    }
}

