/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.commom.utils;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.obs.services.internal.ServiceException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);

    public static void exportExcel(List<?> list, String title, String sheetName, Class<?> pojoClass, String fileName, HttpServletResponse response) {
        ExcelUtils.exportExcel(list, title, sheetName, pojoClass, fileName, true, response);
    }

    public static void exportExcel(List<?> list, String title, String sheetName, Class<?> pojoClass, String fileName, boolean isCreateHeader, HttpServletResponse response) {
        ExportParams exportParams = new ExportParams(title, sheetName);
        exportParams.setCreateHeadRows(isCreateHeader);
        exportParams.setType(ExcelType.XSSF);
        ExcelUtils.defaultExport(list, pojoClass, fileName, response, exportParams);
    }

    private static void defaultExport(List<?> list, Class<?> pojoClass, String fileName, HttpServletResponse response, ExportParams exportParams) {
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, pojoClass, list);
        ExcelUtils.downLoadExcel(fileName, response, workbook);
    }

    private static void downLoadExcel(String fileName, HttpServletResponse response, Workbook workbook) {
        try (ServletOutputStream output = response.getOutputStream();){
            response.setCharacterEncoding("UTF-8");
            if (workbook instanceof HSSFWorkbook) {
                fileName = fileName + ".xls";
                response.setContentType("application/vnd.ms-excel;charset=UTF-8");
            } else {
                fileName = fileName + ".xlsx";
                response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            }
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("gb2312"), "iso8859-1"));
            workbook.write((OutputStream)output);
            log.info("\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("\u5bfc\u51fa\u5931\u8d25,e={}", (Object)e.getMessage());
        }
    }

    private static void defaultExport(List<Map<String, Object>> list, String fileName, HttpServletResponse response) {
        Workbook workbook = ExcelExportUtil.exportExcel(list, (ExcelType)ExcelType.XSSF);
        ExcelUtils.downLoadExcel(fileName, response, workbook);
    }

    public static Workbook createWorkbook(List<?> list, String title, String sheetName, Class<?> pojoClass) {
        ExportParams exportParams = new ExportParams(title, sheetName);
        exportParams.setCreateHeadRows(true);
        exportParams.setType(ExcelType.XSSF);
        return ExcelExportUtil.exportExcel((ExportParams)exportParams, pojoClass, list);
    }

    public static File createExcelFile(List<?> list, String title, String sheetName, Class<?> pojoClass, String fileName) {
        ExportParams exportParams = new ExportParams(title, sheetName);
        exportParams.setCreateHeadRows(true);
        exportParams.setType(ExcelType.XSSF);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, pojoClass, list);
        File file = new File(fileName);
        try (FileOutputStream out = new FileOutputStream(file);){
            file.createNewFile();
            workbook.write((OutputStream)out);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }

    public static <T> List<T> importExcel(String filePath, Integer titleRows, Integer headerRows, Class<T> pojoClass) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return null;
        }
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        List list = null;
        try {
            list = ExcelImportUtil.importExcel((File)new File(filePath), pojoClass, (ImportParams)params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("EXCEL\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("\u5bfc\u5165\u6210\u529f");
        return list;
    }

    public static <T> List<T> importExcel(InputStream inputStream, Integer titleRows, Integer headerRows, Class<T> pojoClass) throws ServiceException {
        if (inputStream == null) {
            return null;
        }
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        List list = null;
        try {
            list = ExcelImportUtil.importExcel((InputStream)inputStream, pojoClass, (ImportParams)params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException("EXCEL\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u6a21\u677f");
        }
        log.info("\u5bfc\u5165\u6210\u529f");
        return list;
    }

    public static <T> Map<Object, List<T>> importExcelSheets(InputStream inputStream, Integer titleRows, Integer headerRows, Class<T> pojoClass) throws ServiceException {
        if (inputStream == null) {
            return null;
        }
        LinkedHashMap<Object, List<T>> map = null;
        Workbook book = null;
        try {
            book = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new ServiceException("EXCEL\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u6a21\u677f");
        }
        if (null == book) {
            return null;
        }
        map = new LinkedHashMap<Object, List<T>>();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            book.write((OutputStream)os);
        }
        catch (IOException e) {
            throw new ServiceException("EXCEL\u8f6c\u5316\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u6a21\u677f");
        }
        for (int numSheet = 0; numSheet < book.getNumberOfSheets(); ++numSheet) {
            ImportParams params = new ImportParams();
            params.setTitleRows(titleRows.intValue());
            params.setHeadRows(headerRows.intValue());
            params.setStartSheetIndex(numSheet);
            try {
                ExcelImportResult importResult = ExcelImportUtil.importExcelMore((InputStream)new ByteArrayInputStream(os.toByteArray()), pojoClass, (ImportParams)params);
                String sheetName = book.getSheetAt(numSheet).getSheetName();
                map.put(sheetName, importResult.getList());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServiceException("EXCEL\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u6a21\u677f");
            }
        }
        log.info("\u5bfc\u5165\u6210\u529f");
        return map;
    }

    public static <T> List<T> importExcel(MultipartFile file, Integer titleRows, Integer headerRows, Class<T> pojoClass) {
        if (file == null) {
            return null;
        }
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        List list = null;
        try {
            list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), pojoClass, (ImportParams)params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("EXCEL\u5bfc\u5165\u5931\u8d25");
        }
        log.info("\u5bfc\u5165\u6210\u529f");
        return list;
    }

    public static <T> List<T> importExcel(MultipartFile file, Integer titleRows, Integer headerRows, Integer readRows, Class<T> pojoClass) {
        if (file == null) {
            return null;
        }
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        params.setReadRows(readRows.intValue());
        List list = null;
        try {
            list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), pojoClass, (ImportParams)params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("EXCEL\u5bfc\u5165\u5931\u8d25");
        }
        log.info("\u5bfc\u5165\u6210\u529f");
        return list;
    }

    public static void downLoadToExcel(String fileName, HttpServletResponse response, Workbook workbook) {
        try (ServletOutputStream output = response.getOutputStream();){
            response.setCharacterEncoding("UTF-8");
            if (workbook instanceof HSSFWorkbook) {
                fileName = fileName + ".xls";
                response.setContentType("application/vnd.ms-excel;charset=UTF-8");
            } else {
                fileName = fileName + ".xlsx";
                response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            }
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("gb2312"), "iso8859-1"));
            workbook.write((OutputStream)output);
            log.info("\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createToExcelFile(String fileName, Workbook workbook, String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdir();
        }
        try (OutputStream output = Files.newOutputStream(new File(file, fileName).toPath(), new OpenOption[0]);){
            fileName = workbook instanceof HSSFWorkbook ? fileName + ".xls" : fileName + ".xlsx";
            workbook.write(output);
            log.info("File[" + fileName + "]\u5df2\u6210\u529f\u4fdd\u5b58\u81f3[" + path + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(HttpServletResponse response, String downloadFile, String showFileName) {
        BufferedInputStream bis = null;
        InputStream is = null;
        OutputStream os = null;
        FilterOutputStream bos = null;
        try {
            File file = new File(downloadFile);
            if (!file.exists()) {
                log.info("\u4e0b\u8f7d\u5931\u8d25,\u6587\u4ef6\u4e0d\u5b58\u5728={}", (Object)downloadFile);
                return;
            }
            String fileName = file.getName();
            is = Files.newInputStream(file.toPath(), new OpenOption[0]);
            os = response.getOutputStream();
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream(os);
            fileName = URLEncoder.encode(showFileName, "UTF-8");
            fileName = new String(fileName.getBytes("UTF-8"), "GBK");
            response.reset();
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/x-msdownload");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            int bytesRead = 0;
            byte[] buffer = new byte[1024];
            while ((bytesRead = bis.read(buffer)) != -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, bytesRead);
            }
            log.info("\u4e0b\u8f7d\u6210\u529f={}", (Object)showFileName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (null != bis) {
                    bis.close();
                    bis = null;
                }
                if (null != bos) {
                    bos.close();
                    bos = null;
                }
                if (null != is) {
                    is.close();
                    is = null;
                }
                if (null != os) {
                    os.close();
                    os = null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

