package com.bizvane.cdp.algorithm.facade.interfaces.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@ApiModel(value = "CdpCustomerImportGroupRequestVO", description = "客户标签导入对象")
public class CdpCustomerImportGroupRequestVO {

    @ApiModelProperty(value = "企业ID")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌ID")
    private Long sysBrandId;

    @ApiModelProperty(value = "分群ID")
    private String groupId;

    @ApiModelProperty(value = "客户分群导入列表")
    private List<CustomerGroupInfo> customerGroupInfoList;


    @Data
    public static class CustomerGroupInfo {

        @ApiModelProperty(value = "客户身份id")
        private String signId;

        @ApiModelProperty(value = "客户身份id值")
        private String signIdValue;

        @ApiModelProperty(value = "创建时间")
        private Date createDate;

        @ApiModelProperty(value = "数据有效性")
        private Integer valid;

    }


}
