package com.bizvane.cdp.algorithm.facade.interfaces;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.cdp.algorithm.facade.interfaces.model.CdpCustomerGroupDetailReqVO;
import com.bizvane.cdp.algorithm.facade.interfaces.model.CdpCustomerImportGroupDelRequestVO;
import com.bizvane.cdp.algorithm.facade.interfaces.model.CdpCustomerImportGroupRequestVO;
import com.bizvane.cdp.algorithm.facade.interfaces.model.CdpCustomerImportLabelDelRequestVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.Map;

@FeignClient(value = "${feign.client.cdp-algorithm.name}", path = "${feign.client.cdp-algorithm.path}/cdpCustomerGroupDetail")
@Api(value = "客户标签圈选人群详情", tags = {"客户标签圈选人群详情"})
public interface CdpCustomerGroupDetailFeign {

    @PostMapping("/getCustomerGroupDetailByGroupId")
    ResponseData<Page<Map<String, Object>>> getCustomerGroupDetailByGroupId(@RequestBody CdpCustomerGroupDetailReqVO reqVO);

    @PostMapping("/saveImportGroupRecord")
    ResponseData<Boolean> saveImportGroupRecord(@RequestBody CdpCustomerImportGroupRequestVO reqVO);

    @PostMapping("/deleteGroupImportByGroupId")
    ResponseData<Boolean> deleteGroupImportByGroupId(@RequestBody CdpCustomerImportGroupDelRequestVO reqVO);


}
