/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.rpc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSkuDetailPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSkuLogPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSpecPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSpecRelationPOMapper;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.po.GoodsPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuDetailPO;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuDetailPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuLogPO;
import com.wmeimob.fastboot.bizvane.po.GoodsSpecPO;
import com.wmeimob.fastboot.bizvane.po.GoodsSpecPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsSpecRelationPO;
import com.wmeimob.fastboot.bizvane.po.GoodsSpecRelationPOExample;
import com.wmeimob.fastboot.bizvane.service.rpc.GoodsSyncRpcService;
import com.wmeimob.fastboot.bizvane.util.TimeUtils;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.rpc.SysDimSkuProperties;
import com.wmeimob.fastboot.bizvane.vo.rpc.SysDimSkuVo;
import com.wmeimob.fastboot.config.MallAdminException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GoodsSyncRpcServiceImpl
implements GoodsSyncRpcService {
    private static final Logger log = LoggerFactory.getLogger(GoodsSyncRpcServiceImpl.class);
    @Autowired
    private GoodsSpecPOMapper goodsSpecPOMapper;
    @Autowired
    private GoodsSkuDetailPOMapper goodsSkuDetailPOMapper;
    @Autowired
    private GoodsPOMapper goodsPOMapper;
    @Autowired
    private GoodsSpecRelationPOMapper goodsSpecRelationPOMapper;
    @Autowired
    private GoodsSkuLogPOMapper goodsSkuLogPOMapper;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"rpc/addGoods"})
    public Integer addGoods(@RequestBody SysDimSkuVo sysDimSkuVo) {
        GoodsSkuDetailPO goodsSkuDetailPO;
        GoodsSkuDetailPOExample goodsSkuDetailPOExample;
        GoodsPO goodsPO;
        GoodsPOExample example;
        List propertiesList;
        Integer goodsSpecSizeIdI;
        Integer goodsSpecColorIdI;
        Integer goodsSkuDetailId;
        Boolean isUniform;
        Integer goodsId;
        Integer stocks;
        String productCodes;
        block36: {
            log.info("GoodsSyncRpcServiceImpl#addGoods:[{}]", JSON.toJSON((Object)sysDimSkuVo));
            productCodes = "";
            stocks = 0;
            goodsId = 0;
            isUniform = Boolean.FALSE;
            goodsSkuDetailId = 0;
            if (StringUtils.isBlank((CharSequence)sysDimSkuVo.getProductCode())) {
                return -1;
            }
            if (StringUtils.isBlank((CharSequence)sysDimSkuVo.getSkuCode())) {
                return -1;
            }
            if (sysDimSkuVo.getPriceSug().compareTo(sysDimSkuVo.getCostEst()) < 0) {
                throw new MallAdminException("\u540a\u724c\u4ef7\u4e0d\u80fd\u4f4e\u4e8e\u9500\u552e\u4ef7");
            }
            GoodsPOExample goodsPOExample = new GoodsPOExample();
            goodsPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andSysBrandIdEqualTo(Integer.valueOf(sysDimSkuVo.getSysBrandId().intValue())).andGoodsNoEqualTo(productCodes).andIsDelEqualTo(Boolean.valueOf(false));
            List goodsPOList1 = this.goodsPOMapper.selectByExample(goodsPOExample);
            if (CollectionUtils.isNotEmpty((Collection)goodsPOList1)) {
                GoodsPO goodsPO2 = (GoodsPO)goodsPOList1.get(0);
                GoodsSkuDetailPOExample goodsSkuDetailPOExample1 = new GoodsSkuDetailPOExample();
                goodsSkuDetailPOExample1.createCriteria().andValidEqualTo(Boolean.TRUE).andGoodsIdEqualTo(goodsPO2.getId()).andMerchantIdEqualTo(Integer.valueOf(sysDimSkuVo.getSysBrandId().intValue()));
                List goodsSkuDetailPOS = this.goodsSkuDetailPOMapper.selectByExample(goodsSkuDetailPOExample1);
                log.info("GoodsSyncRpcServiceImpl#goodsSkuDetailPOS:{}", JSON.toJSON((Object)goodsSkuDetailPOS));
                if (goodsSkuDetailPOS.size() > 1) {
                    isUniform = Boolean.FALSE;
                }
            }
            ArrayList<String> specNameList = new ArrayList<String>();
            specNameList.add("\u989c\u8272");
            specNameList.add("\u5c3a\u5bf8");
            GoodsSpecPOExample examples = new GoodsSpecPOExample();
            examples.createCriteria().andValidEqualTo(Boolean.TRUE).andSpecNameIn(specNameList).andMerchantIdEqualTo(Integer.valueOf(Integer.parseInt(String.valueOf(sysDimSkuVo.getSysBrandId()))));
            List goodsSpecPOList = this.goodsSpecPOMapper.selectByExample(examples);
            log.info("GoodsSyncRpcServiceImpl#goodsSpecPOList:{}", JSON.toJSON((Object)goodsSpecPOList));
            goodsSpecColorIdI = 0;
            goodsSpecSizeIdI = 0;
            if (goodsSpecPOList.size() > 0 && goodsSpecPOList.size() >= 2) {
            } else {
                return -1;
            }
            for (int i = 0; i < goodsSpecPOList.size(); ++i) {
                GoodsSpecPO goodsSpecPO = (GoodsSpecPO)goodsSpecPOList.get(i);
                if ("\u989c\u8272".equals(goodsSpecPO.getSpecName())) {
                    goodsSpecColorIdI = goodsSpecPO.getId();
                    continue;
                }
                if (!"\u5c3a\u5bf8".equals(goodsSpecPO.getSpecName())) continue;
                goodsSpecSizeIdI = goodsSpecPO.getId();
            }
            propertiesList = new ArrayList<SysDimSkuProperties>();
            String properties = sysDimSkuVo.getProperties();
            if (StringUtils.isNotBlank((CharSequence)properties)) {
                try {
                    Object parse = JSON.parse((String)properties);
                    if (parse instanceof JSONObject) {
                        SysDimSkuProperties sysDimSkuProperties = (SysDimSkuProperties)JSON.parseObject((String)properties, SysDimSkuProperties.class);
                        propertiesList.add(sysDimSkuProperties);
                        break block36;
                    }
                    if (parse instanceof JSONArray) {
                        propertiesList = JSON.parseArray((String)properties, SysDimSkuProperties.class);
                    }
                }
                catch (Exception e) {
                    log.warn("\u6b64\u5546\u54c1\u662f\u9519\u8bef\u7684\u5c5e\u6027:{}", (Object)properties);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(propertiesList)) {
            log.info("\u540c\u6b65\u7684\u5546\u54c1\u54c1\u724c\u540d:{}\uff0c\u540c\u6b65\u7684\u5546\u54c1barcode:{}", (Object)((SysDimSkuProperties)propertiesList.get(0)).getBrandName(), (Object)sysDimSkuVo.getBarCode());
            sysDimSkuVo.setBrandName(((SysDimSkuProperties)propertiesList.get(0)).getBrandName());
        }
        Integer merchantId = Integer.parseInt(String.valueOf(sysDimSkuVo.getSysBrandId()));
        String colorPrd = sysDimSkuVo.getColorPrd();
        String sizePrd = sysDimSkuVo.getSizePrd();
        if (StringUtils.isEmpty((CharSequence)colorPrd)) {
            colorPrd = "\u5747\u8272";
        }
        if (StringUtils.isEmpty((CharSequence)sizePrd)) {
            sizePrd = "\u5747\u7801";
        }
        if (!productCodes.equals(sysDimSkuVo.getProductCode())) {
            if (sysDimSkuVo.getI() != 0) {
                example = new GoodsPOExample();
                example.createCriteria().andValidEqualTo(Boolean.TRUE).andIdEqualTo(goodsId);
                goodsPO = new GoodsPO();
                goodsPO.setStock(stocks);
                if (!isUniform.booleanValue()) {
                    goodsPO.setIsUniform(Boolean.valueOf(false));
                    goodsSkuDetailPOExample = new GoodsSkuDetailPOExample();
                    goodsSkuDetailPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andGoodsIdEqualTo(goodsId);
                    goodsSkuDetailPO = new GoodsSkuDetailPO();
                    goodsSkuDetailPO.setIsUniform(Boolean.valueOf(false));
                    goodsSkuDetailPO.setMerchantId(merchantId);
                    goodsSkuDetailPO.setSysBrandId(merchantId);
                    this.goodsSkuDetailPOMapper.updateByExampleSelective(goodsSkuDetailPO, goodsSkuDetailPOExample);
                }
                goodsPO.setBarCode(sysDimSkuVo.getBarCode());
                goodsPO.setBrandName(sysDimSkuVo.getBrandName());
                goodsPO.setSysBrandId(merchantId);
                goodsPO.setIsUniform(Boolean.valueOf(false));
                this.goodsPOMapper.updateByExampleSelective(goodsPO, example);
                stocks = 0;
            }
            productCodes = sysDimSkuVo.getProductCode();
            GoodsPO goodsPO3 = new GoodsPO();
            goodsPO3.setGoodsNo(productCodes);
            goodsPO3.setGoodsName(sysDimSkuVo.getProductName());
            goodsPO3.setSalePrice(BigDecimal.valueOf(sysDimSkuVo.getCostEst()));
            goodsPO3.setMarketPrice(BigDecimal.valueOf(sysDimSkuVo.getPriceSug()));
            goodsPO3.setMerchantId(merchantId);
            goodsPO3.setSysBrandId(merchantId);
            goodsPO3.setOfflineGoodsId(sysDimSkuVo.getProductId());
            goodsPO3.setBarCode(sysDimSkuVo.getBarCode());
            goodsPO3.setBrandName(sysDimSkuVo.getBrandName());
            goodsPO3.setGmtCreate(sysDimSkuVo.getCreateDate());
            goodsPO3.setIsUniform(isUniform);
            GoodsPOExample example2 = new GoodsPOExample();
            GoodsPOExample.Criteria criteria = example2.createCriteria().andValidEqualTo(Boolean.TRUE).andSysBrandIdEqualTo(merchantId).andGoodsNoEqualTo(productCodes).andIsDelEqualTo(Boolean.valueOf(false));
            List goodsPOList = this.goodsPOMapper.selectByExample(example2);
            log.info("GoodsSyncRpcServiceImpl#goodsPOList:{}", JSON.toJSON((Object)goodsPOList));
            if (CollectionUtils.isNotEmpty((Collection)goodsPOList)) {
                criteria.andMerchantIdEqualTo(merchantId);
                this.goodsPOMapper.updateByExampleSelective(goodsPO3, example2);
                if (!((GoodsPO)goodsPOList.get(0)).getMerchantId().equals(((GoodsPO)goodsPOList.get(0)).getSysBrandId())) {
                    log.info("\u8be5\u5546\u54c1\u5b58\u5728\u4e8e\u5b50\u5546\u57ce\u4f46\u662f\u4e0d\u5b58\u5728\u4e8e\u4e3b\u5546\u57ce");
                    return -1;
                }
                goodsId = ((GoodsPO)goodsPOList.get(0)).getId();
            } else {
                log.info("\u4e2d\u53f0\u540c\u6b65\u5546\u54c1\u65b0\u589e\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)goodsPO3));
                this.goodsPOMapper.insertSelective(goodsPO3);
                goodsId = goodsPO3.getId();
            }
            GoodsSpecRelationPOExample goodsSpecRelationPOColorExample = new GoodsSpecRelationPOExample();
            goodsSpecRelationPOColorExample.createCriteria().andValidEqualTo(Boolean.TRUE).andGoodsIdEqualTo(goodsId).andMerchantIdEqualTo(Integer.valueOf(sysDimSkuVo.getSysBrandId().intValue())).andSpecIdEqualTo(goodsSpecColorIdI);
            List goodsSpecRelationColorPOS = this.goodsSpecRelationPOMapper.selectByExample(goodsSpecRelationPOColorExample);
            if (CollectionUtils.isEmpty((Collection)goodsSpecRelationColorPOS)) {
                GoodsSpecRelationPO goodsSpecRelationColorPO = new GoodsSpecRelationPO();
                goodsSpecRelationColorPO.setSpecId(goodsSpecColorIdI);
                goodsSpecRelationColorPO.setGoodsId(goodsId);
                goodsSpecRelationColorPO.setMerchantId(Integer.valueOf(sysDimSkuVo.getSysBrandId().intValue()));
                this.goodsSpecRelationPOMapper.insertSelective(goodsSpecRelationColorPO);
            }
            GoodsSpecRelationPOExample goodsSpecRelationPOSizeExample = new GoodsSpecRelationPOExample();
            goodsSpecRelationPOSizeExample.createCriteria().andValidEqualTo(Boolean.TRUE).andGoodsIdEqualTo(goodsId).andMerchantIdEqualTo(Integer.valueOf(sysDimSkuVo.getSysBrandId().intValue())).andSpecIdEqualTo(goodsSpecSizeIdI);
            List goodsSpecRelationSizePOS = this.goodsSpecRelationPOMapper.selectByExample(goodsSpecRelationPOSizeExample);
            if (CollectionUtils.isEmpty((Collection)goodsSpecRelationSizePOS)) {
                GoodsSpecRelationPO goodsSpecRelationSizePO = new GoodsSpecRelationPO();
                goodsSpecRelationSizePO.setSpecId(goodsSpecSizeIdI);
                goodsSpecRelationSizePO.setGoodsId(goodsId);
                goodsSpecRelationSizePO.setMerchantId(Integer.valueOf(sysDimSkuVo.getSysBrandId().intValue()));
                this.goodsSpecRelationPOMapper.insertSelective(goodsSpecRelationSizePO);
            }
        }
        if (sysDimSkuVo.getI() == sysDimSkuVo.getSize() - 1) {
            example = new GoodsPOExample();
            example.createCriteria().andValidEqualTo(Boolean.TRUE).andIdEqualTo(goodsId);
            goodsPO = new GoodsPO();
            goodsPO.setStock(stocks);
            goodsPO.setBarCode(sysDimSkuVo.getBarCode());
            goodsPO.setBrandName(sysDimSkuVo.getBrandName());
            goodsPO.setSysBrandId(merchantId);
            goodsPO.setIsUniform(isUniform);
            if (!isUniform.booleanValue()) {
                goodsPO.setIsUniform(Boolean.valueOf(false));
                goodsSkuDetailPOExample = new GoodsSkuDetailPOExample();
                goodsSkuDetailPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andGoodsIdEqualTo(goodsId);
                goodsSkuDetailPO = new GoodsSkuDetailPO();
                goodsSkuDetailPO.setIsUniform(Boolean.valueOf(false));
                goodsSkuDetailPO.setMerchantId(merchantId);
                goodsSkuDetailPO.setSysBrandId(merchantId);
                this.goodsSkuDetailPOMapper.updateByExampleSelective(goodsSkuDetailPO, goodsSkuDetailPOExample);
            }
            this.goodsPOMapper.updateByExampleSelective(goodsPO, example);
            stocks = 0;
        }
        GoodsSpecPOExample goodsSpecColorPOExample = new GoodsSpecPOExample();
        goodsSpecColorPOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId).andSpecNameEqualTo(colorPrd);
        List goodsSpecColorPOList = this.goodsSpecPOMapper.selectByExample(goodsSpecColorPOExample);
        Integer goodSpecColorId = 0;
        if (goodsSpecColorPOList.size() > 0) {
            goodSpecColorId = ((GoodsSpecPO)goodsSpecColorPOList.get(0)).getId();
        } else {
            GoodsSpecPO goodsSpecPO = new GoodsSpecPO();
            goodsSpecPO.setMerchantId(merchantId);
            goodsSpecPO.setPid(goodsSpecColorIdI);
            goodsSpecPO.setSpecName(colorPrd);
            goodsSpecPO.setGmtCreate(TimeUtils.getNowTime());
            goodsSpecPO.setGmtModified(TimeUtils.getNowTime());
            this.goodsSpecPOMapper.insertSelective(goodsSpecPO);
            goodSpecColorId = goodsSpecPO.getId();
        }
        GoodsSpecRelationPOExample goodsSpecRelationPOExample1 = new GoodsSpecRelationPOExample();
        goodsSpecRelationPOExample1.createCriteria().andValidEqualTo(Boolean.TRUE).andSpecIdEqualTo(goodSpecColorId).andGoodsIdEqualTo(goodsId).andValidEqualTo(Boolean.TRUE);
        List goodsSpecRelationPOList = this.goodsSpecRelationPOMapper.selectByExample(goodsSpecRelationPOExample1);
        if (goodsSpecRelationPOList.size() == 0) {
            GoodsSpecRelationPO goodsSpecRelationColorPO = new GoodsSpecRelationPO();
            goodsSpecRelationColorPO.setSpecId(goodSpecColorId);
            goodsSpecRelationColorPO.setGoodsId(goodsId);
            goodsSpecRelationColorPO.setMerchantId(Integer.valueOf(sysDimSkuVo.getSysBrandId().intValue()));
            this.goodsSpecRelationPOMapper.insertSelective(goodsSpecRelationColorPO);
        }
        GoodsSpecPOExample goodsSpecSizePOExample = new GoodsSpecPOExample();
        goodsSpecSizePOExample.createCriteria().andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(merchantId).andSpecNameEqualTo(sizePrd);
        List goodsSpecSizePOList = this.goodsSpecPOMapper.selectByExample(goodsSpecSizePOExample);
        Integer goodSpecSizeId = 0;
        if (CollectionUtils.isNotEmpty((Collection)goodsSpecSizePOList)) {
            goodSpecSizeId = ((GoodsSpecPO)goodsSpecSizePOList.get(0)).getId();
        } else {
            GoodsSpecPO goodsSpecPO = new GoodsSpecPO();
            goodsSpecPO.setMerchantId(merchantId);
            goodsSpecPO.setPid(goodsSpecSizeIdI);
            goodsSpecPO.setSpecName(sizePrd);
            goodsSpecPO.setGmtCreate(TimeUtils.getNowTime());
            goodsSpecPO.setGmtModified(TimeUtils.getNowTime());
            this.goodsSpecPOMapper.insertSelective(goodsSpecPO);
            goodSpecSizeId = goodsSpecPO.getId();
        }
        GoodsSpecRelationPOExample goodsSpecRelationPOExample2 = new GoodsSpecRelationPOExample();
        goodsSpecRelationPOExample2.createCriteria().andValidEqualTo(Boolean.TRUE).andSpecIdEqualTo(goodSpecSizeId).andGoodsIdEqualTo(goodsId).andValidEqualTo(Boolean.TRUE);
        List goodsSpecRelationPOList1 = this.goodsSpecRelationPOMapper.selectByExample(goodsSpecRelationPOExample2);
        if (goodsSpecRelationPOList1.size() == 0) {
            GoodsSpecRelationPO goodsSpecRelationSizePO = new GoodsSpecRelationPO();
            goodsSpecRelationSizePO.setSpecId(goodSpecSizeId);
            goodsSpecRelationSizePO.setGoodsId(goodsId);
            goodsSpecRelationSizePO.setMerchantId(Integer.valueOf(sysDimSkuVo.getSysBrandId().intValue()));
            this.goodsSpecRelationPOMapper.insertSelective(goodsSpecRelationSizePO);
        }
        GoodsSkuDetailPOExample example3 = new GoodsSkuDetailPOExample();
        example3.createCriteria().andValidEqualTo(Boolean.TRUE).andSkuNoEqualTo(sysDimSkuVo.getSkuCode()).andGoodsIdEqualTo(goodsId);
        List goodsSkuDetailPOList = this.goodsSkuDetailPOMapper.selectByExample(example3);
        GoodsSkuDetailPO goodsSkuDetailPO2 = new GoodsSkuDetailPO();
        goodsSkuDetailPO2.setGoodsId(goodsId);
        goodsSkuDetailPO2.setSpecNames(colorPrd + "," + sizePrd);
        goodsSkuDetailPO2.setSpecIds(goodSpecColorId + "," + goodSpecSizeId);
        goodsSkuDetailPO2.setSkuNo(sysDimSkuVo.getSkuCode());
        goodsSkuDetailPO2.setSalesPrice(BigDecimal.valueOf(sysDimSkuVo.getCostEst()));
        goodsSkuDetailPO2.setMarketPrice(BigDecimal.valueOf(sysDimSkuVo.getPriceSug()));
        goodsSkuDetailPO2.setStock(sysDimSkuVo.getNumStocks());
        goodsSkuDetailPO2.setOfflineSkuId(sysDimSkuVo.getSkuId());
        goodsSkuDetailPO2.setMerchantId(merchantId);
        goodsSkuDetailPO2.setSysBrandId(merchantId);
        goodsSkuDetailPO2.setIsUniform(isUniform);
        stocks = stocks + sysDimSkuVo.getNumStocks();
        if (goodsSkuDetailPOList.size() > 0) {
            this.goodsSkuDetailPOMapper.updateByExampleSelective(goodsSkuDetailPO2, example3);
        } else {
            goodsSkuDetailId = this.goodsSkuDetailPOMapper.insertSelective(goodsSkuDetailPO2);
        }
        GoodsSkuDetailPOExample example1 = new GoodsSkuDetailPOExample();
        example1.createCriteria().andValidEqualTo(Boolean.TRUE).andGoodsIdEqualTo(goodsId);
        List goodsSkuDetailPOs = this.goodsSkuDetailPOMapper.selectByExample(example1);
        if (!CollectionUtils.isEmpty((Collection)goodsSkuDetailPOs) && goodsSkuDetailPOs.size() > 1) {
            GoodsSkuDetailPO goodsSkuDetailPO1 = new GoodsSkuDetailPO();
            goodsSkuDetailPO1.setIsUniform(Boolean.valueOf(false));
            goodsSkuDetailPO2.setMerchantId(merchantId);
            goodsSkuDetailPO2.setSysBrandId(merchantId);
            this.goodsSkuDetailPOMapper.updateByExampleSelective(goodsSkuDetailPO1, example1);
            GoodsPO goodsPO4 = new GoodsPO();
            goodsPO4.setSysBrandId(merchantId);
            goodsPO4.setIsUniform(Boolean.valueOf(false));
            goodsPO4.setId(goodsId);
            goodsPO4.setBarCode(sysDimSkuVo.getBarCode());
            goodsPO4.setBrandName(sysDimSkuVo.getBrandName());
            this.goodsPOMapper.updateByPrimaryKeySelective(goodsPO4);
        }
        this.saveGoodsSkuLog(sysDimSkuVo, productCodes, goodsId, merchantId, goodsSkuDetailId);
        return 1;
    }

    @PostMapping(value={"rpc/getSkuImg"})
    public ResponseData getSkuImgForCenterStage(@RequestBody Map vo) {
        log.info("GoodsSyncServiceImpl#getSkuImgForCenterStage#vo:{}", (Object)JSON.toJSONString((Object)vo));
        GoodsSkuDetailPOExample goodsSkuDetailPOExample = new GoodsSkuDetailPOExample();
        goodsSkuDetailPOExample.createCriteria().andSkuNoEqualTo(String.valueOf(vo.get("skuNo"))).andValidEqualTo(Boolean.TRUE).andMerchantIdEqualTo(Integer.valueOf(Math.toIntExact(Long.valueOf(vo.get("sysBrandId").toString()))));
        List goodsSkuDetailPOS = this.goodsSkuDetailPOMapper.selectByExample(goodsSkuDetailPOExample);
        if (CollectionUtils.isNotEmpty((Collection)goodsSkuDetailPOS)) {
            String img = ((GoodsSkuDetailPO)goodsSkuDetailPOS.get(0)).getSkuImg();
            return ResponseUtil.getSuccessData((Object)img);
        }
        return ResponseUtil.getFailedData(null);
    }

    private void saveGoodsSkuLog(SysDimSkuVo sysDimSkuVo, String productCodes, Integer goodsId, Integer merchantId, Integer goodsSkuDetailId) {
        log.info("\u4fdd\u5b58\u540c\u6b65\u5546\u54c1\u64cd\u4f5c\u8bb0\u5f55\uff1a" + JSON.toJSON((Object)sysDimSkuVo));
        GoodsSkuLogPO goodsSkuLogPO = new GoodsSkuLogPO();
        goodsSkuLogPO.setMerchantId(merchantId);
        goodsSkuLogPO.setGmtCreate(new Date());
        goodsSkuLogPO.setSkuNo(sysDimSkuVo.getSkuCode());
        goodsSkuLogPO.setGoodsId(goodsId);
        goodsSkuLogPO.setGoodsNo(productCodes);
        goodsSkuLogPO.setGoodsSkuDetailId(goodsSkuDetailId);
        goodsSkuLogPO.setNewMarketPrice(BigDecimal.valueOf(sysDimSkuVo.getPriceSug()));
        goodsSkuLogPO.setNewSalesPrice(BigDecimal.valueOf(sysDimSkuVo.getCostEst()));
        goodsSkuLogPO.setNewStock(sysDimSkuVo.getNumStocks());
        goodsSkuLogPO.setUserAccount(sysDimSkuVo.getUserAccount());
        goodsSkuLogPO.setUserCreate(sysDimSkuVo.getUserCreate());
        goodsSkuLogPO.setValid(Boolean.valueOf(true));
        this.goodsSkuLogPOMapper.insert(goodsSkuLogPO);
    }
}

