/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.qdqm;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.CompanyBrandRelation;
import com.wmeimob.fastboot.bizvane.entity.Goods;
import com.wmeimob.fastboot.bizvane.entity.GoodsClassifyCustom;
import com.wmeimob.fastboot.bizvane.entity.GoodsPropHead;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.GoodsSyncRecord;
import com.wmeimob.fastboot.bizvane.entity.GoodsSyncRecordExample;
import com.wmeimob.fastboot.bizvane.mapper.CompanyBrandRelationMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsClassifyCustomMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsClassifyMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsPropHeadMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSkuDetailMapper;
import com.wmeimob.fastboot.bizvane.mapper.GoodsSyncRecordMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsClassifyCustomPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsClassifyPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPropHeadPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPropValueCustomPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPropValuePOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSkuDetailPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSpecPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsSpecRelationPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsTagCustomPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsTagPOMapper;
import com.wmeimob.fastboot.bizvane.po.GoodsClassifyCustomPO;
import com.wmeimob.fastboot.bizvane.po.GoodsClassifyCustomPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsClassifyPO;
import com.wmeimob.fastboot.bizvane.po.GoodsClassifyPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.po.GoodsPropHeadPO;
import com.wmeimob.fastboot.bizvane.po.GoodsPropHeadPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsPropValueCustomPO;
import com.wmeimob.fastboot.bizvane.po.GoodsPropValueCustomPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsPropValuePO;
import com.wmeimob.fastboot.bizvane.po.GoodsPropValuePOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuDetailPO;
import com.wmeimob.fastboot.bizvane.po.GoodsSkuDetailPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsSpecPO;
import com.wmeimob.fastboot.bizvane.po.GoodsSpecPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsSpecRelationPO;
import com.wmeimob.fastboot.bizvane.po.GoodsSpecRelationPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsTagCustomPO;
import com.wmeimob.fastboot.bizvane.po.GoodsTagCustomPOExample;
import com.wmeimob.fastboot.bizvane.po.GoodsTagPO;
import com.wmeimob.fastboot.bizvane.po.GoodsTagPOExample;
import com.wmeimob.fastboot.bizvane.service.qdqm.GoodsSyncChildService;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class GoodsSyncChildServiceImpl
implements GoodsSyncChildService {
    private static final Logger log = LoggerFactory.getLogger(GoodsSyncChildServiceImpl.class);
    @Resource
    private GoodsClassifyMapper goodsClassifyMapper;
    @Resource
    private GoodsClassifyCustomMapper goodsClassifyCustomMapper;
    @Resource
    private GoodsSkuDetailMapper goodsSkuDetailMapper;
    @Resource
    private GoodsSpecRelationPOMapper goodsSpecRelationPOMapper;
    @Resource
    private GoodsPOMapper goodsPOMapper;
    @Resource
    private GoodsSyncRecordMapper goodsSyncRecordMapper;
    @Resource
    private CompanyBrandRelationMapper companyBrandRelationMapper;
    @Resource
    private GoodsPropHeadMapper goodsPropHeadMapper;
    @Resource
    private GoodsSpecPOMapper goodsSpecPOMapper;
    @Resource
    private GoodsMapper goodsMapper;
    @Resource
    private GoodsTagCustomPOMapper goodsTagCustomPOMapper;
    @Resource
    private GoodsTagPOMapper goodsTagPOMapper;
    @Resource
    private GoodsPropValuePOMapper goodsPropValuePOMapper;
    @Resource
    private GoodsPropHeadPOMapper goodsPropHeadPOMapper;
    @Resource
    private GoodsPropValueCustomPOMapper goodsPropValueCustomPOMapper;
    @Resource
    private GoodsClassifyCustomPOMapper goodsClassifyCustomPOMapper;
    @Resource
    private GoodsClassifyPOMapper goodsClassifyPOMapper;
    @Resource
    private GoodsSkuDetailPOMapper goodsSkuDetailPOMapper;

    @Transactional(rollbackFor={Exception.class})
    public Boolean syncAddGoods(GoodsPO main, Integer merchantId, CompanyBrandRelation companyBrandRelation) throws Exception {
        String goodsNo = main.getGoodsNo();
        GoodsPO goodsChild = new GoodsPO();
        BeanUtils.copyProperties((Object)main, (Object)goodsChild);
        goodsChild.setMerchantId(merchantId);
        goodsChild.setSysBrandId(companyBrandRelation.getBrandId());
        Date date = new Date();
        Integer expressTemplateId = 0;
        goodsChild.setExpressTemplateId(expressTemplateId);
        goodsChild.setGmtCreate(date);
        goodsChild.setGmtModified(date);
        goodsChild.setSysBrandId(companyBrandRelation.getBrandId());
        goodsChild.setMainPid(main.getId());
        goodsChild.setMainMerchantId(main.getMerchantId());
        goodsChild.setIsShelved(Boolean.valueOf(false));
        this.goodsPOMapper.insertSelective(goodsChild);
        log.info("\u65b0\u589e\u5b50\u5546\u57ce\u5546\u54c1:{},\u5bf9\u8c61:{}", (Object)goodsNo, (Object)JSON.toJSONString((Object)goodsChild));
        this.syncAddGoodsProp(main, goodsChild);
        HashMap<Integer, GoodsClassifyPO> integerGoodsClassifyPOHashMap = this.syncAddGoodsClassify(main, goodsChild);
        this.syncModifyGoods(main, goodsChild, integerGoodsClassifyPOHashMap);
        this.syncAddGoodsTag(main, goodsChild);
        HashMap<Integer, GoodsSpecPO> stringGoodsSpecHashMap = this.syncAddGoodsSpec(main, goodsChild);
        this.syncAddGoodsSku(main, goodsChild, stringGoodsSpecHashMap);
        this.addGoodsClassRel(goodsChild, goodsChild.getCategoryFirstId());
        this.addGoodsClassRel(goodsChild, goodsChild.getCategorySecondId());
        return Boolean.TRUE;
    }

    private void addGoodsClassRel(GoodsPO goodsChild, Integer firstId) {
        if (firstId == null || firstId == 0) {
            return;
        }
        GoodsClassifyCustom goodsClassifyCustomFirst = new GoodsClassifyCustom();
        goodsClassifyCustomFirst.setGoodsId(goodsChild.getId());
        goodsClassifyCustomFirst.setClassifyId(firstId);
        goodsClassifyCustomFirst.setGmtCreate(new Date());
        this.goodsClassifyCustomMapper.insertSelective((Object)goodsClassifyCustomFirst);
    }

    public Boolean addOrModifyGoodsSyncRecord(GoodsPO main, Integer merchantId, CompanyBrandRelation companyBrandRelation, Boolean syncStatus, Date syncDate) {
        String goodsNo = main.getGoodsNo();
        GoodsSyncRecordExample goodsSyncRecordExample = new GoodsSyncRecordExample();
        goodsSyncRecordExample.createCriteria().andMerchantIdEqualTo(merchantId).andGoodsNoEqualTo(goodsNo).andValidEqualTo(Boolean.TRUE);
        List goodsSyncRecords = this.goodsSyncRecordMapper.selectByExample(goodsSyncRecordExample);
        Date modifyDate = new Date();
        GoodsSyncRecord goodsSyncRecord = null;
        if (CollectionUtils.isEmpty((Collection)goodsSyncRecords)) {
            log.info("\u65b0\u589e\u540c\u6b65\u8bb0\u5f55!");
            goodsSyncRecord = new GoodsSyncRecord();
            goodsSyncRecord.setMerchantId(merchantId);
            goodsSyncRecord.setSysBrandId(companyBrandRelation.getBrandId());
            goodsSyncRecord.setGoodsNo(goodsNo);
            goodsSyncRecord.setMainGoodsId(main.getId());
            goodsSyncRecord.setSyncStatus(syncStatus);
            goodsSyncRecord.setSyncDate(syncDate);
            goodsSyncRecord.setClientStatus(Boolean.TRUE);
            goodsSyncRecord.setGmtCreate(modifyDate);
            this.goodsSyncRecordMapper.insertSelective(goodsSyncRecord);
            log.info("\u65b0\u589e\u5b50\u5546\u57ce\u5546\u54c1\u540c\u6b65\u8bb0\u5f55:{}", (Object)JSON.toJSONString((Object)goodsSyncRecord));
            return Boolean.TRUE;
        }
        goodsSyncRecord = (GoodsSyncRecord)goodsSyncRecords.get(0);
        log.info("\u66f4\u65b0\u540c\u6b65\u8bb0\u5f55");
        GoodsSyncRecord goodsSyncRecordParam = new GoodsSyncRecord();
        goodsSyncRecordParam.setId(goodsSyncRecord.getId());
        goodsSyncRecordParam.setSyncStatus(syncStatus);
        goodsSyncRecordParam.setSyncDate(syncDate);
        goodsSyncRecordParam.setClientStatus(Boolean.TRUE);
        goodsSyncRecordParam.setGmtModified(modifyDate);
        goodsSyncRecordParam.setMainGoodsId(main.getId());
        this.goodsSyncRecordMapper.updateByPrimaryKeySelective(goodsSyncRecordParam);
        log.info("\u66f4\u65b0\u5b50\u5546\u57ce\u5546\u54c1\u540c\u6b65\u8bb0\u5f55:{}", (Object)JSON.toJSONString((Object)goodsSyncRecord));
        return Boolean.TRUE;
    }

    public Boolean modifyChildMerchantStatus(Goods goods) {
        Integer mainGoodsId = goods.getId();
        Integer merchantId = goods.getMerchantId();
        Example companyBrandRelationExample = new Example(CompanyBrandRelation.class);
        companyBrandRelationExample.createCriteria().andEqualTo("merchantId", (Object)merchantId);
        List companyBrandRelations = this.companyBrandRelationMapper.selectByExample((Object)companyBrandRelationExample);
        if (CollectionUtils.isEmpty((Collection)companyBrandRelations)) {
            return Boolean.FALSE;
        }
        CompanyBrandRelation companyBrandRelation = (CompanyBrandRelation)companyBrandRelations.get(0);
        Boolean isDefault = companyBrandRelation.getIsDefault();
        if (!isDefault.booleanValue()) {
            return Boolean.FALSE;
        }
        GoodsSyncRecord goodsSyncRecord = new GoodsSyncRecord();
        goodsSyncRecord.setGmtModified(new Date());
        goodsSyncRecord.setClientStatus(Boolean.FALSE);
        goodsSyncRecord.setSyncStatus(Boolean.FALSE);
        GoodsSyncRecordExample goodsSyncRecordExample = new GoodsSyncRecordExample();
        goodsSyncRecordExample.createCriteria().andMainGoodsIdEqualTo(mainGoodsId).andValidEqualTo(Boolean.TRUE);
        int count = this.goodsSyncRecordMapper.updateByExampleSelective(goodsSyncRecord, goodsSyncRecordExample);
        log.info("\u4e3b\u5546\u57ce\u66f4\u65b0\u5546\u54c1,\u66f4\u65b0\u5b50\u5546\u57ce\u540c\u6b65\u72b6\u6001\u6570\u91cf:{}", (Object)count);
        return Boolean.TRUE;
    }

    public GoodsSyncRecord queryGoodsSyncRecordByGoodsNo(Integer merchantId, String goodsNo) {
        GoodsSyncRecord goodsSyncRecordDefault = new GoodsSyncRecord();
        goodsSyncRecordDefault.setGoodsNo(goodsNo);
        goodsSyncRecordDefault.setSyncStatus(Boolean.FALSE);
        goodsSyncRecordDefault.setClientStatus(Boolean.FALSE);
        GoodsSyncRecordExample goodsSyncRecordExample = new GoodsSyncRecordExample();
        goodsSyncRecordExample.createCriteria().andGoodsNoEqualTo(goodsNo).andMerchantIdEqualTo(merchantId).andValidEqualTo(Boolean.TRUE);
        List goodsSyncRecords = this.goodsSyncRecordMapper.selectByExample(goodsSyncRecordExample);
        if (CollectionUtils.isEmpty((Collection)goodsSyncRecords)) {
            return goodsSyncRecordDefault;
        }
        return (GoodsSyncRecord)goodsSyncRecords.get(0);
    }

    private void syncModifyGoods(GoodsPO main, GoodsPO child, HashMap<Integer, GoodsClassifyPO> goodsClassifyPOHashMap) throws Exception {
        Integer categoryFirstId = main.getCategoryFirstId();
        if (categoryFirstId != 0) {
            Integer categorySecondId = main.getCategorySecondId();
            GoodsClassifyPO goodsClassifyPOFirst = goodsClassifyPOHashMap.get(categoryFirstId);
            GoodsClassifyPO goodsClassifyPOSecond = goodsClassifyPOHashMap.get(categorySecondId);
            GoodsPO goodsPOParam = new GoodsPO();
            goodsPOParam.setId(child.getId());
            goodsPOParam.setGmtModified(new Date());
            if (goodsClassifyPOFirst != null) {
                goodsPOParam.setCategoryFirstId(goodsClassifyPOFirst.getId());
            }
            if (goodsClassifyPOSecond != null) {
                goodsPOParam.setCategorySecondId(goodsClassifyPOSecond.getId());
            }
            this.goodsPOMapper.updateByPrimaryKeySelective(goodsPOParam);
            log.info("\u66f4\u65b0\u5b50\u5546\u57ce\u5546\u54c1\u4e00\u7ea7\u7c7b\u76ee,\u4e8c\u7ea7\u7c7b\u76ee\uff0c\u5546\u54c1:{}", (Object)JSON.toJSONString((Object)goodsPOParam));
        }
    }

    private void syncAddGoodsProp(GoodsPO main, GoodsPO child) throws Exception {
        Example goodsPropHeadExampleMain = new Example(GoodsPropHead.class);
        goodsPropHeadExampleMain.createCriteria().andEqualTo("merchantId", (Object)main.getMerchantId());
        List goodsPropHeadsMain = this.goodsPropHeadMapper.selectByExample((Object)goodsPropHeadExampleMain);
        HashMap<Integer, GoodsPropValuePO> integerGoodsPropValueHashMap = new HashMap<Integer, GoodsPropValuePO>();
        if (!CollectionUtils.isEmpty((Collection)goodsPropHeadsMain)) {
            for (int i = 0; i < goodsPropHeadsMain.size(); ++i) {
                GoodsPropHead goodsPropHead = (GoodsPropHead)goodsPropHeadsMain.get(i);
                Integer goodsPropHeadId = goodsPropHead.getId();
                String headName = goodsPropHead.getHeadName();
                GoodsPropHeadPOExample goodsPropHeadPOExample = new GoodsPropHeadPOExample();
                goodsPropHeadPOExample.createCriteria().andMerchantIdEqualTo(child.getMerchantId()).andHeadNameEqualTo(headName).andValidEqualTo(Boolean.TRUE);
                List goodsPropHeadsChild = this.goodsPropHeadPOMapper.selectByExample(goodsPropHeadPOExample);
                GoodsPropHeadPO goodsPropHeadChild = new GoodsPropHeadPO();
                if (CollectionUtils.isEmpty((Collection)goodsPropHeadsChild)) {
                    goodsPropHeadChild.setHeadName(headName);
                    goodsPropHeadChild.setSort(Integer.valueOf(i + 1));
                    goodsPropHeadChild.setGmtCreate(new Date());
                    goodsPropHeadChild.setMerchantId(child.getMerchantId());
                    goodsPropHeadChild.setMainPid(goodsPropHead.getId());
                    goodsPropHeadChild.setMainMerchantId(main.getMerchantId());
                    this.goodsPropHeadPOMapper.insertSelective(goodsPropHeadChild);
                } else {
                    goodsPropHeadChild = (GoodsPropHeadPO)goodsPropHeadsChild.get(0);
                }
                Integer goodsPropHeadMainPid = goodsPropHeadChild.getMainPid();
                if (goodsPropHeadMainPid == 0) {
                    GoodsPropHeadPO goodsPropHeadPOParam = new GoodsPropHeadPO();
                    goodsPropHeadPOParam.setId(goodsPropHeadChild.getId());
                    goodsPropHeadPOParam.setMainPid(goodsPropHead.getId());
                    goodsPropHeadPOParam.setMainMerchantId(main.getMerchantId());
                    goodsPropHeadPOParam.setGmtModified(new Date());
                    this.goodsPropHeadPOMapper.updateByPrimaryKeySelective(goodsPropHeadPOParam);
                }
                Integer goodsPropHeadChildId = goodsPropHeadChild.getId();
                GoodsPropValuePOExample goodsPropValuePOExample = new GoodsPropValuePOExample();
                goodsPropValuePOExample.createCriteria().andHeadIdEqualTo(goodsPropHeadId).andValidEqualTo(Boolean.TRUE);
                List goodsPropValuesMain = this.goodsPropValuePOMapper.selectByExample(goodsPropValuePOExample);
                if (CollectionUtils.isEmpty((Collection)goodsPropValuesMain)) continue;
                for (GoodsPropValuePO goodsPropValueMain : goodsPropValuesMain) {
                    String propValue = goodsPropValueMain.getPropValue();
                    Integer propValueId = goodsPropValueMain.getId();
                    GoodsPropValuePOExample goodsPropValuePOExampleChild = new GoodsPropValuePOExample();
                    goodsPropValuePOExampleChild.createCriteria().andHeadIdEqualTo(goodsPropHeadChildId).andValidEqualTo(Boolean.TRUE).andPropValueEqualTo(propValue);
                    List goodsPropValuesChild = this.goodsPropValuePOMapper.selectByExample(goodsPropValuePOExampleChild);
                    GoodsPropValuePO goodsPropValue = new GoodsPropValuePO();
                    if (CollectionUtils.isEmpty((Collection)goodsPropValuesChild)) {
                        goodsPropValue.setHeadId(goodsPropHeadChildId);
                        goodsPropValue.setMerchantId(child.getMerchantId());
                        goodsPropValue.setPropValue(propValue);
                        goodsPropValue.setGmtCreate(new Date());
                        goodsPropValue.setMainPid(goodsPropValueMain.getId());
                        goodsPropValue.setMainMerchantId(main.getMerchantId());
                        this.goodsPropValuePOMapper.insertSelective(goodsPropValue);
                    } else {
                        goodsPropValue = (GoodsPropValuePO)goodsPropValuesChild.get(0);
                    }
                    Integer goodsPropValueMainPid = goodsPropHeadChild.getMainPid();
                    if (goodsPropValueMainPid == null || goodsPropValueMainPid == 0) {
                        GoodsPropValuePO goodsPropValuePOParam = new GoodsPropValuePO();
                        goodsPropValuePOParam.setId(goodsPropHeadChild.getId());
                        goodsPropValuePOParam.setMainPid(goodsPropHead.getId());
                        goodsPropValuePOParam.setMainMerchantId(main.getMerchantId());
                        goodsPropValuePOParam.setGmtModified(new Date());
                        this.goodsPropValuePOMapper.updateByPrimaryKeySelective(goodsPropValuePOParam);
                    }
                    integerGoodsPropValueHashMap.put(propValueId, goodsPropValue);
                }
            }
        }
        log.info("\u521d\u59cb\u5316\u4e3b\u5546\u57ce\u5546\u6237\u5c5e\u6027map:{}", (Object)JSON.toJSONString(integerGoodsPropValueHashMap));
        GoodsPropValueCustomPOExample goodsPropValueCustomPOExample = new GoodsPropValueCustomPOExample();
        goodsPropValueCustomPOExample.createCriteria().andGoodsIdEqualTo(main.getId());
        List goodsPropValueCustoms = this.goodsPropValueCustomPOMapper.selectByExample(goodsPropValueCustomPOExample);
        if (!CollectionUtils.isEmpty((Collection)goodsPropValueCustoms)) {
            for (GoodsPropValueCustomPO goodsPropValueCustom : goodsPropValueCustoms) {
                Integer propId = goodsPropValueCustom.getPropId();
                GoodsPropValuePO goodsPropValueChild = (GoodsPropValuePO)integerGoodsPropValueHashMap.get(propId);
                if (goodsPropValueChild == null) {
                    log.error("\u67e5\u8be2\u5b50\u5546\u57ce:{} ->propId :{} error", (Object)child.getMerchantId(), (Object)propId);
                    continue;
                }
                GoodsPropValueCustomPOExample goodsPropValueCustomExampleChild = new GoodsPropValueCustomPOExample();
                goodsPropValueCustomExampleChild.createCriteria().andGoodsIdEqualTo(child.getId()).andPropIdEqualTo(goodsPropValueChild.getId());
                List goodsPropValueCustomsChild = this.goodsPropValueCustomPOMapper.selectByExample(goodsPropValueCustomExampleChild);
                if (!CollectionUtils.isEmpty((Collection)goodsPropValueCustomsChild)) continue;
                GoodsPropValueCustomPO goodsPropValueCustomChild = new GoodsPropValueCustomPO();
                goodsPropValueCustomChild.setGoodsId(child.getId());
                goodsPropValueCustomChild.setPropId(goodsPropValueChild.getId());
                goodsPropValueCustomChild.setGmtCreate(new Date());
                goodsPropValueCustomChild.setHeadId(goodsPropValueChild.getHeadId());
                goodsPropValueCustomChild.setMerchantId(child.getMerchantId());
                this.goodsPropValueCustomPOMapper.insertSelective(goodsPropValueCustomChild);
            }
        }
    }

    private HashMap<Integer, GoodsSpecPO> syncAddGoodsSpec(GoodsPO main, GoodsPO child) throws Exception {
        Integer specId;
        Integer mainGoodsId = main.getId();
        Integer merchantIdChild = child.getMerchantId();
        GoodsSpecRelationPOExample goodsSpecRelationPOExampleMain = new GoodsSpecRelationPOExample();
        goodsSpecRelationPOExampleMain.createCriteria().andGoodsIdEqualTo(mainGoodsId);
        List goodsSpecRelationListMain = this.goodsSpecRelationPOMapper.selectByExample(goodsSpecRelationPOExampleMain);
        Date date = new Date();
        HashMap<Integer, GoodsSpecPO> integerGoodsSpecHashMap = new HashMap<Integer, GoodsSpecPO>();
        for (GoodsSpecRelationPO goodsSpecRelation : goodsSpecRelationListMain) {
            List goodsSpecPOSChild;
            GoodsSpecPOExample goodsSpecPOExampleChild;
            specId = goodsSpecRelation.getSpecId();
            GoodsSpecPO goodsSpecPOMain = this.goodsSpecPOMapper.selectByPrimaryKey(specId);
            Integer pidMain = goodsSpecPOMain.getPid();
            GoodsSpecPO goodsSpecPOP = new GoodsSpecPO();
            if (pidMain != 0) {
                GoodsSpecPO goodsSpecPOMainP = this.goodsSpecPOMapper.selectByPrimaryKey(pidMain);
                goodsSpecPOExampleChild = new GoodsSpecPOExample();
                goodsSpecPOExampleChild.createCriteria().andSpecNameEqualTo(goodsSpecPOMainP.getSpecName()).andMerchantIdEqualTo(merchantIdChild).andValidEqualTo(Boolean.TRUE);
                goodsSpecPOSChild = this.goodsSpecPOMapper.selectByExample(goodsSpecPOExampleChild);
                if (CollectionUtils.isEmpty((Collection)goodsSpecPOSChild)) {
                    BeanUtils.copyProperties((Object)goodsSpecPOMainP, (Object)goodsSpecPOP);
                    goodsSpecPOP.setId(null);
                    goodsSpecPOP.setMerchantId(merchantIdChild);
                    goodsSpecPOP.setGmtCreate(date);
                    goodsSpecPOP.setGmtModified(date);
                    goodsSpecPOP.setMainPid(goodsSpecPOMainP.getId());
                    goodsSpecPOP.setMainMerchantId(main.getMerchantId());
                    this.goodsSpecPOMapper.insertSelective(goodsSpecPOP);
                } else {
                    goodsSpecPOP = (GoodsSpecPO)goodsSpecPOSChild.get(0);
                }
                Integer goodsSpecPOPMainPid = goodsSpecPOP.getMainPid();
                if (goodsSpecPOPMainPid == 0) {
                    GoodsSpecPO goodsSpecPOPParam = new GoodsSpecPO();
                    goodsSpecPOPParam.setId(goodsSpecPOP.getId());
                    goodsSpecPOPParam.setMainPid(goodsSpecPOMainP.getId());
                    goodsSpecPOPParam.setMainMerchantId(main.getMerchantId());
                    goodsSpecPOPParam.setGmtModified(new Date());
                    this.goodsSpecPOMapper.updateByPrimaryKeySelective(goodsSpecPOPParam);
                }
                integerGoodsSpecHashMap.put(goodsSpecPOMainP.getId(), goodsSpecPOP);
            }
            GoodsSpecPO goodsSpecPO = new GoodsSpecPO();
            goodsSpecPOExampleChild = new GoodsSpecPOExample();
            goodsSpecPOExampleChild.createCriteria().andSpecNameEqualTo(goodsSpecPOMain.getSpecName()).andMerchantIdEqualTo(merchantIdChild).andValidEqualTo(Boolean.TRUE);
            goodsSpecPOSChild = this.goodsSpecPOMapper.selectByExample(goodsSpecPOExampleChild);
            if (CollectionUtils.isEmpty((Collection)goodsSpecPOSChild)) {
                BeanUtils.copyProperties((Object)goodsSpecPOMain, (Object)goodsSpecPO);
                goodsSpecPO.setId(null);
                goodsSpecPO.setMerchantId(merchantIdChild);
                goodsSpecPO.setGmtCreate(date);
                goodsSpecPO.setGmtModified(date);
                goodsSpecPO.setPid(goodsSpecPOP.getId());
                goodsSpecPO.setMainPid(goodsSpecPOMain.getId());
                goodsSpecPO.setMainMerchantId(main.getMerchantId());
                this.goodsSpecPOMapper.insertSelective(goodsSpecPO);
            } else {
                goodsSpecPO = (GoodsSpecPO)goodsSpecPOSChild.get(0);
            }
            Integer goodsSpecPOMainPid = goodsSpecPO.getMainPid();
            if (goodsSpecPOMainPid == null || goodsSpecPOMainPid == 0) {
                GoodsSpecPO goodsSpecPOParam = new GoodsSpecPO();
                goodsSpecPOParam.setId(goodsSpecPO.getId());
                goodsSpecPOParam.setMainPid(goodsSpecPOMain.getId());
                goodsSpecPOParam.setMainMerchantId(main.getMerchantId());
                goodsSpecPOParam.setGmtModified(date);
                this.goodsSpecPOMapper.updateByPrimaryKeySelective(goodsSpecPOParam);
            }
            integerGoodsSpecHashMap.put(goodsSpecPOMain.getId(), goodsSpecPO);
        }
        log.info("\u521d\u59cb\u5316\u4e3b\u5546\u57ce\u5546\u6237\u89c4\u683cmap:{}", (Object)JSON.toJSONString(integerGoodsSpecHashMap));
        for (GoodsSpecRelationPO goodsSpecRelationPO : goodsSpecRelationListMain) {
            specId = goodsSpecRelationPO.getSpecId();
            GoodsSpecPO goodsSpecPOChild = integerGoodsSpecHashMap.get(specId);
            Integer goodsSpecChildId = goodsSpecPOChild.getId();
            GoodsSpecRelationPOExample goodsSpecRelationPOExampleChild = new GoodsSpecRelationPOExample();
            goodsSpecRelationPOExampleChild.createCriteria().andSpecIdEqualTo(goodsSpecChildId).andGoodsIdEqualTo(child.getId()).andValidEqualTo(Boolean.TRUE);
            List goodsSpecRelationPOSChild = this.goodsSpecRelationPOMapper.selectByExample(goodsSpecRelationPOExampleChild);
            if (!CollectionUtils.isEmpty((Collection)goodsSpecRelationPOSChild)) continue;
            GoodsSpecRelationPO goodsSpecRelationPOChild = new GoodsSpecRelationPO();
            goodsSpecRelationPOChild.setMerchantId(merchantIdChild);
            goodsSpecRelationPOChild.setGoodsId(child.getId());
            goodsSpecRelationPOChild.setSpecId(goodsSpecChildId);
            goodsSpecRelationPOChild.setValid(Boolean.TRUE);
            this.goodsSpecRelationPOMapper.insertSelective(goodsSpecRelationPOChild);
            log.info("\u65b0\u589e\u5b50\u5546\u57ce\u5546\u54c1\u89c4\u683c\u5173\u8054\u5173\u7cfb\u8868:{}", (Object)JSON.toJSONString((Object)goodsSpecRelationPOChild));
        }
        return integerGoodsSpecHashMap;
    }

    private void syncAddGoodsTag(GoodsPO main, GoodsPO child) throws Exception {
        Integer mainGoodsId = main.getId();
        Integer merchantIdChild = child.getMerchantId();
        GoodsTagCustomPOExample goodsTagCustomPOExampleMain = new GoodsTagCustomPOExample();
        goodsTagCustomPOExampleMain.createCriteria().andGoodsIdEqualTo(mainGoodsId);
        List goodsTagCustoms = this.goodsTagCustomPOMapper.selectByExample(goodsTagCustomPOExampleMain);
        if (!CollectionUtils.isEmpty((Collection)goodsTagCustoms)) {
            Integer tagIdMain;
            HashMap<Integer, GoodsTagPO> integerGoodsTagPOHashMap = new HashMap<Integer, GoodsTagPO>();
            for (GoodsTagCustomPO goodsTagCustom : goodsTagCustoms) {
                tagIdMain = goodsTagCustom.getTagId();
                GoodsTagPO goodsTagPO = this.goodsTagPOMapper.selectByPrimaryKey(tagIdMain);
                GoodsTagPOExample goodsTagPOExampleChild = new GoodsTagPOExample();
                goodsTagPOExampleChild.createCriteria().andMerchantIdEqualTo(merchantIdChild).andValidEqualTo(Boolean.TRUE).andNameEqualTo(goodsTagPO.getName());
                List goodsTagPOSChild = this.goodsTagPOMapper.selectByExample(goodsTagPOExampleChild);
                GoodsTagPO goodsTagPOChild = new GoodsTagPO();
                if (CollectionUtils.isEmpty((Collection)goodsTagPOSChild)) {
                    goodsTagPOChild.setMerchantId(merchantIdChild);
                    goodsTagPOChild.setGmtCreate(new Date());
                    goodsTagPOChild.setName(goodsTagPO.getName());
                    goodsTagPOChild.setSort(goodsTagPO.getSort());
                    goodsTagPOChild.setValid(Boolean.TRUE);
                    goodsTagPOChild.setMainPid(goodsTagPO.getId());
                    goodsTagPOChild.setMainMerchantId(main.getMerchantId());
                    this.goodsTagPOMapper.insertSelective(goodsTagPOChild);
                } else {
                    goodsTagPOChild = (GoodsTagPO)goodsTagPOSChild.get(0);
                }
                Integer goodsTagPOChildMainPid = goodsTagPOChild.getMainPid();
                if (goodsTagPOChildMainPid == 0) {
                    GoodsTagPO goodsTagPOParam = new GoodsTagPO();
                    goodsTagPOParam.setId(goodsTagPOChild.getId());
                    goodsTagPOParam.setMainPid(goodsTagPO.getId());
                    goodsTagPOParam.setMainMerchantId(main.getMerchantId());
                    goodsTagPOParam.setGmtModified(new Date());
                    this.goodsTagPOMapper.updateByPrimaryKeySelective(goodsTagPOParam);
                }
                integerGoodsTagPOHashMap.put(tagIdMain, goodsTagPOChild);
            }
            for (GoodsTagCustomPO goodsTagCustom : goodsTagCustoms) {
                tagIdMain = goodsTagCustom.getTagId();
                GoodsTagPO goodsTagPOChild = (GoodsTagPO)integerGoodsTagPOHashMap.get(tagIdMain);
                GoodsTagCustomPOExample goodsTagCustomPOExampleChild = new GoodsTagCustomPOExample();
                goodsTagCustomPOExampleChild.createCriteria().andGoodsIdEqualTo(child.getId()).andTagIdEqualTo(goodsTagPOChild.getId()).andValidEqualTo(Boolean.TRUE);
                List goodsTagCustomPOS = this.goodsTagCustomPOMapper.selectByExample(goodsTagCustomPOExampleChild);
                if (!CollectionUtils.isEmpty((Collection)goodsTagCustomPOS)) continue;
                GoodsTagCustomPO goodsTagCustomPO = new GoodsTagCustomPO();
                goodsTagCustomPO.setGoodsId(child.getId());
                goodsTagCustomPO.setTagId(goodsTagPOChild.getId());
                goodsTagCustomPO.setGmtCreate(new Date());
                goodsTagCustomPO.setMerchantId(merchantIdChild);
                goodsTagCustomPO.setValid(Boolean.TRUE);
                this.goodsTagCustomPOMapper.insertSelective(goodsTagCustomPO);
                log.info("\u5b50\u5546\u57ce\u65b0\u589e\u5546\u54c1tag:{}", (Object)JSON.toJSONString((Object)goodsTagCustomPO));
            }
        }
    }

    private HashMap<Integer, GoodsClassifyPO> syncAddGoodsClassify(GoodsPO main, GoodsPO child) throws Exception {
        Integer mainGoodsId = main.getId();
        Integer merchantIdChild = child.getMerchantId();
        GoodsClassifyCustomPOExample goodsClassifyCustomPOExampleMain = new GoodsClassifyCustomPOExample();
        goodsClassifyCustomPOExampleMain.createCriteria().andGoodsIdEqualTo(mainGoodsId).andValidEqualTo(Boolean.TRUE);
        List goodsClassifyCustomPOSMain = this.goodsClassifyCustomPOMapper.selectByExample(goodsClassifyCustomPOExampleMain);
        HashMap<Integer, GoodsClassifyPO> integerGoodsClassifyPOHashMap = new HashMap<Integer, GoodsClassifyPO>();
        if (!CollectionUtils.isEmpty((Collection)goodsClassifyCustomPOSMain)) {
            for (GoodsClassifyCustomPO goodsClassifyCustomPO : goodsClassifyCustomPOSMain) {
                Date date;
                List goodsClassifyPOSChild;
                GoodsClassifyPOExample goodsClassifyPOExampleChild;
                Integer classifyId = goodsClassifyCustomPO.getClassifyId();
                GoodsClassifyPO goodsClassifyPOMain = this.goodsClassifyPOMapper.selectByPrimaryKey(classifyId);
                Integer pidMain = goodsClassifyPOMain.getPid();
                GoodsClassifyPO goodsClassifyPOP = new GoodsClassifyPO();
                if (pidMain != 0) {
                    GoodsClassifyPO goodsClassifyPOMainP = this.goodsClassifyPOMapper.selectByPrimaryKey(pidMain);
                    goodsClassifyPOExampleChild = new GoodsClassifyPOExample();
                    goodsClassifyPOExampleChild.createCriteria().andNameEqualTo(goodsClassifyPOMainP.getName()).andMerchantIdEqualTo(merchantIdChild).andValidEqualTo(Boolean.TRUE);
                    goodsClassifyPOSChild = this.goodsClassifyPOMapper.selectByExample(goodsClassifyPOExampleChild);
                    if (CollectionUtils.isEmpty((Collection)goodsClassifyPOSChild)) {
                        BeanUtils.copyProperties((Object)goodsClassifyPOMainP, (Object)goodsClassifyPOP);
                        date = new Date();
                        goodsClassifyPOP.setId(null);
                        goodsClassifyPOP.setMerchantId(merchantIdChild);
                        goodsClassifyPOP.setGmtCreate(date);
                        goodsClassifyPOP.setGmtModified(date);
                        goodsClassifyPOP.setMainPid(goodsClassifyPOMainP.getId());
                        goodsClassifyPOP.setMainMerchantId(main.getMerchantId());
                        this.goodsClassifyPOMapper.insertSelective(goodsClassifyPOP);
                    } else {
                        goodsClassifyPOP = (GoodsClassifyPO)goodsClassifyPOSChild.get(0);
                    }
                    Integer goodsClassifyPOPMainPid = goodsClassifyPOP.getMainPid();
                    if (goodsClassifyPOPMainPid == 0) {
                        GoodsClassifyPO goodsClassifyPOPParam = new GoodsClassifyPO();
                        goodsClassifyPOPParam.setId(goodsClassifyPOP.getId());
                        goodsClassifyPOPParam.setMainPid(goodsClassifyPOMainP.getId());
                        goodsClassifyPOPParam.setMainMerchantId(main.getMerchantId());
                        goodsClassifyPOPParam.setGmtModified(new Date());
                        this.goodsClassifyPOMapper.updateByPrimaryKeySelective(goodsClassifyPOPParam);
                    }
                    integerGoodsClassifyPOHashMap.put(goodsClassifyPOMainP.getId(), goodsClassifyPOP);
                }
                GoodsClassifyPO goodsClassifyPO = new GoodsClassifyPO();
                goodsClassifyPOExampleChild = new GoodsClassifyPOExample();
                goodsClassifyPOExampleChild.createCriteria().andNameEqualTo(goodsClassifyPOMain.getName()).andMerchantIdEqualTo(merchantIdChild).andValidEqualTo(Boolean.TRUE);
                goodsClassifyPOSChild = this.goodsClassifyPOMapper.selectByExample(goodsClassifyPOExampleChild);
                if (CollectionUtils.isEmpty((Collection)goodsClassifyPOSChild)) {
                    BeanUtils.copyProperties((Object)goodsClassifyPOMain, (Object)goodsClassifyPO);
                    date = new Date();
                    goodsClassifyPO.setId(null);
                    goodsClassifyPO.setMerchantId(merchantIdChild);
                    goodsClassifyPO.setGmtCreate(date);
                    goodsClassifyPO.setGmtModified(date);
                    goodsClassifyPO.setPid(goodsClassifyPOP.getId());
                    goodsClassifyPO.setMainPid(goodsClassifyPOMain.getId());
                    goodsClassifyPO.setMainMerchantId(main.getMerchantId());
                    this.goodsClassifyPOMapper.insertSelective(goodsClassifyPO);
                } else {
                    goodsClassifyPO = (GoodsClassifyPO)goodsClassifyPOSChild.get(0);
                }
                Integer goodsClassifyPOMainPid = goodsClassifyPOP.getMainPid();
                if (goodsClassifyPOMainPid == null || goodsClassifyPOMainPid == 0) {
                    GoodsClassifyPO goodsClassifyPOParam = new GoodsClassifyPO();
                    goodsClassifyPOParam.setId(goodsClassifyPO.getId());
                    goodsClassifyPOParam.setMainPid(goodsClassifyPOMain.getId());
                    goodsClassifyPOParam.setMainMerchantId(main.getMerchantId());
                    goodsClassifyPOParam.setGmtModified(new Date());
                    this.goodsClassifyPOMapper.updateByPrimaryKeySelective(goodsClassifyPOParam);
                }
                integerGoodsClassifyPOHashMap.put(goodsClassifyPOMain.getId(), goodsClassifyPO);
            }
            log.info("\u521d\u59cb\u5316\u4e3b\u5546\u57ce\u5546\u6237\u5206\u7c7bmap:{}", (Object)JSON.toJSONString(integerGoodsClassifyPOHashMap));
            for (GoodsClassifyCustomPO goodsClassifyCustomPO : goodsClassifyCustomPOSMain) {
                Integer classifyIdMain = goodsClassifyCustomPO.getClassifyId();
                GoodsClassifyPO goodsClassifyPOChild = integerGoodsClassifyPOHashMap.get(classifyIdMain);
                Integer classifyIdChild = goodsClassifyPOChild.getId();
                GoodsClassifyCustomPOExample goodsClassifyCustomPOExampleChild = new GoodsClassifyCustomPOExample();
                goodsClassifyCustomPOExampleChild.createCriteria().andClassifyIdEqualTo(classifyIdChild).andGoodsIdEqualTo(child.getId()).andValidEqualTo(Boolean.TRUE);
                List goodsClassifyCustomPOSChild = this.goodsClassifyCustomPOMapper.selectByExample(goodsClassifyCustomPOExampleChild);
                if (!CollectionUtils.isEmpty((Collection)goodsClassifyCustomPOSChild)) continue;
                GoodsClassifyCustomPO goodsClassifyCustomPOChild = new GoodsClassifyCustomPO();
                goodsClassifyCustomPOChild.setMerchantId(merchantIdChild);
                goodsClassifyCustomPOChild.setGoodsId(child.getId());
                goodsClassifyCustomPOChild.setClassifyId(classifyIdChild);
                goodsClassifyCustomPOChild.setGmtCreate(new Date());
                goodsClassifyCustomPOChild.setValid(Boolean.TRUE);
                this.goodsClassifyCustomPOMapper.insertSelective(goodsClassifyCustomPOChild);
                log.info("\u65b0\u589e\u5b50\u5546\u57ce\u5546\u54c1\u5206\u7c7b\u7ba1\u7406\u5173\u7cfb\u8868:{}", (Object)JSON.toJSONString((Object)goodsClassifyCustomPOChild));
            }
        }
        return integerGoodsClassifyPOHashMap;
    }

    private void syncAddGoodsSku(GoodsPO main, GoodsPO child, HashMap<Integer, GoodsSpecPO> goodsSpecHashMap) throws Exception {
        Integer mainGoodsId = main.getId();
        Integer merchantIdChild = child.getMerchantId();
        Integer sysBrandId = main.getSysBrandId();
        GoodsSkuDetailPOExample goodsSkuDetailPOExampleMain = new GoodsSkuDetailPOExample();
        goodsSkuDetailPOExampleMain.createCriteria().andGoodsIdEqualTo(mainGoodsId).andValidEqualTo(Boolean.TRUE);
        List goodsSkuDetailListMain = this.goodsSkuDetailPOMapper.selectByExample(goodsSkuDetailPOExampleMain);
        if (CollectionUtils.isEmpty((Collection)goodsSkuDetailListMain)) {
            log.info("\u5546\u54c1:{}\u4e0d\u5b58\u5728sku,\u76f4\u63a5return", (Object)main.getGoodsNo());
            return;
        }
        for (GoodsSkuDetailPO goodsSkuDetailMain : goodsSkuDetailListMain) {
            String skuNo = goodsSkuDetailMain.getSkuNo();
            GoodsSkuDetailPOExample goodsSkuDetailPOExampleChild = new GoodsSkuDetailPOExample();
            goodsSkuDetailPOExampleChild.createCriteria().andMerchantIdEqualTo(merchantIdChild).andSkuNoEqualTo(skuNo).andValidEqualTo(Boolean.FALSE).andIsDelEqualTo(Boolean.FALSE);
            List goodsSkuDetailPOS = this.goodsSkuDetailPOMapper.selectByExample(goodsSkuDetailPOExampleChild);
            if (CollectionUtils.isEmpty((Collection)goodsSkuDetailPOS)) {
                GoodsSkuDetailPO goodsSkuDetailPOChild = new GoodsSkuDetailPO();
                BeanUtils.copyProperties((Object)goodsSkuDetailMain, (Object)goodsSkuDetailPOChild);
                goodsSkuDetailPOChild.setId(null);
                String specIds = goodsSkuDetailMain.getSpecIds();
                if (!StringUtils.isEmpty((Object)specIds)) {
                    String[] splitMain = specIds.split(",");
                    StringBuilder specIdChild = new StringBuilder();
                    StringBuilder specNameChild = new StringBuilder();
                    for (int i = 0; i < splitMain.length; ++i) {
                        Integer specIdMain = Integer.valueOf(splitMain[i]);
                        GoodsSpecPO goodsSpec = goodsSpecHashMap.get(specIdMain);
                        specIdChild.append(goodsSpec.getId()).append(",");
                        specNameChild.append(goodsSpec.getSpecName()).append(",");
                    }
                    String specId = specIdChild.substring(0, specIdChild.length() - 1);
                    String specName = specNameChild.substring(0, specNameChild.length() - 1);
                    goodsSkuDetailPOChild.setSpecIds(specId);
                    goodsSkuDetailPOChild.setSpecNames(specName);
                }
                Date date = new Date();
                goodsSkuDetailPOChild.setGoodsId(child.getId());
                goodsSkuDetailPOChild.setGmtCreate(date);
                goodsSkuDetailPOChild.setGmtModified(date);
                goodsSkuDetailPOChild.setMerchantId(merchantIdChild);
                goodsSkuDetailPOChild.setValid(Boolean.TRUE);
                goodsSkuDetailPOChild.setSysBrandId(sysBrandId);
                goodsSkuDetailPOChild.setMainPid(goodsSkuDetailMain.getId());
                goodsSkuDetailPOChild.setMainMerchantId(main.getMerchantId());
                this.goodsSkuDetailPOMapper.insertSelective(goodsSkuDetailPOChild);
                log.info("\u65b0\u589e\u5546\u54c1:{}sku:{}", (Object)child.getGoodsNo(), (Object)JSON.toJSONString((Object)goodsSkuDetailPOChild));
                continue;
            }
            GoodsSkuDetailPO goodsSkuDetailPO = (GoodsSkuDetailPO)goodsSkuDetailPOS.get(0);
            Integer goodsId = goodsSkuDetailPO.getGoodsId();
            log.error("\u5546\u54c1skuNo:{}\u5df2\u5b58\u5728,\u5f52\u5c5e\u5546\u54c1id:{}\u4e0b", (Object)skuNo, (Object)goodsId);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean syncModifyGoods(GoodsPO main, Integer merchantId, CompanyBrandRelation companyBrandRelation) throws Exception {
        String goodsNo = main.getGoodsNo();
        Example goodsExampleChild = new Example(Goods.class);
        goodsExampleChild.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("goodsNo", (Object)goodsNo).andEqualTo("isDel", (Object)Boolean.FALSE);
        List goodsChildList = this.goodsMapper.selectByExample((Object)goodsExampleChild);
        if (CollectionUtils.isEmpty((Collection)goodsChildList)) {
            log.info("\u5f53\u524d\u5546\u57ce\u5546\u54c1:{}\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664", (Object)goodsNo);
            throw new Exception("\u5f53\u524d\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        Goods goodsChild = (Goods)goodsChildList.get(0);
        Goods goodsChildParam = new Goods();
        goodsChildParam.setId(goodsChild.getId());
        goodsChildParam.setGmtModified(new Date());
        goodsChildParam.setCoverImg(main.getCoverImg());
        goodsChildParam.setBannerImgPaths(main.getBannerImgPaths());
        goodsChildParam.setVideoPaths(main.getVideoPaths());
        goodsChildParam.setVideoImg(main.getVideoImg());
        this.goodsMapper.updateByPrimaryKeySelective((Object)goodsChildParam);
        log.info("\u66f4\u65b0\u5546\u54c1:{}", (Object)JSON.toJSONString((Object)goodsChildParam));
        List goodsSkuDetailListMain = this.goodsSkuDetailMapper.selectByGoodsId(main.getId());
        if (CollectionUtils.isEmpty((Collection)goodsSkuDetailListMain)) {
            log.info("\u5f53\u524d\u5546\u54c1\u4e0d\u5b58\u5728sku,\u76f4\u63a5return");
            return Boolean.TRUE;
        }
        for (GoodsSkuDetail goodsSkuDetail : goodsSkuDetailListMain) {
            String skuNo = goodsSkuDetail.getSkuNo();
            Example goodsSkuDetailExample = new Example(GoodsSkuDetail.class);
            goodsSkuDetailExample.createCriteria().andEqualTo("merchantId", (Object)merchantId).andEqualTo("skuNo", (Object)skuNo).andEqualTo("isDel", (Object)Boolean.FALSE);
            List goodsSkuDetailListChild = this.goodsSkuDetailMapper.selectByExample((Object)goodsSkuDetailExample);
            if (CollectionUtils.isEmpty((Collection)goodsSkuDetailListChild)) {
                log.info("\u5b50\u5546\u57cesku:{}\u4e0d\u5b58\u5728,\u4e0d\u505a\u540c\u6b65\u64cd\u4f5c,\u9ed8\u8ba4\u6210\u529f", (Object)skuNo);
                continue;
            }
            GoodsSkuDetail goodsSkuDetailChild = (GoodsSkuDetail)goodsSkuDetailListChild.get(0);
            Integer goodsId = goodsSkuDetailChild.getGoodsId();
            if (!goodsId.equals(goodsChild.getId())) {
                log.info("\u5f53\u524dsku:{}\u4e0d\u5c5e\u4e8e\u5546\u54c1:{},\u4e0d\u505a\u540c\u6b65\u64cd\u4f5c,\u8fd4\u56de\u5931\u8d25", (Object)skuNo, (Object)goodsNo);
                throw new Exception("\u5f53\u524dsku\u4e0d\u5c5e\u4e8e\u8be5\u5546\u54c1,\u4e0d\u505a\u540c\u6b65\u64cd\u4f5c!");
            }
            GoodsSkuDetail goodsSkuDetailChildParam = new GoodsSkuDetail();
            goodsSkuDetailChildParam.setId(goodsSkuDetailChild.getId());
            goodsSkuDetailChildParam.setGmtModified(new Date());
            goodsSkuDetailChildParam.setSkuImg(goodsSkuDetailChild.getSkuImg());
            this.goodsSkuDetailMapper.updateByPrimaryKeySelective((Object)goodsSkuDetailChildParam);
            log.info("\u66f4\u65b0\u5546\u54c1sku:{}", (Object)JSON.toJSONString((Object)goodsSkuDetailChildParam));
        }
        return Boolean.TRUE;
    }
}

