/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.newseckill.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.wmeimob.fastboot.bizvane.bo.IntegralGoodsSearchBO;
import com.wmeimob.fastboot.bizvane.entity.GoodsSkuDetail;
import com.wmeimob.fastboot.bizvane.entity.IntegralGoods;
import com.wmeimob.fastboot.bizvane.entity.LoginUser;
import com.wmeimob.fastboot.bizvane.enums.integral.IntegralGoodsSearchFormTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.newseckill.SeckillActivityStatus;
import com.wmeimob.fastboot.bizvane.mapper.IntegralGoodsSkuMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivityConfigMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivitySkuMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivityUpdateRecordMapper;
import com.wmeimob.fastboot.bizvane.po.SeckillActivityConfigPO;
import com.wmeimob.fastboot.bizvane.po.SeckillActivityGoodsPO;
import com.wmeimob.fastboot.bizvane.po.SeckillActivitySkuPO;
import com.wmeimob.fastboot.bizvane.po.SeckillActivityUpdateRecordPO;
import com.wmeimob.fastboot.bizvane.service.IntegralGoodsService;
import com.wmeimob.fastboot.bizvane.service.newseckill.SeckillActivityService;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.ActivityRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.CheckIfDeductRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SecKillActivityConfigReplaceRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityDetailResponseVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityDisableRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityGoodsDTO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityGoodsRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityGoodsSkuDTO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivitySearchRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivitySearchResponseVO;
import com.wmeimob.fastboot.bizvane.utils.BeanListUtil;
import com.wmeimob.fastboot.bizvane.utils.DateUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.config.MallAdminException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SeckillActivityServiceImpl
implements SeckillActivityService {
    @Autowired
    private SeckillActivityConfigMapper seckillActivityConfigMapper;
    @Autowired
    private IntegralGoodsService integralGoodsService;
    @Autowired
    private SeckillActivityGoodsMapper seckillActivityGoodsMapper;
    @Autowired
    private SeckillActivitySkuMapper seckillActivitySkuMapper;
    @Autowired
    private IntegralGoodsSkuMapper integralGoodsSkuMapper;
    @Autowired
    private SeckillActivityUpdateRecordMapper seckillActivityUpdateRecordMapper;

    @Override
    public PageInfo<SeckillActivitySearchResponseVO> querySecKillActivityConfigList(SeckillActivitySearchRequestVO requestVO) {
        SeckillActivityConfigPO configPO = new SeckillActivityConfigPO();
        BeanUtils.copyProperties((Object)requestVO, (Object)configPO);
        PageHelper.startPage((int)requestVO.getPageNum(), (int)requestVO.getPageSize());
        List queryResult = this.seckillActivityConfigMapper.querySecKillActivityConfigList(configPO);
        List data = queryResult.stream().map(po -> {
            SeckillActivitySearchResponseVO vo = new SeckillActivitySearchResponseVO();
            BeanUtils.copyProperties((Object)po, (Object)vo);
            String status = SeckillActivityStatus.correctStatus((Integer)po.getActivityType(), (String)po.getActivityRule(), (Long)po.getSeckillStartTime(), (Long)po.getSeckillEndTime(), (Integer)po.getDisabled()).getMessage();
            vo.setActivityStatusDecr(status);
            vo.setGmtCreateDesc(DateUtil.format((Date)po.getGmtCreate(), (String)DateUtil.ymdhms));
            vo.setSeckillTimeDesc(this.parseTime(po.getSeckillStartTime(), po.getSeckillEndTime()));
            return vo;
        }).collect(Collectors.toList());
        PageInfo result = new PageInfo(data);
        return result;
    }

    @Override
    public List<Integer> checkOverlapGoods(List<Integer> goodsIds) {
        if (CollectionUtils.isEmpty(goodsIds)) {
            return new ArrayList<Integer>();
        }
        ActivityRequestVO activity = new ActivityRequestVO();
        activity.setStatuses((List)Lists.newArrayList((Object[])new Integer[]{SeckillActivityStatus.HAVE_NOT_START.getCode(), SeckillActivityStatus.ON_GOING.getCode()}));
        List<SeckillActivitySearchResponseVO> response = this.queryActivities(activity, true, false);
        List activeGoodsIds = response.stream().map(SeckillActivitySearchResponseVO::getGoodsDTOS).flatMap(Collection::stream).map(SeckillActivityGoodsDTO::getGoodsId).collect(Collectors.toList());
        goodsIds.retainAll(activeGoodsIds);
        return goodsIds;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public ResponseData addSecKillActivityConfig(SecKillActivityConfigReplaceRequestVO requestVO) {
        LoginUser user = requestVO.getLoginUser();
        Pair<List<String>, String> fail = this.check(requestVO);
        if (CollectionUtils.isNotEmpty((Collection)((Collection)fail.getLeft())) || StringUtils.isNotBlank((CharSequence)((CharSequence)fail.getRight()))) {
            return ResponseUtil.getFailedData((Object)fail.getLeft(), (String)((String)fail.getRight()));
        }
        String activityCode = this.generateCode();
        this.insertActivityConfig(requestVO, user, activityCode);
        this.insertGoods(user, requestVO.getGoodses(), activityCode, requestVO.getMerchantId());
        List<SeckillActivityGoodsSkuDTO> skus = requestVO.getGoodses().stream().map(SeckillActivityGoodsDTO::getSkus).flatMap(Collection::stream).collect(Collectors.toList());
        this.insertSkus(user, activityCode, skus, requestVO.getMerchantId());
        return ResponseUtil.getSuccessData((Object)true);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public ResponseData updateSecKillActivityConfig(SecKillActivityConfigReplaceRequestVO requestVO) {
        LoginUser user = requestVO.getLoginUser();
        Pair<List<String>, String> fail = this.check(requestVO);
        if (CollectionUtils.isNotEmpty((Collection)((Collection)fail.getLeft())) || StringUtils.isNotBlank((CharSequence)((CharSequence)fail.getRight()))) {
            return ResponseUtil.getFailedData((Object)fail.getLeft(), (String)((String)fail.getRight()));
        }
        ActivityRequestVO activity = new ActivityRequestVO();
        activity.setActivityCode(requestVO.getActivityCode());
        List<SeckillActivitySearchResponseVO> activities = this.queryActivities(activity, true, true);
        if (CollectionUtils.isEmpty(activities)) {
            return ResponseUtil.getFailedData((Object)requestVO.getActivityCode(), (String)"\u79d2\u6740\u6d3b\u52a8\u672a\u627e\u5230");
        }
        SeckillActivitySearchResponseVO vo = activities.get(0);
        if (!SeckillActivityStatus.HAVE_NOT_START.equals((Object)vo.getStatus())) {
            return ResponseUtil.getFailedData((Object)requestVO.getActivityCode(), (String)"\u6d3b\u52a8\u4e0d\u662f\u672a\u5f00\u59cb\u72b6\u6001");
        }
        this.updateActivityConfig(requestVO, user);
        List original = vo.getGoodsDTOS();
        List newGoods = requestVO.getGoodses();
        this.updateNewGoods(requestVO.getActivityCode(), user, original, newGoods, requestVO.getMerchantId());
        this.updateNewSkus(requestVO.getActivityCode(), user, original, newGoods, requestVO.getMerchantId());
        return ResponseUtil.getSuccessData((Object)true);
    }

    @Override
    public List<SeckillActivityGoodsDTO> querySecKillActivityGoods(SeckillActivityGoodsRequestVO requestVO) {
        IntegralGoodsSearchBO integralGoodsSearchBO = new IntegralGoodsSearchBO();
        integralGoodsSearchBO.setSearchValue(requestVO.getSearchValue());
        integralGoodsSearchBO.setMerchantId(requestVO.getMerchantId());
        integralGoodsSearchBO.setSysCompanyId(requestVO.getSysCompanyId());
        IntegralGoods integralGoods = new IntegralGoods();
        integralGoods.setShelf(Boolean.valueOf(true));
        integralGoods.setClassifyId(requestVO.getClassifyId());
        integralGoodsSearchBO.setIntegralGoods(integralGoods);
        List goodses = this.integralGoodsService.getGoods(integralGoodsSearchBO);
        return goodses.parallelStream().filter(goods -> Objects.equals(goods.getClubId(), requestVO.getClubId())).map(goods -> {
            SeckillActivityGoodsDTO dto = new SeckillActivityGoodsDTO();
            BeanUtils.copyProperties((Object)goods, (Object)dto);
            dto.setGoodsId(goods.getId());
            return dto;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public List<SeckillActivityGoodsSkuDTO> querySecKillSkuDetail(String activityCode, Integer goodsId) {
        List<Object> result = new ArrayList();
        if (StringUtils.isBlank((CharSequence)activityCode) && (result = this.getSkuFromIntegral(goodsId)) != null) {
            return result;
        }
        ActivityRequestVO requestVO = new ActivityRequestVO();
        requestVO.setActivityCode(activityCode);
        requestVO.setGoodsIds((List)Lists.newArrayList((Object[])new Integer[]{goodsId}));
        List<SeckillActivitySearchResponseVO> data = this.queryActivities(requestVO, true, true);
        if (CollectionUtils.isNotEmpty(data) && CollectionUtils.isNotEmpty((Collection)data.get(0).getGoodsDTOS()) && data.get(0).getGoodsDTOS().get(0) != null) {
            result = ((SeckillActivityGoodsDTO)data.get(0).getGoodsDTOS().get(0)).getSkus();
        }
        if (CollectionUtils.isEmpty(result)) {
            result = this.getSkuFromIntegral(goodsId);
        }
        return result;
    }

    @Override
    public ResponseData<SeckillActivityDetailResponseVO> secKillActivityDetail(String activityCode) {
        ActivityRequestVO requestVO = new ActivityRequestVO();
        requestVO.setActivityCode(activityCode);
        List<SeckillActivitySearchResponseVO> result = this.queryActivities(requestVO, true, true);
        if (CollectionUtils.isEmpty(result)) {
            throw new MallAdminException("\u79d2\u6740\u6d3b\u52a8\u672a\u627e\u5230");
        }
        return ResponseUtil.getSuccessData((Object)result.get(0));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Boolean disableActivity(SeckillActivityDisableRequestVO requestVO) {
        LoginUser user = requestVO.getUser();
        String activityCode = requestVO.getActivityCode();
        ActivityRequestVO activity = new ActivityRequestVO();
        activity.setActivityCode(activityCode);
        List<SeckillActivitySearchResponseVO> activities = this.queryActivities(activity, true, true);
        if (CollectionUtils.isEmpty(activities)) {
            throw new MallAdminException("\u6d3b\u52a8\u672a\u627e\u5230");
        }
        SeckillActivitySearchResponseVO vo = activities.get(0);
        if (!SeckillActivityStatus.HAVE_NOT_START.equals((Object)vo.getStatus()) && !SeckillActivityStatus.ON_GOING.equals((Object)vo.getStatus())) {
            throw new MallAdminException("\u6d3b\u52a8\u4e0d\u662f\u672a\u5f00\u59cb\u6216\u8005\u6d3b\u52a8\u4e2d\u72b6\u6001");
        }
        SecKillActivityConfigReplaceRequestVO configRequstVO = new SecKillActivityConfigReplaceRequestVO();
        configRequstVO.setActivityStatus(SeckillActivityStatus.HAS_BEEN_STOP.getCode());
        configRequstVO.setActivityCode(activityCode);
        configRequstVO.setVersion(requestVO.getVersion());
        configRequstVO.setDisabled(Integer.valueOf(1));
        this.updateActivityConfig(configRequstVO, user);
        ArrayList<SeckillActivityGoodsSkuDTO> skus = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)vo.getGoodsDTOS())) {
            skus = vo.getGoodsDTOS().stream().map(SeckillActivityGoodsDTO::getSkus).flatMap(Collection::stream).collect(Collectors.toList());
        }
        List<SeckillActivityGoodsSkuDTO> copySkus = skus.stream().map(sku -> {
            SeckillActivityGoodsSkuDTO copySku = new SeckillActivityGoodsSkuDTO();
            BeanUtils.copyProperties((Object)sku, (Object)copySku);
            copySku.setActivityStock(Integer.valueOf(0));
            copySku.setDeleted(Integer.valueOf(1));
            return copySku;
        }).collect(Collectors.toList());
        this.updateSkus(user, activityCode, copySkus, skus);
        return true;
    }

    @Override
    public List<SeckillActivitySearchResponseVO> queryActivities(ActivityRequestVO requestVO, boolean ifQueryGoods, boolean ifQuerySkus) {
        List activeActivitys = this.seckillActivityConfigMapper.queryActiveActivity(requestVO.getActivityCode(), requestVO.getStatuses());
        if (CollectionUtils.isEmpty((Collection)activeActivitys)) {
            return new ArrayList<SeckillActivitySearchResponseVO>();
        }
        List activityCodes = activeActivitys.stream().map(SeckillActivityConfigPO::getActivityCode).collect(Collectors.toList());
        Map<Object, Object> codeMapGoods = new HashMap();
        Map<Object, Object> codeMapSkus = new HashMap();
        if (ifQueryGoods) {
            List goodsPOS = this.seckillActivityGoodsMapper.queryGoodsByActivityCodes(activityCodes, requestVO.getGoodsIds());
            codeMapGoods = goodsPOS.stream().collect(Collectors.groupingBy(SeckillActivityGoodsPO::getActivityCode, Collectors.toList()));
        }
        if (ifQueryGoods && ifQuerySkus) {
            List skuPOS = this.seckillActivitySkuMapper.queryByActivityCodes(activityCodes);
            codeMapSkus = skuPOS.stream().collect(Collectors.groupingBy(SeckillActivitySkuPO::getActivityCode, Collectors.toList()));
        }
        ArrayList<SeckillActivitySearchResponseVO> result = new ArrayList<SeckillActivitySearchResponseVO>();
        for (SeckillActivityConfigPO po : activeActivitys) {
            SeckillActivitySearchResponseVO vo = new SeckillActivitySearchResponseVO();
            BeanUtils.copyProperties((Object)po, (Object)vo);
            List goodsDtos = BeanListUtil.copy((List)((List)codeMapGoods.get(po.getActivityCode())), SeckillActivityGoodsDTO.class);
            List skus = (List)codeMapSkus.get(po.getActivityCode());
            Map<Object, Object> goodsMapSkus = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)skus)) {
                goodsMapSkus = skus.stream().collect(Collectors.groupingBy(SeckillActivitySkuPO::getGoodsNo, Collectors.toList()));
            }
            for (SeckillActivityGoodsDTO goodsDto : goodsDtos) {
                List skuPos = (List)goodsMapSkus.get(goodsDto.getGoodsNo());
                goodsDto.setSkus(BeanListUtil.copy((List)skuPos, SeckillActivityGoodsSkuDTO.class));
                for (SeckillActivityGoodsSkuDTO sku : goodsDto.getSkus()) {
                    Integer stock = this.integralGoodsService.getSkuStockBySkuNo(sku.getSkuNo(), sku.getGoodsId());
                    sku.setActualStock(stock);
                }
                if (!CollectionUtils.isNotEmpty((Collection)goodsDto.getSkus()) || goodsDto.getSkus().get(0) == null) continue;
                goodsDto.setTotalStock(((SeckillActivityGoodsSkuDTO)goodsDto.getSkus().get(0)).getActualStock());
            }
            vo.setGoodsDTOS(goodsDtos);
            SeckillActivityStatus status = SeckillActivityStatus.correctStatus((Integer)po.getActivityType(), (String)po.getActivityRule(), (Long)po.getSeckillStartTime(), (Long)po.getSeckillEndTime(), (Integer)po.getDisabled());
            vo.setActivityStatusDecr(status.getMessage());
            vo.setStatus(status);
            vo.setSeckillTimeDesc(this.parseTime(po.getSeckillStartTime(), po.getSeckillEndTime()));
            vo.setGmtCreateDesc(DateUtil.format((Date)po.getGmtCreate(), (String)DateUtil.ymdhms));
            result.add(vo);
        }
        return result;
    }

    @Override
    public SeckillActivitySearchResponseVO queryActivityStatus(String activityCode) {
        ActivityRequestVO requestVO = new ActivityRequestVO();
        requestVO.setActivityCode(activityCode);
        List<SeckillActivitySearchResponseVO> responseVOS = this.queryActivities(requestVO, false, false);
        if (CollectionUtils.isEmpty(responseVOS)) {
            throw new MallAdminException("\u6d3b\u52a8\u672a\u521b\u5efa\uff0c\u7cfb\u7edf\u9519\u8bef");
        }
        SeckillActivitySearchResponseVO vo = responseVOS.get(0);
        SeckillActivityStatus status = SeckillActivityStatus.correctStatus((Integer)vo.getActivityType(), (String)vo.getActivityRule(), (Long)vo.getSeckillStartTime(), (Long)vo.getSeckillEndTime(), (Integer)vo.getDisabled());
        vo.setStatus(status);
        return vo;
    }

    public Boolean checkStock(List<SeckillActivityGoodsSkuDTO> skusForInsert, Integer goodsId, String activityCode) {
        if (CollectionUtils.isEmpty(skusForInsert)) {
            return false;
        }
        for (SeckillActivityGoodsSkuDTO skuForInsert : skusForInsert) {
            Integer stock = this.integralGoodsSkuMapper.selectStockByGoodId(goodsId, skuForInsert.getSkuNo());
            Integer originalActivityStock = this.seckillActivitySkuMapper.querySkuStock(activityCode, goodsId, skuForInsert.getSkuNo());
            if (stock != null && originalActivityStock != null && skuForInsert.getActivityStock() - originalActivityStock <= stock) continue;
            return false;
        }
        return true;
    }

    private void updateNewGoods(String activityCode, LoginUser user, List<SeckillActivityGoodsDTO> original, List<SeckillActivityGoodsDTO> newGoods, Integer merchantId) {
        List originalGoodsNo = original.stream().map(SeckillActivityGoodsDTO::getGoodsNo).collect(Collectors.toList());
        List updateGoodsNo = newGoods.stream().map(SeckillActivityGoodsDTO::getGoodsNo).collect(Collectors.toList());
        List<SeckillActivityGoodsDTO> toAdd = newGoods.stream().filter(goods -> !originalGoodsNo.contains(goods.getGoodsNo())).collect(Collectors.toList());
        List toDetele = original.stream().filter(goods -> {
            if (!updateGoodsNo.contains(goods.getGoodsNo())) {
                goods.setDeleted(Integer.valueOf(1));
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        List toAddGoodNos = toAdd.stream().map(SeckillActivityGoodsDTO::getGoodsNo).collect(Collectors.toList());
        List<SeckillActivityGoodsDTO> toUpdate = newGoods.stream().filter(goods -> !toAddGoodNos.contains(goods.getGoodsNo())).collect(Collectors.toList());
        toUpdate.addAll(toDetele);
        this.insertGoods(user, toAdd, activityCode, merchantId);
        this.updateGoods(user, toUpdate, activityCode);
    }

    private void updateNewSkus(String activityCode, LoginUser user, List<SeckillActivityGoodsDTO> original, List<SeckillActivityGoodsDTO> newGoods, Integer merchantId) {
        List<SeckillActivityGoodsSkuDTO> originalSku = original.stream().map(SeckillActivityGoodsDTO::getSkus).flatMap(Collection::stream).collect(Collectors.toList());
        List<SeckillActivityGoodsSkuDTO> newSkus = newGoods.stream().map(SeckillActivityGoodsDTO::getSkus).flatMap(Collection::stream).collect(Collectors.toList());
        List originalSkuNos = originalSku.stream().map(SeckillActivityGoodsSkuDTO::getSkuNo).collect(Collectors.toList());
        List updateSkuNos = newSkus.stream().map(SeckillActivityGoodsSkuDTO::getSkuNo).collect(Collectors.toList());
        List<SeckillActivityGoodsSkuDTO> toAddSkus = newSkus.stream().filter(sku -> !originalSkuNos.contains(sku.getSkuNo())).collect(Collectors.toList());
        List toAddSkusNo = toAddSkus.stream().map(SeckillActivityGoodsSkuDTO::getSkuNo).collect(Collectors.toList());
        List toDeleteSkus = originalSku.stream().filter(sku -> {
            if (!updateSkuNos.contains(sku.getSkuNo())) {
                sku.setDeleted(Integer.valueOf(1));
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        List toUpdateSkus = newSkus.stream().filter(sku -> !toAddSkusNo.contains(sku.getSkuNo())).collect(Collectors.toList());
        toUpdateSkus.addAll(toDeleteSkus);
        this.insertSkus(user, activityCode, toAddSkus, merchantId);
        this.updateSkus(user, activityCode, newSkus, originalSku);
    }

    private void updateGoods(LoginUser user, List<SeckillActivityGoodsDTO> goodses, String activityCode) {
        ArrayList skus = new ArrayList();
        for (SeckillActivityGoodsDTO goods : goodses) {
            SeckillActivityGoodsPO goodsPO = new SeckillActivityGoodsPO();
            BeanUtils.copyProperties((Object)goods, (Object)goodsPO);
            goodsPO.setGmtModified(new Date());
            goodsPO.setModifier(user.getNickName());
            goodsPO.setModifierId(user.getAccountCode());
            goodsPO.setActivityCode(activityCode);
            int count = this.seckillActivityGoodsMapper.updateGoods(goodsPO);
            if (count != 1) {
                throw new MallAdminException("\u4fee\u6539\u79d2\u6740\u6d3b\u52a8\u5546\u54c1\u5931\u8d25");
            }
            skus.addAll(goods.getSkus());
        }
    }

    private Pair<List<String>, String> check(SecKillActivityConfigReplaceRequestVO requestVO) {
        String errorMsg = null;
        List goodses = requestVO.getGoodses();
        List<String> failGoods = this.checkPrice(requestVO.getGoodses());
        if (CollectionUtils.isNotEmpty(failGoods)) {
            errorMsg = "\u4f20\u5165\u5546\u54c1\u4ef7\u683c\u4e3a\u7a7a";
        }
        if (requestVO.getSeckillEndTime() < requestVO.getSeckillStartTime()) {
            errorMsg = "\u79d2\u6740\u5f00\u59cb\u65f6\u95f4\u5e94\u5c0f\u4e8e\u79d2\u6740\u7ed3\u675f\u65f6\u95f4";
        }
        for (SeckillActivityGoodsDTO goods : goodses) {
            if (this.checkStock(goods.getSkus(), goods.getGoodsId(), requestVO.getActivityCode()).booleanValue()) continue;
            failGoods.add(goods.getGoodsNo());
        }
        if (CollectionUtils.isNotEmpty(failGoods)) {
            errorMsg = "\u5546\u54c1\u7684sku\u5e93\u5b58\u5df2\u7ecf\u66f4\u6539\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u6dfb\u52a0\uff01";
        }
        return Pair.of(failGoods, (Object)errorMsg);
    }

    private List<String> checkPrice(List<SeckillActivityGoodsDTO> goodses) {
        return goodses.stream().filter(goods -> goods.getActivityPrice() == null && goods.getActivityCashPrice() == null).map(SeckillActivityGoodsDTO::getGoodsNo).collect(Collectors.toList());
    }

    private void insertGoods(LoginUser user, List<SeckillActivityGoodsDTO> goodses, String activityCode, Integer merchantId) {
        if (CollectionUtils.isEmpty(goodses) || StringUtils.isBlank((CharSequence)activityCode)) {
            throw new MallAdminException("\u53c2\u6570\u9519\u8bef");
        }
        for (SeckillActivityGoodsDTO goods : goodses) {
            SeckillActivityGoodsPO goodsPO = new SeckillActivityGoodsPO();
            BeanUtils.copyProperties((Object)goods, (Object)goodsPO);
            goodsPO.setCreatorId(user.getAccountCode());
            goodsPO.setCreator(user.getNickName());
            goodsPO.setGmtCreate(new Date());
            goodsPO.setGmtModified(new Date());
            goodsPO.setModifier(user.getNickName());
            goodsPO.setModifierId(user.getAccountCode());
            goodsPO.setVersion(Integer.valueOf(0));
            goodsPO.setActivityCode(activityCode);
            goodsPO.setMerchantId(merchantId);
            int count = this.seckillActivityGoodsMapper.insertSelective((Object)goodsPO);
            if (count == 1) continue;
            throw new MallAdminException("\u6dfb\u52a0\u79d2\u6740\u6d3b\u52a8\u5546\u54c1\u5931\u8d25");
        }
    }

    private void insertSkus(LoginUser user, String activityCode, List<SeckillActivityGoodsSkuDTO> skus, Integer merchantId) {
        if (StringUtils.isBlank((CharSequence)activityCode) || CollectionUtils.isEmpty(skus)) {
            throw new MallAdminException("\u53c2\u6570\u9519\u8bef");
        }
        for (SeckillActivityGoodsSkuDTO sku : skus) {
            sku.setStock(sku.getActivityStock());
            SeckillActivitySkuPO skuPO = new SeckillActivitySkuPO();
            BeanUtils.copyProperties((Object)sku, (Object)skuPO);
            skuPO.setActivityCode(activityCode);
            skuPO.setCreatorId(user.getAccountCode());
            skuPO.setCreator(user.getNickName());
            skuPO.setGmtCreate(new Date());
            skuPO.setGmtModified(new Date());
            skuPO.setModifier(user.getNickName());
            skuPO.setModifierId(user.getAccountCode());
            skuPO.setVersion(Integer.valueOf(0));
            skuPO.setMerchantId(merchantId);
            int count = this.seckillActivitySkuMapper.insertSelective((Object)skuPO);
            if (count != 1) {
                throw new MallAdminException("\u6dfb\u52a0\u79d2\u6740\u6d3b\u52a8sku\u5931\u8d25");
            }
            this.insertRecord(user, activityCode, sku.getGoodsId(), sku.getSkuNo(), 0, sku.getActivityStock(), sku.getDeleted());
        }
        this.changeStock(skus);
    }

    private void updateSkus(LoginUser user, String activityCode, List<SeckillActivityGoodsSkuDTO> skus, List<SeckillActivityGoodsSkuDTO> originalSku) {
        Map<String, Integer> noMapStock = originalSku.stream().collect(Collectors.toMap(SeckillActivityGoodsSkuDTO::getGoodsNo, SeckillActivityGoodsSkuDTO::getActivityStock));
        for (SeckillActivityGoodsSkuDTO sku : skus) {
            sku.setStock(Integer.valueOf(sku.getActivityStock() - noMapStock.get(sku.getGoodsNo())));
            SeckillActivitySkuPO skuPO = new SeckillActivitySkuPO();
            BeanUtils.copyProperties((Object)sku, (Object)skuPO);
            skuPO.setActivityCode(activityCode);
            skuPO.setGmtModified(new Date());
            skuPO.setModifier(user.getNickName());
            skuPO.setModifierId(user.getAccountCode());
            int count = this.seckillActivitySkuMapper.updateSku(skuPO);
            if (count != 1) {
                throw new MallAdminException("\u4fee\u6539\u79d2\u6740\u6d3b\u52a8sku\u5931\u8d25");
            }
            this.insertRecord(user, activityCode, sku.getGoodsId(), sku.getSkuNo(), noMapStock.get(sku.getGoodsNo()), sku.getActivityStock(), sku.getDeleted());
        }
        this.changeStock(skus);
    }

    private void insertActivityConfig(SecKillActivityConfigReplaceRequestVO requestVO, LoginUser user, String activityCode) {
        SeckillActivityConfigPO configPO = new SeckillActivityConfigPO();
        if (requestVO.getActivityPurchaseLimit() == null) {
            configPO.setActivityPurchaseLimit(Integer.valueOf(-1));
        }
        if (requestVO.getActivityCountLimit() == null) {
            configPO.setActivityCountLimit(Integer.valueOf(-1));
        }
        BeanUtils.copyProperties((Object)requestVO, (Object)configPO);
        configPO.setActivityCode(activityCode);
        configPO.setSysBrandId(user.getBrandId());
        configPO.setSysCompanyId(user.getCompanyId());
        configPO.setActivityStatus(SeckillActivityStatus.HAVE_NOT_START.getCode());
        configPO.setCreatorId(user.getAccountCode());
        configPO.setCreator(user.getNickName());
        configPO.setGmtCreate(new Date());
        configPO.setGmtModified(new Date());
        configPO.setModifier(user.getNickName());
        configPO.setModifierId(user.getAccountCode());
        configPO.setVersion(Integer.valueOf(0));
        int count = this.seckillActivityConfigMapper.insertSelective((Object)configPO);
        if (count != 1) {
            throw new MallAdminException("\u6dfb\u52a0\u79d2\u6740\u6d3b\u52a8\u5931\u8d25");
        }
    }

    private List<SeckillActivityGoodsSkuDTO> getSkuFromIntegral(Integer goodsId) {
        IntegralGoods goods = this.integralGoodsService.getGoodsById(goodsId, IntegralGoodsSearchFormTypeEnum.pc.getType());
        if (goods != null && CollectionUtils.isNotEmpty((Collection)goods.getSkus())) {
            return goods.getSkus().stream().map(sku -> {
                SeckillActivityGoodsSkuDTO skuResult = new SeckillActivityGoodsSkuDTO();
                skuResult.setGoodsId(goodsId);
                skuResult.setGoodsName(goods.getGoodsName());
                skuResult.setSkuNo(sku.getSkuNo());
                skuResult.setGoodsNo(goods.getGoodsNo());
                skuResult.setSpecName(sku.getSpecNames());
                skuResult.setActualStock(sku.getStock());
                skuResult.setPrice(sku.getPrice());
                skuResult.setCashPrice(sku.getCashPrice());
                skuResult.setPriceType(goods.getPriceType());
                return skuResult;
            }).collect(Collectors.toList());
        }
        return new ArrayList<SeckillActivityGoodsSkuDTO>();
    }

    private void updateActivityConfig(SecKillActivityConfigReplaceRequestVO requestVO, LoginUser user) {
        SeckillActivityConfigPO configPO = new SeckillActivityConfigPO();
        BeanUtils.copyProperties((Object)requestVO, (Object)configPO);
        if (requestVO.getActivityPurchaseLimit() == null) {
            configPO.setActivityPurchaseLimit(Integer.valueOf(-1));
        }
        if (requestVO.getActivityCountLimit() == null) {
            configPO.setActivityCountLimit(Integer.valueOf(-1));
        }
        configPO.setGmtModified(new Date());
        configPO.setModifier(user.getNickName());
        configPO.setModifierId(user.getAccountCode());
        int count = this.seckillActivityConfigMapper.updateActiveActivity(configPO);
        if (count != 1) {
            throw new MallAdminException("\u4fee\u6539\u79d2\u6740\u6d3b\u52a8\u5931\u8d25");
        }
    }

    private boolean changeStock(List<SeckillActivityGoodsSkuDTO> skus) {
        List skusForUpdate = BeanListUtil.copy(skus, GoodsSkuDetail.class);
        if (CollectionUtils.isEmpty((Collection)skusForUpdate)) {
            return true;
        }
        for (GoodsSkuDetail sku : skusForUpdate) {
            int count = this.integralGoodsSkuMapper.updateStockBySkuNo(sku.getGoodsId(), sku.getSkuNo(), sku.getStock());
            if (count == 1) continue;
            throw new MallAdminException("\u6263\u51cfsku\u5e93\u5b58\u5931\u8d25\uff01sku:" + sku.getSkuNo());
        }
        return true;
    }

    private String generateCode() {
        String uuid = UUID.randomUUID().toString();
        return "NSC_" + DateUtil.getNow((String)DateUtil.yymmddHHmmss) + uuid.substring(uuid.length() - 4);
    }

    @Override
    public List<String> checkGoodsInActivity(String goodsNo, Integer merchantId) {
        List goodsPOS = this.seckillActivityGoodsMapper.queryByGoodsId(goodsNo);
        ArrayList<String> activityCodes = new ArrayList<String>();
        for (SeckillActivityGoodsPO goodsPO : goodsPOS) {
            String activityCode = goodsPO.getActivityCode();
            ActivityRequestVO requestVO = new ActivityRequestVO();
            requestVO.setActivityCode(activityCode);
            requestVO.setStatuses((List)Lists.newArrayList((Object[])new Integer[]{SeckillActivityStatus.HAVE_NOT_START.getCode(), SeckillActivityStatus.ON_GOING.getCode()}));
            List<SeckillActivitySearchResponseVO> responseVOS = this.queryActivities(requestVO, false, false);
            if (!CollectionUtils.isNotEmpty(responseVOS)) continue;
            activityCodes.add(activityCode);
        }
        return activityCodes;
    }

    @Override
    public ResponseData<Boolean> checkIfDeduct(CheckIfDeductRequestVO requestVO) {
        Integer stock = this.integralGoodsService.getSkuStockBySkuNo(requestVO.getSkuNo(), requestVO.getGoodsId());
        if (stock == null) {
            throw new MallAdminException("sku\u4fe1\u606f\u672a\u627e\u5230");
        }
        Integer result = this.seckillActivitySkuMapper.querySkuStock(requestVO.getActivityCode(), requestVO.getGoodsId(), requestVO.getSkuNo());
        if (result == null) {
            throw new MallAdminException("sku\u4fe1\u606f\u672a\u627e\u5230");
        }
        if (requestVO.getAdd().booleanValue()) {
            if (requestVO.getNum() <= stock) {
                return ResponseUtil.getSuccessData((Object)true);
            }
            return ResponseUtil.getFailedData((Object)false, (String)"\u5f85\u6dfb\u52a0\u5e93\u5b58\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u5b9e\u9645\u5e93\u5b58\u7684\u6570\u91cf");
        }
        if (requestVO.getNum() <= result) {
            return ResponseUtil.getSuccessData((Object)true);
        }
        return ResponseUtil.getFailedData((Object)false, (String)"\u5f85\u51cf\u5c11\u5e93\u5b58\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u79d2\u6740\u5e93\u5b58\u7684\u6570\u91cf");
    }

    public void insertRecord(LoginUser user, String activityCode, Integer goodsId, String skuNo, Integer beforeStock, Integer afterStock, Integer deleted) {
        SeckillActivityUpdateRecordPO po = new SeckillActivityUpdateRecordPO();
        po.setGoodsId(goodsId);
        po.setMerchantId(null);
        po.setActivityCode(activityCode);
        po.setSkuNo(skuNo);
        po.setStockBeforeUpdate(beforeStock);
        po.setStockAfterUpdate(afterStock);
        if (deleted != null && deleted == 1) {
            po.setModifier("\u5e93\u5b58\u91ca\u653e");
        } else {
            po.setModifier(user.getNickName());
        }
        po.setUpdateTime(new Date());
        this.seckillActivityUpdateRecordMapper.insertSelective((Object)po);
    }

    private String parseTime(Long begin, Long end) {
        Long beginHour = begin / 3600L;
        Long beginMinute = begin % 3600L / 60L;
        Long beginSecond = begin % 3600L % 60L;
        Long endHour = end / 3600L;
        Long endMinute = end % 3600L / 60L;
        Long endSecond = end % 3600L % 60L;
        String startTime = String.join((CharSequence)":", this.fillUp(beginHour.toString()), this.fillUp(beginMinute.toString()), this.fillUp(beginSecond.toString()));
        String endTime = String.join((CharSequence)":", this.fillUp(endHour.toString()), this.fillUp(endMinute.toString()), this.fillUp(endSecond.toString()));
        return startTime + "~" + endTime;
    }

    private String fillUp(String time) {
        if (time.length() == 1) {
            return "0" + time;
        }
        return time;
    }
}

