/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.newseckill.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrders;
import com.wmeimob.fastboot.bizvane.entity.IntegralOrdersDetails;
import com.wmeimob.fastboot.bizvane.enums.IntegralOrdersStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.integral.PayOrderStatusEnum;
import com.wmeimob.fastboot.bizvane.enums.skyworth.IntegralGoodsPriceTypeEnum;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersDetailsMapper;
import com.wmeimob.fastboot.bizvane.mapper.IntegralOrdersMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivityOrderRecordMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivitySkuMapper;
import com.wmeimob.fastboot.bizvane.po.SeckillActivityOrderRecordPO;
import com.wmeimob.fastboot.bizvane.service.BizvaneInterface;
import com.wmeimob.fastboot.bizvane.service.Integralstore.IntegralOrdersNewService;
import com.wmeimob.fastboot.bizvane.service.newseckill.SeckillActivityOrderSevice;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityBaseSearchVO;
import com.wmeimob.fastboot.bizvane.vo.integral_shop.IntegralOrderWrapperVO;
import com.wmeimob.fastboot.config.MallAdminException;
import com.wmeimob.fastboot.core.exception.CustomException;
import com.wmeimob.fastboot.core.rest.RestResult;
import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SeckillActivityOrderSeviceImpl
implements SeckillActivityOrderSevice {
    private static final Logger log = LoggerFactory.getLogger(SeckillActivityOrderSeviceImpl.class);
    @Resource
    private IntegralOrdersMapper integralOrdersMapper;
    @Resource
    private BizvaneInterface bizvaneInterface;
    @Resource
    private IntegralOrdersDetailsMapper integralOrdersDetailsMapper;
    @Resource
    private SeckillActivitySkuMapper seckillActivitySkuMapper;
    @Resource
    private SeckillActivityOrderRecordMapper seckillActivityOrderRecordMapper;
    @Lazy
    @Autowired
    private IntegralOrdersNewService integralOrdersNewService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public IntegralOrders createOrder(SeckillActivityBaseSearchVO searchVO) {
        IntegralOrders integralOrders = searchVO.getIntegralOrders();
        log.info("SeckillActivityOrderSeviceImpl:{}", (Object)JSON.toJSONString((Object)integralOrders));
        int i = this.seckillActivitySkuMapper.updateSkuStock(Long.valueOf(searchVO.getSkuId().longValue()), integralOrders.getSaleQuantity());
        if (i == 0) {
            log.error("SeckillActivityOrderSeviceImpl|createOrder|\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
            throw new MallAdminException("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
        }
        this.integralOrdersMapper.insertSelective((Object)integralOrders);
        this.integralOrdersDetailsMapper.insertSelective((Object)this.buildOrderDetails(integralOrders));
        this.seckillActivityOrderRecordMapper.insertSelective((Object)this.buildActivityRecord(integralOrders, searchVO.getActivityCode()));
        if (integralOrders.getSaleIntegral() != null && integralOrders.getSaleIntegral() > 0) {
            String changeDetail = null;
            if (IntegralOrdersStatusEnum.PAY_AWAIT.getCode().equals(integralOrders.getOrderStatus())) {
                IntegralOrderWrapperVO integralOrderWrapperVO = this.integralOrdersNewService.queryOrderWrapper(integralOrders.getId());
                BigDecimal totalFee = integralOrderWrapperVO.getTotalFee();
                Integer totalIntegral = integralOrderWrapperVO.getTotalIntegral();
                changeDetail = "\u79ef\u5206\u8ba2\u5355(\u79ef\u5206+\u73b0\u91d1):" + integralOrders.getOrderNo() + "\t\t\u73b0\u91d1:" + totalFee + "\t\t\u79ef\u5206:" + totalIntegral;
            }
            RestResult result = null;
            try {
                result = this.bizvaneInterface.consumeIntegralChange(integralOrders.getMemberCode(), Integer.valueOf(integralOrders.getSaleIntegral() * integralOrders.getSaleQuantity()), integralOrders.getOrderNo(), changeDetail);
            }
            catch (Exception e) {
                log.error("\u624b\u673a\u53f7\u4e3a:{}\u7684\u5ba2\u6237\u4e0b\u79ef\u5206\u8ba2\u5355\u6263\u51cf\u79ef\u5206\u5f02\u5e38------->\u4e0b\u5355\u5546\u54c1\u6570\u636e:{}\uff0c\u5f02\u5e38msg:{}", new Object[]{integralOrders.getMemberPhone(), integralOrders.getGoodId(), e.getMessage()});
                throw new MallAdminException("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            if (result == null || RestResult.success().getCode() != result.getCode()) {
                throw new CustomException("\u7cfb\u7edf\u5347\u7ea7\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        return integralOrders;
    }

    private IntegralOrdersDetails buildOrderDetails(IntegralOrders integralOrders) {
        IntegralOrdersDetails details = new IntegralOrdersDetails();
        details.setMerchantId(integralOrders.getMerchantId());
        details.setOrderId(integralOrders.getId());
        details.setOrderNo(integralOrders.getOrderNo());
        details.setGoodId(integralOrders.getGoodId());
        details.setGoodsSkuNo(integralOrders.getGoodSkuNo());
        details.setGoodsSkuSpecNames(integralOrders.getGoodSkuSpecNames());
        details.setSaleIntegral(integralOrders.getSaleIntegral());
        details.setPurchasePrice(integralOrders.getIntegralGoodsSku().getPurchasePrice());
        details.setSaleQuantity(integralOrders.getSaleQuantity());
        details.setSysCompanyId(integralOrders.getSysCompanyId());
        details.setGmtCreate(new Date());
        if (!IntegralGoodsPriceTypeEnum.INTEGRAL.getType().equalsIgnoreCase(integralOrders.getIntegralGoods().getPriceType())) {
            details.setSalePrice(integralOrders.getIntegralGoodsSku().getCashPrice());
            details.setCashPrice(integralOrders.getIntegralGoodsSku().getCashPrice());
        }
        return details;
    }

    private SeckillActivityOrderRecordPO buildActivityRecord(IntegralOrders order, String activityCode) {
        SeckillActivityOrderRecordPO record = new SeckillActivityOrderRecordPO();
        record.setOrderNo(order.getOrderNo());
        record.setGoodsName(order.getGoodsName());
        record.setGoodsId(order.getGoodId());
        record.setGoodsNo(order.getGoodNo());
        record.setClubId(order.getIntegralGoods().getClubId());
        record.setOrderPayStatus(PayOrderStatusEnum.PAY_SUCCESS.getCode());
        if (IntegralOrdersStatusEnum.PAY_AWAIT.getCode().equals(order.getOrderStatus())) {
            record.setOrderPayStatus(PayOrderStatusEnum.WAIT_PAY.getCode());
        }
        record.setOrderPieceNum(order.getSaleQuantity());
        record.setOrderCashNum(order.getCashPrice());
        record.setOrderIntegralNum(order.getSaleIntegral());
        record.setOrderTime(order.getOrderTime());
        record.setMemberCode(order.getMemberCode());
        record.setMerchantId(order.getMerchantId());
        record.setActivityCode(activityCode);
        return record;
    }
}

