/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.newseckill.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.wmeimob.fastboot.bizvane.enums.integral.PayOrderStatusEnum;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivityOrderRecordMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivitySkuMapper;
import com.wmeimob.fastboot.bizvane.newmapper.SeckillActivityUpdateRecordMapper;
import com.wmeimob.fastboot.bizvane.po.SeckillActivityOrderRecordPO;
import com.wmeimob.fastboot.bizvane.po.SeckillActivityStatisticsPO;
import com.wmeimob.fastboot.bizvane.service.newseckill.SeckillActivityAnalysisService;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityAnalysisDetailDTO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityAnalysisRequestVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityAnalysisResponseVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityBaseSearchVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.SeckillActivityGoodsSkuResponseVO;
import com.wmeimob.fastboot.bizvane.service.seckill.vo.StockUpdateRecordResponseVO;
import com.wmeimob.fastboot.bizvane.utils.response.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SeckillActivityAnalysisServiceImpl
implements SeckillActivityAnalysisService {
    private static final Logger log = LoggerFactory.getLogger(SeckillActivityAnalysisServiceImpl.class);
    @Resource
    SeckillActivityOrderRecordMapper activityOrderRecordMapper;
    @Resource
    SeckillActivitySkuMapper seckillActivitySkuMapper;
    @Resource
    SeckillActivityUpdateRecordMapper seckillActivityUpdateRecordMapper;

    @Override
    public Result<SeckillActivityAnalysisResponseVO> listSeckillActivityAnalysis(SeckillActivityBaseSearchVO analysisSearchVO) {
        SeckillActivityStatisticsPO statisticsPO = this.activityOrderRecordMapper.selectSeckillActivityTotalStatistics(analysisSearchVO.getActivityCode(), (List)Lists.newArrayList((Object[])new Integer[]{PayOrderStatusEnum.PAY_SUCCESS.getCode(), PayOrderStatusEnum.PAY_REFUND.getCode()}));
        if (Objects.isNull(statisticsPO)) {
            return Result.success();
        }
        log.info("listSeckillActivityAnalysis|statisticsPO:{}", (Object)JSONObject.toJSONString((Object)statisticsPO));
        SeckillActivityAnalysisResponseVO responseVO = new SeckillActivityAnalysisResponseVO();
        BeanUtils.copyProperties((Object)statisticsPO, (Object)responseVO);
        PageHelper.startPage((int)analysisSearchVO.getPageIndex(), (int)analysisSearchVO.getPageSize());
        List activityOrderRecordList = this.activityOrderRecordMapper.selectSeckillActivityStatisticsList(analysisSearchVO.getActivityCode(), PayOrderStatusEnum.PAY_SUCCESS.getCode());
        if (CollectionUtils.isEmpty((Collection)activityOrderRecordList)) {
            return Result.success();
        }
        PageInfo pageInfo = new PageInfo(activityOrderRecordList);
        log.info("listSeckillActivityAnalysis|pageInfo:{}", (Object)JSONObject.toJSONString((Object)pageInfo));
        ArrayList detailDTOList = Lists.newArrayList();
        pageInfo.getList().forEach(record -> {
            SeckillActivityAnalysisDetailDTO dto = new SeckillActivityAnalysisDetailDTO();
            BeanUtils.copyProperties((Object)record, (Object)dto);
            detailDTOList.add(dto);
        });
        responseVO.setSeckillAnalysisDetailList((List)detailDTOList);
        return Result.success((Object)responseVO, (Long)pageInfo.getTotal());
    }

    @Override
    public Result<List<SeckillActivityGoodsSkuResponseVO>> getSeckillActivityGoodsStockList(SeckillActivityBaseSearchVO analysisSearchVO) {
        PageHelper.startPage((int)analysisSearchVO.getPageIndex(), (int)analysisSearchVO.getPageSize());
        List skuPOList = this.seckillActivitySkuMapper.selectActivitySkuList(analysisSearchVO.getActivityCode(), (List)Lists.newArrayList((Object[])new Integer[]{analysisSearchVO.getGoodsId()}));
        if (CollectionUtils.isEmpty((Collection)skuPOList)) {
            return Result.success((Object)Lists.emptyList());
        }
        PageInfo pageInfo = new PageInfo(skuPOList);
        ArrayList responseVOList = Lists.newArrayList();
        pageInfo.getList().forEach(sku -> {
            SeckillActivityGoodsSkuResponseVO responseVO = new SeckillActivityGoodsSkuResponseVO();
            BeanUtils.copyProperties((Object)sku, (Object)responseVO);
            responseVOList.add(responseVO);
        });
        return Result.success((Object)responseVOList, (Long)pageInfo.getTotal());
    }

    @Override
    public Result<List<StockUpdateRecordResponseVO>> getSeckillActivityStockRecordList(SeckillActivityBaseSearchVO analysisSearchVO) {
        PageHelper.startPage((int)analysisSearchVO.getPageIndex(), (int)analysisSearchVO.getPageSize());
        List activityUpdateRecordList = this.seckillActivityUpdateRecordMapper.selectUpdateRecordList(analysisSearchVO.getActivityCode(), analysisSearchVO.getGoodsId());
        if (CollectionUtils.isEmpty((Collection)activityUpdateRecordList)) {
            return Result.success((Object)Lists.emptyList());
        }
        PageInfo pageInfo = new PageInfo(activityUpdateRecordList);
        ArrayList responseVOList = Lists.newArrayList();
        pageInfo.getList().forEach(record -> {
            StockUpdateRecordResponseVO responseVO = new StockUpdateRecordResponseVO();
            BeanUtils.copyProperties((Object)record, (Object)responseVO);
            responseVOList.add(responseVO);
        });
        return Result.success((Object)responseVOList, (Long)pageInfo.getTotal());
    }

    @Override
    public Result<Boolean> saveSeckillActivityOrderRecord(SeckillActivityAnalysisRequestVO analysisRequestVO) {
        SeckillActivityOrderRecordPO orderRecord = new SeckillActivityOrderRecordPO();
        BeanUtils.copyProperties((Object)analysisRequestVO, (Object)orderRecord);
        this.activityOrderRecordMapper.insertSelective((Object)orderRecord);
        return Result.success((Object)true);
    }

    @Override
    public Result<Boolean> updateSeckillActivityOrderRecord(SeckillActivityAnalysisRequestVO analysisRequestVO) {
        this.activityOrderRecordMapper.updateByOrderNo(analysisRequestVO.getOrderNo(), analysisRequestVO.getOrderPayStatus());
        return Result.success((Object)true);
    }
}

