/*
 * Decompiled with CFR 0.152.
 */
package com.wmeimob.fastboot.bizvane.service.marketactivity.impl;

import com.alibaba.fastjson.JSON;
import com.wmeimob.fastboot.bizvane.enums.ActivitySanEnum;
import com.wmeimob.fastboot.bizvane.enums.GoodsPreSellTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.PriceSystem;
import com.wmeimob.fastboot.bizvane.enums.activity.ActivityGoodsImportTypeEnum;
import com.wmeimob.fastboot.bizvane.enums.admin.ExportTempleHelp;
import com.wmeimob.fastboot.bizvane.enums.admin.GoodsExportTempleEnum;
import com.wmeimob.fastboot.bizvane.mapper.ActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityGoodsMapper;
import com.wmeimob.fastboot.bizvane.mapper.MarketActivityMapper;
import com.wmeimob.fastboot.bizvane.newmapper.GoodsPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.ImportTaskPOMapper;
import com.wmeimob.fastboot.bizvane.newmapper.MarketActivityGoodsPOMapper;
import com.wmeimob.fastboot.bizvane.po.GoodsPO;
import com.wmeimob.fastboot.bizvane.po.GoodsPOExample;
import com.wmeimob.fastboot.bizvane.po.MarketActivityPO;
import com.wmeimob.fastboot.bizvane.service.marketactivity.ActivityGoodsImportService;
import com.wmeimob.fastboot.bizvane.utils.LoginUtil;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseData;
import com.wmeimob.fastboot.bizvane.utils.response.ResponseUtil;
import com.wmeimob.fastboot.bizvane.vo.activity.MarketActivityGoodsImportGoodsResponseVO;
import com.wmeimob.fastboot.bizvane.vo.activity.MarketActivityGoodsImportRequestVO;
import com.wmeimob.fastboot.bizvane.vo.activity.MarketActivityGoodsImportResponseVO;
import com.wmeimob.fastboot.bizvane.vo.admin.ErrorExportMessageVO;
import com.wmeimob.fastboot.bizvane.vo.seckill.MarketActivityRepeatGoodsVO;
import com.wmeimob.fastboot.config.MallAdminException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ActivityGoodsImportImpl
implements ActivityGoodsImportService {
    private static final Logger log = LoggerFactory.getLogger(ActivityGoodsImportImpl.class);
    @Resource
    private LoginUtil loginUtil;
    @Resource
    private ImportTaskPOMapper importTaskPOMapper;
    @Resource
    private GoodsPOMapper goodsPOMapper;
    @Resource
    private ActivityGoodsMapper activityGoodsMapper;
    @Resource
    private MarketActivityMapper marketActivityMapper;
    @Resource
    private MarketActivityGoodsMapper marketActivityGoodsMapper;
    @Resource
    private MarketActivityGoodsPOMapper marketActivityGoodsPOMapper;

    @Override
    @Transactional
    public ResponseData marketGoodsImport(MarketActivityGoodsImportRequestVO vo) throws Exception {
        log.info("ActivityGoodsImportImpl#marketGoodsImport:{}", (Object)JSON.toJSONString((Object)vo));
        URL url = new URL(vo.getFileUrl());
        InputStream is = url.openConnection().getInputStream();
        if (is == null) {
            throw new MallAdminException("\u65e0\u5185\u5bb9,\u5bfc\u5165\u5904\u7406\u5931\u8d25!");
        }
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((InputStream)is);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u6587\u4ef6\u5931\u8d25:", (Throwable)e);
            throw new MallAdminException("\u89e3\u6790\u6587\u4ef6\u5931\u8d25,\u8bf7\u786e\u5b9a\u4e0a\u4f20\u4e86\u6b63\u786e\u6587\u4ef6!");
        }
        finally {
            is.close();
        }
        Sheet firstSheet = wb.getSheetAt(0);
        int lastRowNum = firstSheet.getLastRowNum();
        log.info("\u6700\u540e\u4e00\u884c\u884c\u53f7:{}", (Object)lastRowNum);
        if (lastRowNum > 50001) {
            throw new MallAdminException("\u6587\u6863\u5185\u5bb9\u8d85\u8fc750000\u6761,\u8bf7\u624b\u52a8\u62c6\u5206\u6587\u6863\u540e\u518d\u4e0a\u4f20");
        }
        ExportTempleHelp exportTempleHelp = GoodsExportTempleEnum.getExportTempleHelp();
        List notesList = exportTempleHelp.getNotesList();
        Row firstSheetRow = firstSheet.getRow(0);
        String header = firstSheetRow.getCell(0).getStringCellValue();
        if (StringUtils.isEmpty((Object)header)) {
            throw new MallAdminException("\u8868\u5934\u6709\u7a7a\u5217,\u8bf7\u91cd\u65b0\u67e5\u770b\u6587\u4ef6\u540e\u4e0a\u4f20");
        }
        if (!header.trim().equalsIgnoreCase(GoodsExportTempleEnum.GOODS_NO.getNote())) {
            throw new MallAdminException("\u8868\u5934\u4fe1\u606f\u6709\u8bef,\u8bf7\u4f7f\u7528\u6b63\u786e\u6a21\u677f\u6587\u4ef6");
        }
        ArrayList<MarketActivityGoodsImportGoodsResponseVO> successGoodsImportTempleVOList = new ArrayList<MarketActivityGoodsImportGoodsResponseVO>(50001);
        ArrayList<ErrorExportMessageVO> errorGoodsImportTempleVOList = new ArrayList<ErrorExportMessageVO>(50001);
        HashSet<String> goodsNames = new HashSet<String>();
        for (int i = 1; i <= lastRowNum; ++i) {
            ErrorExportMessageVO errorExportMessageVO = new ErrorExportMessageVO();
            Row row = firstSheet.getRow(i);
            if (row == null) continue;
            String goodsNo = this.getValue(row.getCell(0)).trim();
            if (StringUtils.isEmpty((Object)goodsNo)) {
                log.info("poi\u8bc6\u522b\u5230\u6570\u636e\u4e3a\u7a7a,\u884c\u53f7:{}", (Object)i);
                continue;
            }
            if (goodsNames.contains(goodsNo)) {
                errorExportMessageVO = this.createErrorMsg("excel\u4e2d\u5546\u54c1\u91cd\u590d", goodsNo, i);
                errorGoodsImportTempleVOList.add(errorExportMessageVO);
                continue;
            }
            goodsNames.add(goodsNo);
            GoodsPOExample checkGoodsIsAvailable = new GoodsPOExample();
            checkGoodsIsAvailable.createCriteria().andValidEqualTo(Boolean.TRUE).andIsDelEqualTo(Boolean.FALSE).andGoodsNoEqualTo(goodsNo).andMerchantIdEqualTo(vo.getMerchantId());
            List goodsPOList = this.goodsPOMapper.selectByExample(checkGoodsIsAvailable);
            if (CollectionUtils.isEmpty((Collection)goodsPOList)) {
                errorExportMessageVO = this.createErrorMsg("\u8be5\u5546\u54c1\u65e0\u6548\u6216\u8005\u88ab\u5220\u9664", goodsNo, i);
                errorGoodsImportTempleVOList.add(errorExportMessageVO);
                continue;
            }
            if (goodsPOList.size() > 1) {
                errorExportMessageVO = this.createErrorMsg("\u5e93\u4e2d\u8be5\u5546\u54c1\u7f16\u53f7\u91cd\u590d", goodsNo, i);
                errorGoodsImportTempleVOList.add(errorExportMessageVO);
                continue;
            }
            Integer gift = 1;
            GoodsPO goodsPO = (GoodsPO)goodsPOList.get(0);
            if (!ActivityGoodsImportTypeEnum.FULL_GIFT.getCode().equals(vo.getMarketType()) && gift.equals(goodsPO.getIsGift())) {
                errorExportMessageVO = this.createErrorMsg("\u8be5\u5546\u54c1\u662f\u8d60\u54c1", goodsNo, i);
                errorGoodsImportTempleVOList.add(errorExportMessageVO);
                continue;
            }
            if (!GoodsPreSellTypeEnum.NONE.getCode().equals(goodsPO.getPresellType())) {
                errorExportMessageVO = this.createErrorMsg("\u8be5\u5546\u54c1\u9884\u552e\u5546\u54c1", goodsNo, i);
                errorGoodsImportTempleVOList.add(errorExportMessageVO);
                continue;
            }
            if (ActivityGoodsImportTypeEnum.FULL_REDUCTION.getCode().equals(vo.getMarketType())) {
                List activities = this.activityGoodsMapper.selectActivityByGoodId(goodsPO.getId(), ActivitySanEnum.FULL_REDUCTION.getCode());
                if (!CollectionUtils.isEmpty((Collection)activities)) {
                    errorExportMessageVO = this.createErrorMsg("\u8be5\u5546\u54c1\u53c2\u4e0e\u6ee1\u51cf\u6d3b\u52a8\uff0c\u6d3b\u52a8\u540d\u79f0", goodsNo, i);
                    errorGoodsImportTempleVOList.add(errorExportMessageVO);
                    continue;
                }
                if (!goodsPO.getIsShelved().booleanValue()) {
                    errorExportMessageVO = this.createErrorMsg("\u8be5\u5546\u54c1\u672a\u4e0a\u67b6", goodsNo, i);
                    errorGoodsImportTempleVOList.add(errorExportMessageVO);
                    continue;
                }
                if (!PriceSystem.MONEY.getCode().equals(goodsPO.getPriceSystem())) {
                    errorExportMessageVO = this.createErrorMsg("\u6ee1\u51cf\u975e\u7eaf\u73b0\u91d1\u4ef7\u683c", goodsNo, i);
                    errorGoodsImportTempleVOList.add(errorExportMessageVO);
                    continue;
                }
            } else if (ActivityGoodsImportTypeEnum.FULL_GIFT.getCode().equals(vo.getMarketType())) {
                if (!gift.equals(goodsPO.getIsGift())) {
                    errorExportMessageVO = this.createErrorMsg("\u4e70\u8d60\u6d3b\u52a8\u5546\u54c1\u4e0d\u662f\u8d60\u54c1", goodsNo, i);
                    errorGoodsImportTempleVOList.add(errorExportMessageVO);
                    continue;
                }
            } else if (ActivityGoodsImportTypeEnum.SEC_KILL.getCode().equals(vo.getMarketType())) {
                if (!PriceSystem.MONEY.getCode().equals(goodsPO.getPriceSystem())) {
                    errorExportMessageVO = this.createErrorMsg("\u79d2\u6740\u5546\u54c1\u4e0d\u662f\u7eaf\u73b0\u91d1", goodsNo, i);
                    errorGoodsImportTempleVOList.add(errorExportMessageVO);
                    continue;
                }
                if (!goodsPO.getIsShelved().booleanValue()) {
                    errorExportMessageVO = this.createErrorMsg("\u8be5\u5546\u54c1\u672a\u4e0a\u67b6", goodsNo, i);
                    errorGoodsImportTempleVOList.add(errorExportMessageVO);
                    continue;
                }
                MarketActivityRepeatGoodsVO marketActivityRepeatGoodsVO = new MarketActivityRepeatGoodsVO();
                marketActivityRepeatGoodsVO.setGoodsId(goodsPO.getId());
                marketActivityRepeatGoodsVO.setMerchantId(vo.getMerchantId());
                marketActivityRepeatGoodsVO.setStartDate(vo.getStartTime());
                marketActivityRepeatGoodsVO.setEndDate(vo.getStartTime());
                List marketActivityPOS = this.marketActivityGoodsPOMapper.queryOnGoingInMarketActivity(marketActivityRepeatGoodsVO);
                if (!CollectionUtils.isEmpty((Collection)marketActivityPOS)) {
                    MarketActivityPO marketActivityPOOnGoing = (MarketActivityPO)marketActivityPOS.get(0);
                    String errorMsg = "goodsNo:" + goodsNo + "\u5df2\u5728\u6d3b\u52a8:" + marketActivityPOOnGoing.getActivityNo() + "\u4e2d\u4f7f\u7528\uff0c\u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0";
                    log.error("errorMsg:{}", (Object)errorMsg);
                    errorExportMessageVO = this.createErrorMsg(errorMsg, goodsNo, i);
                    errorGoodsImportTempleVOList.add(errorExportMessageVO);
                    continue;
                }
            } else if (ActivityGoodsImportTypeEnum.GROUP_BOOKING.getCode().equals(vo.getMarketType())) {
                if (!PriceSystem.MONEY.getCode().equals(goodsPO.getPriceSystem())) {
                    errorExportMessageVO = this.createErrorMsg("\u62fc\u56e2\u5546\u54c1\u4e0d\u662f\u7eaf\u73b0\u91d1", goodsNo, i);
                    errorGoodsImportTempleVOList.add(errorExportMessageVO);
                    continue;
                }
                if (!goodsPO.getIsShelved().booleanValue()) {
                    errorExportMessageVO = this.createErrorMsg("\u62fc\u56e2\u5546\u54c1\u672a\u4e0a\u67b6", goodsNo, i);
                    errorGoodsImportTempleVOList.add(errorExportMessageVO);
                    continue;
                }
            } else if (ActivityGoodsImportTypeEnum.BARGAIN.getCode().equals(vo.getMarketType())) {
                if (!PriceSystem.MONEY.getCode().equals(goodsPO.getPriceSystem())) {
                    errorExportMessageVO = this.createErrorMsg("\u780d\u4ef7\u5546\u54c1\u4e0d\u662f\u7eaf\u73b0\u91d1", goodsNo, i);
                    errorGoodsImportTempleVOList.add(errorExportMessageVO);
                    continue;
                }
                if (!goodsPO.getIsShelved().booleanValue()) {
                    errorExportMessageVO = this.createErrorMsg("\u780d\u4ef7\u5546\u54c1\u672a\u4e0a\u67b6", goodsNo, i);
                    errorGoodsImportTempleVOList.add(errorExportMessageVO);
                    continue;
                }
            }
            MarketActivityGoodsImportGoodsResponseVO responseVO = this.copyPro(goodsPO);
            log.info("\u6210\u529f\u5546\u54c1\uff1a{}", (Object)JSON.toJSONString((Object)responseVO));
            BeanUtils.copyProperties((Object)responseVO, (Object)goodsPO);
            responseVO.setMarketActivityGoodsMainName(goodsPO.getGoodsName());
            successGoodsImportTempleVOList.add(responseVO);
        }
        log.info("\u6210\u529f:{}", (Object)JSON.toJSONString(successGoodsImportTempleVOList));
        log.info("\u5931\u8d25:{}", (Object)JSON.toJSONString(errorGoodsImportTempleVOList));
        MarketActivityGoodsImportResponseVO result = new MarketActivityGoodsImportResponseVO();
        result.setSuccessGoodsExportTempleVOList(successGoodsImportTempleVOList);
        result.setErrorGoodsExportTempleVOList(errorGoodsImportTempleVOList);
        return ResponseUtil.getSuccessData((Object)result);
    }

    private ErrorExportMessageVO createErrorMsg(String msg, String goodsNo, Integer index) {
        ErrorExportMessageVO errorExportMessageVO = new ErrorExportMessageVO();
        errorExportMessageVO.setGoodsNo(goodsNo);
        errorExportMessageVO.setIndex(index);
        errorExportMessageVO.setErrorMsg(msg);
        return errorExportMessageVO;
    }

    private MarketActivityGoodsImportGoodsResponseVO copyPro(GoodsPO good) {
        MarketActivityGoodsImportGoodsResponseVO responseVO = new MarketActivityGoodsImportGoodsResponseVO();
        responseVO.setId(good.getId());
        responseVO.setGoodsName(good.getGoodsName());
        responseVO.setGoodsNo(good.getGoodsNo());
        responseVO.setMarketPrice(good.getMarketPrice());
        responseVO.setSalePrice(good.getSalePrice());
        responseVO.setIsDel(good.getIsDel());
        responseVO.setStock(good.getStock());
        responseVO.setMerchantId(good.getMerchantId());
        return responseVO;
    }

    private String getValue(Cell cell) {
        String value = "";
        if (cell == null) {
            return value;
        }
        int cellType = cell.getCellType();
        switch (cellType) {
            case 0: {
                value = NumberToTextConverter.toText((double)cell.getNumericCellValue());
                break;
            }
            case 1: {
                value = cell.getStringCellValue();
            }
        }
        return value;
    }
}

